/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerTextField
extends JTextField {
    private static final long serialVersionUID = -720882764279734721L;
    private Integer defaultValue = new Integer(0);
    private IntegerDocument intDoc = new IntegerDocument();

    public IntegerTextField() {
        this.init();
        this.setText("0");
    }

    public IntegerTextField(String text) {
        this.init();
        this.setText(text);
    }

    public IntegerTextField(int value) {
        this.init();
        this.setText(Integer.toString(value));
    }

    public IntegerTextField(Integer objInt) {
        this.init();
        this.setText(objInt.toString());
    }

    public void setDefaultValue(Integer newDefaultValue) {
        this.defaultValue = newDefaultValue;
    }

    public Integer getDefaultValue() {
        return this.defaultValue;
    }

    public void setText(String text) {
        Integer newValue = this.defaultValue;
        if (text.length() != 0) {
            try {
                newValue = new Integer(Integer.parseInt(text));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        super.setText(newValue.toString());
    }

    public String getText() {
        return this.getValue().toString();
    }

    public Integer getValue() {
        String content = super.getText();
        if (content.length() != 0) {
            try {
                Integer retval = new Integer(Integer.parseInt(content));
                return retval;
            }
            catch (NumberFormatException nfe) {
                return this.defaultValue;
            }
        }
        return this.defaultValue;
    }

    private void init() {
        this.setDocument(this.intDoc);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                IntegerTextField textField = (IntegerTextField)e.getSource();
                String content = textField.getText();
                if (content.length() != 0) {
                    try {
                        Integer.parseInt(content);
                    }
                    catch (NumberFormatException nfe) {
                        IntegerTextField.this.getToolkit().beep();
                        textField.setText(textField.getDefaultValue().toString());
                    }
                } else {
                    textField.setText(textField.getDefaultValue().toString());
                }
            }
        });
    }

    static class IntegerDocument
    extends PlainDocument {
        private static final long serialVersionUID = 2489150714777102558L;

        IntegerDocument() {
        }

        public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
            String newValue;
            if (string == null) {
                return;
            }
            int length = this.getLength();
            if (length == 0) {
                newValue = string;
            } else {
                String currentContent = this.getText(0, length);
                StringBuilder currentBuffer = new StringBuilder(currentContent);
                currentBuffer.insert(offset, string);
                newValue = currentBuffer.toString();
            }
            if (newValue.equals("-")) {
                super.insertString(offset, newValue, attributes);
                return;
            }
            try {
                Integer.parseInt(newValue);
                super.insertString(offset, string, attributes);
            }
            catch (NumberFormatException exception) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

