/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.properties;

import animalscriptapi.properties.items.AnimationPropertyItem;
import animalscriptapi.properties.items.StringPropertyItem;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnimationProperties {
    protected HashMap<String, AnimationPropertyItem> data = new HashMap();
    private HashMap<String, Object> defaults = new HashMap();
    private HashMap<String, Boolean> isEditable = new HashMap();
    private HashMap<String, String> labels = new HashMap();

    public AnimationProperties() {
        this("Some unknown Property");
    }

    public AnimationProperties(String name) {
        this.setName(name);
    }

    public void setName(String newName) {
        StringPropertyItem nameItem = new StringPropertyItem();
        nameItem.set(newName);
        this.data.put("name", nameItem);
        this.defaults.put("name", "Some unknown Property");
        this.isEditable.put("name", false);
        this.labels.put("name", "Name");
    }

    protected abstract void fillHashMap();

    public void fillAdditional() {
        for (String temp : this.data.keySet()) {
            this.defaults.put(temp, this.data.get(temp).clone());
            this.isEditable.put(temp, true);
            this.labels.put(temp, "");
        }
    }

    public String toString() {
        return this.get("name").toString();
    }

    public Set<String> getAllPropertyNames() {
        return this.data.keySet();
    }

    public Vector<String> getAllPropertyNamesVector() {
        Set<String> keySet = this.data.keySet();
        Iterator<String> iterator = keySet.iterator();
        Vector<String> vec = new Vector<String>(keySet.size());
        while (iterator.hasNext()) {
            vec.add(iterator.next());
        }
        return vec;
    }

    public static final Vector<String> getAllPropertyTypes() {
        Vector<String> classes = new Vector<String>();
        classes.add("ArcProperties");
        classes.add("ArrayProperties");
        classes.add("ArrayMarkerProperties");
        classes.add("CircleProperties");
        classes.add("CircleSegProperties");
        classes.add("EllipseProperties");
        classes.add("ListElementProperties");
        classes.add("PolygonProperties");
        classes.add("PolylineProperties");
        classes.add("RectProperties");
        classes.add("SourceCodeProperties");
        classes.add("SquareProperties");
        classes.add("StackProperties");
        classes.add("TextProperties");
        classes.add("TriangleProperties");
        classes.add("CallMethodProperties");
        return classes;
    }

    public AnimationPropertyItem getItem(String key) throws IllegalArgumentException {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        return this.data.get(key);
    }

    public void set(String key, int value) throws IllegalArgumentException {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        this.data.get(key).set(value);
    }

    public void set(String key, String value) throws IllegalArgumentException {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        this.data.get(key).set(value);
    }

    public void set(String key, boolean value) throws IllegalArgumentException {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        this.data.get(key).set(value);
    }

    public void set(String key, Color value) throws IllegalArgumentException {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        this.data.get(key).set(value);
    }

    public void set(String key, Font value) throws IllegalArgumentException {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        this.data.get(key).set(value);
    }

    public void set(String key, Object value) throws IllegalArgumentException {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        this.data.get(key).set(value);
    }

    public Object get(String key) throws IllegalArgumentException {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        return this.data.get(key).get();
    }

    public AnimationPropertyItem getDefault(String key) throws IllegalArgumentException {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        return (AnimationPropertyItem)this.defaults.get(key);
    }

    public void setDefault(String key, AnimationPropertyItem value) throws IllegalArgumentException {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        this.defaults.put(key, value);
    }

    public boolean getIsEditable(String key) throws IllegalArgumentException {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        return this.isEditable.get(key);
    }

    public void setIsEditable(String key, boolean value) throws IllegalArgumentException {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        this.isEditable.put(key, value);
    }

    public String getLabel(String key) throws IllegalArgumentException {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        return this.labels.get(key);
    }

    public void setLabel(String key, String value) {
        if (!this.data.containsKey(key)) {
            throw new IllegalArgumentException("The given key '" + key + "' was not found!");
        }
        this.labels.put(key, value);
    }
}

