/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.primitives;

import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.generators.RectGenerator;
import animalscriptapi.properties.RectProperties;
import animalscriptapi.util.DisplayOptions;
import animalscriptapi.util.Node;

public class Rect
extends Primitive {
    private RectGenerator generator = null;
    private RectProperties properties = null;
    private Node upperLeft = null;
    private Node lowerRight = null;

    public Rect(RectGenerator rg, Node upperLeftCorner, Node lowerRightCorner, String name, DisplayOptions display, RectProperties rp) throws IllegalArgumentException {
        super(rg, display);
        if (upperLeftCorner == null || lowerRightCorner == null) {
            throw new IllegalArgumentException("The coordinates shouldn't be null");
        }
        this.generator = rg;
        this.upperLeft = upperLeftCorner;
        this.lowerRight = lowerRightCorner;
        this.properties = rp;
        this.setName(name);
        this.generator.create(this);
    }

    public Node getUpperLeft() {
        return this.upperLeft;
    }

    public Node getLowerRight() {
        return this.lowerRight;
    }

    public RectProperties getProperties() {
        return this.properties;
    }

    public void setName(String newName) {
        this.properties.setName(newName);
        super.setName(newName);
    }
}

