/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.primitives;

import animalscriptapi.primitives.VisualStack;
import animalscriptapi.primitives.generators.ListBasedStackGenerator;
import animalscriptapi.properties.StackProperties;
import animalscriptapi.util.DisplayOptions;
import animalscriptapi.util.Node;
import animalscriptapi.util.Timing;
import java.util.EmptyStackException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBasedStack<T>
extends VisualStack<T> {
    private ListBasedStackGenerator<T> generator;

    public ListBasedStack(ListBasedStackGenerator<T> lbsg, Node upperLeftCorner, List<T> content, String name, DisplayOptions display, StackProperties sp) {
        super(lbsg, upperLeftCorner, content, name, display, sp);
        this.generator = lbsg;
        this.generator.create(this);
    }

    public void push(T elem, Timing delay, Timing duration) {
        super.push(elem);
        this.generator.push(this, elem, delay, duration);
    }

    public T pop(Timing delay, Timing duration) {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        this.generator.pop(this, delay, duration);
        return super.pop();
    }

    public T top(Timing delay, Timing duration) {
        if (this.isEmpty()) {
            throw new EmptyStackException();
        }
        this.generator.top(this, delay, duration);
        return super.top();
    }

    public boolean isEmpty(Timing delay, Timing duration) {
        this.generator.isEmpty(this, delay, duration);
        return super.isEmpty();
    }

    public void highlightTopElem(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.highlightTopElem(this, delay, duration);
        }
    }

    public void unhighlightTopElem(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.unhighlightTopElem(this, delay, duration);
        }
    }

    public void highlightTopCell(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.highlightTopCell(this, delay, duration);
        }
    }

    public void unhighlightTopCell(Timing delay, Timing duration) {
        if (!this.isEmpty()) {
            this.generator.unhighlightTopCell(this, delay, duration);
        }
    }
}

