/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.Triangle;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.primitives.generators.TriangleGenerator;
import animalscriptapi.properties.TriangleProperties;
import animalscriptapi.util.Node;
import java.awt.Color;

public class AnimalTriangleGenerator
extends AnimalGenerator
implements TriangleGenerator {
    private static int count = 1;

    public AnimalTriangleGenerator(Language aLang) {
        super(aLang);
    }

    public void create(Triangle t) {
        if (this.isNameUsed(t.getName()) || t.getName() == "") {
            t.setName("Triangle" + count);
            ++count;
        }
        this.lang.addItem(t);
        StringBuilder str = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        str.append("triangle \"" + t.getName() + "\" ");
        Node[] p = t.getNodes();
        str.append(AnimalGenerator.makeNodeDef(p[0]));
        str.append(" " + AnimalGenerator.makeNodeDef(p[1]));
        str.append(" " + AnimalGenerator.makeNodeDef(p[2]));
        TriangleProperties props = t.getProperties();
        if (props.get("color") != null) {
            str.append(" color ");
            str.append(AnimalGenerator.makeColorDef(((Color)props.get("color")).getRed(), ((Color)props.get("color")).getGreen(), ((Color)props.get("color")).getBlue()));
        }
        if (props.get("depth") != null) {
            str.append(" depth " + ((Integer)props.get("depth")).toString());
        }
        if (props.get("filled") != null && ((Boolean)props.get("filled")).booleanValue()) {
            str.append(" filled");
            if (props.get("fillColor") != null) {
                str.append(" fillColor ");
                str.append(AnimalGenerator.makeColorDef(((Color)props.get("fillColor")).getRed(), ((Color)props.get("fillColor")).getGreen(), ((Color)props.get("fillColor")).getBlue()));
            }
        }
        str.append(AnimalGenerator.makeDisplayOptionsDef(t.getDisplayOptions(), props));
        this.lang.addLine(str);
    }
}

