/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AVInteractionTextGenerator;
import animalscriptapi.animalscript.AnimalArcGenerator;
import animalscriptapi.animalscript.AnimalArrayBasedQueueGenerator;
import animalscriptapi.animalscript.AnimalArrayBasedStackGenerator;
import animalscriptapi.animalscript.AnimalArrayMarkerGenerator;
import animalscriptapi.animalscript.AnimalCircleGenerator;
import animalscriptapi.animalscript.AnimalCircleSegGenerator;
import animalscriptapi.animalscript.AnimalConceptualQueueGenerator;
import animalscriptapi.animalscript.AnimalConceptualStackGenerator;
import animalscriptapi.animalscript.AnimalEllipseGenerator;
import animalscriptapi.animalscript.AnimalGraphGenerator;
import animalscriptapi.animalscript.AnimalGroupGenerator;
import animalscriptapi.animalscript.AnimalIntArrayGenerator;
import animalscriptapi.animalscript.AnimalIntMatrixGenerator;
import animalscriptapi.animalscript.AnimalJHAVETextInteractionGenerator;
import animalscriptapi.animalscript.AnimalListBasedQueueGenerator;
import animalscriptapi.animalscript.AnimalListBasedStackGenerator;
import animalscriptapi.animalscript.AnimalListElementGenerator;
import animalscriptapi.animalscript.AnimalPointGenerator;
import animalscriptapi.animalscript.AnimalPolygonGenerator;
import animalscriptapi.animalscript.AnimalPolylineGenerator;
import animalscriptapi.animalscript.AnimalRectGenerator;
import animalscriptapi.animalscript.AnimalSourceCodeGenerator;
import animalscriptapi.animalscript.AnimalSquareGenerator;
import animalscriptapi.animalscript.AnimalStringArrayGenerator;
import animalscriptapi.animalscript.AnimalStringMatrixGenerator;
import animalscriptapi.animalscript.AnimalTextGenerator;
import animalscriptapi.animalscript.AnimalTriangleGenerator;
import animalscriptapi.exceptions.NotEnoughNodesException;
import animalscriptapi.interactionsupport.DocumentationLink;
import animalscriptapi.interactionsupport.InteractiveElement;
import animalscriptapi.interactionsupport.MultipleChoiceQuestion;
import animalscriptapi.interactionsupport.MultipleSelectionQuestion;
import animalscriptapi.interactionsupport.TrueFalseQuestion;
import animalscriptapi.interactionsupport.generators.InteractiveElementGenerator;
import animalscriptapi.primitives.Arc;
import animalscriptapi.primitives.ArrayBasedQueue;
import animalscriptapi.primitives.ArrayBasedStack;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.ArrayPrimitive;
import animalscriptapi.primitives.Circle;
import animalscriptapi.primitives.CircleSeg;
import animalscriptapi.primitives.ConceptualQueue;
import animalscriptapi.primitives.ConceptualStack;
import animalscriptapi.primitives.Ellipse;
import animalscriptapi.primitives.Graph;
import animalscriptapi.primitives.Group;
import animalscriptapi.primitives.IntArray;
import animalscriptapi.primitives.IntMatrix;
import animalscriptapi.primitives.ListBasedQueue;
import animalscriptapi.primitives.ListBasedStack;
import animalscriptapi.primitives.ListElement;
import animalscriptapi.primitives.Point;
import animalscriptapi.primitives.Polygon;
import animalscriptapi.primitives.Polyline;
import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.SourceCode;
import animalscriptapi.primitives.Square;
import animalscriptapi.primitives.StringArray;
import animalscriptapi.primitives.StringMatrix;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.Triangle;
import animalscriptapi.primitives.generators.ArcGenerator;
import animalscriptapi.primitives.generators.ArrayMarkerGenerator;
import animalscriptapi.primitives.generators.CircleGenerator;
import animalscriptapi.primitives.generators.CircleSegGenerator;
import animalscriptapi.primitives.generators.EllipseGenerator;
import animalscriptapi.primitives.generators.GraphGenerator;
import animalscriptapi.primitives.generators.GroupGenerator;
import animalscriptapi.primitives.generators.IntArrayGenerator;
import animalscriptapi.primitives.generators.IntMatrixGenerator;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.primitives.generators.ListElementGenerator;
import animalscriptapi.primitives.generators.PointGenerator;
import animalscriptapi.primitives.generators.PolygonGenerator;
import animalscriptapi.primitives.generators.PolylineGenerator;
import animalscriptapi.primitives.generators.RectGenerator;
import animalscriptapi.primitives.generators.SourceCodeGenerator;
import animalscriptapi.primitives.generators.SquareGenerator;
import animalscriptapi.primitives.generators.StringArrayGenerator;
import animalscriptapi.primitives.generators.StringMatrixGenerator;
import animalscriptapi.primitives.generators.TextGenerator;
import animalscriptapi.primitives.generators.TriangleGenerator;
import animalscriptapi.properties.ArcProperties;
import animalscriptapi.properties.ArrayMarkerProperties;
import animalscriptapi.properties.ArrayProperties;
import animalscriptapi.properties.CircleProperties;
import animalscriptapi.properties.CircleSegProperties;
import animalscriptapi.properties.EllipseProperties;
import animalscriptapi.properties.GraphProperties;
import animalscriptapi.properties.ListElementProperties;
import animalscriptapi.properties.MatrixProperties;
import animalscriptapi.properties.PointProperties;
import animalscriptapi.properties.PolygonProperties;
import animalscriptapi.properties.PolylineProperties;
import animalscriptapi.properties.QueueProperties;
import animalscriptapi.properties.RectProperties;
import animalscriptapi.properties.SourceCodeProperties;
import animalscriptapi.properties.SquareProperties;
import animalscriptapi.properties.StackProperties;
import animalscriptapi.properties.TextProperties;
import animalscriptapi.properties.TriangleProperties;
import animalscriptapi.util.ArrayDisplayOptions;
import animalscriptapi.util.DisplayOptions;
import animalscriptapi.util.Node;
import java.io.FileWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimalScript
extends Language {
    public static int INITIAL_STEPBUFFER_SIZE = 4096;
    public static int INITIAL_OUTPUTBUFFER_SIZE = 32768;
    public static int INITIAL_GENBUFFER_SIZE = 1024;
    public static int INITIAL_ERRORBUFFER_SIZE = 4096;
    public static final String DIRECTION_NW = "NW";
    public static final String DIRECTION_N = "N";
    public static final String DIRECTION_NE = "NE";
    public static final String DIRECTION_W = "W";
    public static final String DIRECTION_C = "C";
    public static final String DIRECTION_E = "E";
    public static final String DIRECTION_SW = "SW";
    public static final String DIRECTION_S = "S";
    public static final String DIRECTION_SE = "SE";
    public static final String DIRECTION_BASELINE_START = "baseline start";
    public static final String DIRECTION_BASELINE_END = "baseline end";
    public static final String COLORCHANGE_COLOR = "color";
    public static final String COLORCHANGE_FILLCOLOR = "fillColor";
    public static final String COLORCHANGE_TEXTCOLOR = "textColor";
    public static final String COLORCHANGE_COLORSETTING = "colorSetting";
    private boolean stepMode = false;
    private StringBuilder output = new StringBuilder(INITIAL_OUTPUTBUFFER_SIZE);
    private StringBuilder stepBuffer = new StringBuilder(INITIAL_STEPBUFFER_SIZE);
    private StringBuilder errorBuffer = new StringBuilder(INITIAL_ERRORBUFFER_SIZE);
    private Vector<String> names = new Vector();
    private ArcGenerator arcGen = null;
    private CircleGenerator circleGen = null;
    private CircleSegGenerator circleSegGen = null;
    private EllipseGenerator ellipseGen = null;
    private GraphGenerator graphGen = null;
    private IntArrayGenerator intArrayGen = null;
    private IntMatrixGenerator intMatrixGen = null;
    private ListElementGenerator listElemGen = null;
    private RectGenerator rectGen = null;
    private SourceCodeGenerator sourceGen = null;
    private SquareGenerator squareGen = null;
    private StringArrayGenerator stringArrayGen = null;
    private StringMatrixGenerator stringMatrixGen = null;
    private TextGenerator textGen = null;
    private TriangleGenerator triangleGen = null;
    private PolygonGenerator polygonGen = null;
    private PointGenerator pointGen = null;
    private ArrayMarkerGenerator amGen = null;
    private GroupGenerator groupGen = null;
    private PolylineGenerator polyGen = null;
    private InteractiveElementGenerator internalQuestionSupportGen = null;
    private Vector<String> directions = new Vector();

    public AnimalScript(String title, String author, int x, int y) {
        this.directions.add(DIRECTION_NW);
        this.directions.add(DIRECTION_N);
        this.directions.add(DIRECTION_NE);
        this.directions.add(DIRECTION_W);
        this.directions.add(DIRECTION_C);
        this.directions.add(DIRECTION_E);
        this.directions.add(DIRECTION_SW);
        this.directions.add(DIRECTION_S);
        this.directions.add(DIRECTION_SE);
        StringBuilder buf = new StringBuilder();
        buf.append("%Animal 2");
        if (x != 0 && y != 0) {
            buf.append(" " + x + "*" + y);
        }
        if (title != null) {
            buf.append("\ntitle \"" + title + "\"");
        }
        if (author != null) {
            buf.append("\nauthor \"" + author + "\"");
        }
        this.addLine(buf);
        this.generateGenerators();
    }

    private void generateGenerators() {
        this.arcGen = new AnimalArcGenerator(this);
        this.circleGen = new AnimalCircleGenerator(this);
        this.circleSegGen = new AnimalCircleSegGenerator(this);
        this.ellipseGen = new AnimalEllipseGenerator(this);
        this.graphGen = new AnimalGraphGenerator(this);
        this.intArrayGen = new AnimalIntArrayGenerator(this);
        this.intMatrixGen = new AnimalIntMatrixGenerator(this);
        this.listElemGen = new AnimalListElementGenerator(this);
        this.rectGen = new AnimalRectGenerator(this);
        this.sourceGen = new AnimalSourceCodeGenerator(this);
        this.squareGen = new AnimalSquareGenerator(this);
        this.stringArrayGen = new AnimalStringArrayGenerator(this);
        this.stringMatrixGen = new AnimalStringMatrixGenerator(this);
        this.textGen = new AnimalTextGenerator(this);
        this.triangleGen = new AnimalTriangleGenerator(this);
        this.polygonGen = new AnimalPolygonGenerator(this);
        this.pointGen = new AnimalPointGenerator(this);
        this.amGen = new AnimalArrayMarkerGenerator(this);
        this.groupGen = new AnimalGroupGenerator(this);
        this.polyGen = new AnimalPolylineGenerator(this);
        this.internalQuestionSupportGen = new AnimalJHAVETextInteractionGenerator(this);
    }

    @Override
    public void addLine(StringBuilder line) {
        line.append("\r\n");
        if (this.stepMode) {
            this.stepBuffer.append((CharSequence)line);
        } else {
            this.output.append((CharSequence)line);
        }
    }

    public void addLabel(String label) {
        if (label != null) {
            this.addLine("label \"" + label + "\"");
        }
    }

    @Override
    public void addError(StringBuilder error) {
        error.append("\r\n");
        this.errorBuffer.append((CharSequence)error);
    }

    public String getErrorOutput() {
        return this.errorBuffer.toString();
    }

    @Override
    public void addItem(Primitive p) {
        this.names.add(p.getName());
    }

    @Override
    public void writeFile(String fileName) {
        this.finalizeGeneration();
        try {
            FileWriter fw = new FileWriter(fileName);
            fw.write(this.toString());
            fw.close();
        }
        catch (Exception ex) {
            System.err.println("Error while writing file:");
            System.err.println("Filename: " + fileName);
            System.err.println(ex.getMessage());
        }
    }

    public String toString() {
        this.setStepMode(false);
        return this.output.toString();
    }

    @Override
    public void setStepMode(boolean mode) {
        if (!this.stepBuffer.toString().equalsIgnoreCase("")) {
            this.nextStep();
        }
        this.stepMode = mode;
    }

    @Override
    public void nextStep(int delay) {
        this.output.append("{\n" + this.stepBuffer.toString() + "}\n");
        if (delay >= 0) {
            this.output.append("delay ").append(delay).append(" ms\n");
        }
        this.stepBuffer = new StringBuilder(INITIAL_STEPBUFFER_SIZE);
    }

    public void resetAnimation() {
    }

    @Override
    public boolean isNameUsed(String name) {
        return this.names.contains(name);
    }

    @Override
    public Vector<String> validDirections() {
        return this.directions;
    }

    @Override
    public boolean isValidDirection(String direction) {
        return direction == null || this.directions.contains(direction) || direction == null;
    }

    @Override
    public Arc newArc(Node center, Node radius, String name, DisplayOptions display, ArcProperties ep) {
        return new Arc(this.arcGen, center, radius, name, display, ep);
    }

    @Override
    public Circle newCircle(Node center, int radius, String name, DisplayOptions display, CircleProperties cp) {
        return new Circle(this.circleGen, center, radius, name, display, cp);
    }

    @Override
    public CircleSeg newCircleSeg(Node center, int radius, String name, DisplayOptions display, CircleSegProperties cp) {
        return new CircleSeg(this.circleSegGen, center, radius, name, display, cp);
    }

    @Override
    public Ellipse newEllipse(Node center, Node radius, String name, DisplayOptions display, EllipseProperties ep) {
        return new Ellipse(this.ellipseGen, center, radius, name, display, ep);
    }

    @Override
    public IntArray newIntArray(Node upperLeft, int[] data, String name, ArrayDisplayOptions display, ArrayProperties iap) {
        return new IntArray(this.intArrayGen, upperLeft, data, name, display, iap);
    }

    @Override
    public IntMatrix newIntMatrix(Node upperLeft, int[][] data, String name, DisplayOptions display, MatrixProperties iap) {
        return new IntMatrix(this.intMatrixGen, upperLeft, data, name, display, iap);
    }

    @Override
    public ListElement newListElement(Node upperLeft, int pointers, LinkedList<Object> pointerLocations, ListElement prev, ListElement next, String name, DisplayOptions display, ListElementProperties lp) {
        return new ListElement(this.listElemGen, upperLeft, pointers, pointerLocations, prev, next, name, display, lp);
    }

    @Override
    public Point newPoint(Node coords, String name, DisplayOptions display, PointProperties pp) {
        return new Point(this.pointGen, coords, name, display, pp);
    }

    @Override
    public Polygon newPolygon(Node[] vertices, String name, DisplayOptions display, PolygonProperties pp) throws NotEnoughNodesException {
        return new Polygon(this.polygonGen, vertices, name, display, pp);
    }

    @Override
    public Rect newRect(Node upperLeft, Node lowerRight, String name, DisplayOptions display, RectProperties rp) {
        return new Rect(this.rectGen, upperLeft, lowerRight, name, display, rp);
    }

    @Override
    public SourceCode newSourceCode(Node upperLeft, String name, DisplayOptions display, SourceCodeProperties sp) {
        return new SourceCode(this.sourceGen, upperLeft, name, display, sp);
    }

    @Override
    public Square newSquare(Node upperLeft, int width, String name, DisplayOptions display, SquareProperties sp) {
        return new Square(this.squareGen, upperLeft, width, name, display, sp);
    }

    @Override
    public StringArray newStringArray(Node upperLeft, String[] data, String name, ArrayDisplayOptions display, ArrayProperties sap) {
        return new StringArray(this.stringArrayGen, upperLeft, data, name, display, sap);
    }

    @Override
    public StringMatrix newStringMatrix(Node upperLeft, String[][] data, String name, DisplayOptions display, MatrixProperties iap) {
        return new StringMatrix(this.stringMatrixGen, upperLeft, data, name, display, iap);
    }

    @Override
    public Text newText(Node upperLeft, String text, String name, DisplayOptions display, TextProperties tp) {
        return new Text(this.textGen, upperLeft, text, name, display, tp);
    }

    @Override
    public Triangle newTriangle(Node x, Node y, Node z, String name, DisplayOptions display, TriangleProperties tp) {
        return new Triangle(this.triangleGen, x, y, z, name, display, tp);
    }

    @Override
    public ArrayMarker newArrayMarker(ArrayPrimitive a, int index, String name, DisplayOptions display, ArrayMarkerProperties ap) {
        return new ArrayMarker(this.amGen, a, index, name, display, ap);
    }

    @Override
    public Group newGroup(LinkedList<Primitive> primitives, String name) {
        return new Group(this.groupGen, primitives, name);
    }

    @Override
    public Polyline newPolyline(Node[] vertices, String name, DisplayOptions display, PolylineProperties pp) {
        return new Polyline(this.polyGen, vertices, name, display, pp);
    }

    @Override
    public Graph newGraph(String name, int[][] graphAdjacencyMatrix, Node[] graphNodes, String[] labels, DisplayOptions display, GraphProperties graphProps) {
        return new Graph(this.graphGen, name, graphAdjacencyMatrix, graphNodes, labels, display, graphProps);
    }

    @Override
    public <T> ConceptualStack<T> newConceptualStack(Node upperLeft, List<T> content, String name, DisplayOptions display, StackProperties sp) {
        AnimalConceptualStackGenerator csGen = new AnimalConceptualStackGenerator(this);
        return new ConceptualStack(csGen, upperLeft, content, name, display, sp);
    }

    @Override
    public <T> ArrayBasedStack<T> newArrayBasedStack(Node upperLeft, List<T> content, String name, DisplayOptions display, StackProperties sp, int capacity) {
        AnimalArrayBasedStackGenerator absGen = new AnimalArrayBasedStackGenerator(this);
        return new ArrayBasedStack(absGen, upperLeft, content, name, display, sp, capacity);
    }

    @Override
    public <T> ListBasedStack<T> newListBasedStack(Node upperLeft, List<T> content, String name, DisplayOptions display, StackProperties sp) {
        AnimalListBasedStackGenerator lbsGen = new AnimalListBasedStackGenerator(this);
        return new ListBasedStack(lbsGen, upperLeft, content, name, display, sp);
    }

    @Override
    public <T> ConceptualQueue<T> newConceptualQueue(Node upperLeft, List<T> content, String name, DisplayOptions display, QueueProperties qp) {
        AnimalConceptualQueueGenerator cqGen = new AnimalConceptualQueueGenerator(this);
        return new ConceptualQueue(cqGen, upperLeft, content, name, display, qp);
    }

    @Override
    public <T> ArrayBasedQueue<T> newArrayBasedQueue(Node upperLeft, List<T> content, String name, DisplayOptions display, QueueProperties qp, int capacity) {
        AnimalArrayBasedQueueGenerator abqGen = new AnimalArrayBasedQueueGenerator(this);
        return new ArrayBasedQueue(abqGen, upperLeft, content, name, display, qp, capacity);
    }

    @Override
    public <T> ListBasedQueue<T> newListBasedQueue(Node upperLeft, List<T> content, String name, DisplayOptions display, QueueProperties qp) {
        AnimalListBasedQueueGenerator lbqGen = new AnimalListBasedQueueGenerator(this);
        return new ListBasedQueue(lbqGen, upperLeft, content, name, display, qp);
    }

    @Override
    public void addDocumentationLink(DocumentationLink docuLink) {
        this.internalQuestionSupportGen.createDocumentationLink(docuLink);
        this.interactiveElements.put(docuLink.getID(), docuLink);
    }

    @Override
    public void addTFQuestion(TrueFalseQuestion tfQuestion) {
        this.internalQuestionSupportGen.createTFQuestion(tfQuestion);
        this.interactiveElements.put(tfQuestion.getID(), tfQuestion);
    }

    @Override
    public void addMCQuestion(MultipleChoiceQuestion mcQuestion) {
        this.internalQuestionSupportGen.createMCQuestion(mcQuestion);
        this.interactiveElements.put(mcQuestion.getID(), mcQuestion);
    }

    @Override
    public void addMSQuestion(MultipleSelectionQuestion msQuestion) {
        this.internalQuestionSupportGen.createMSQuestion(msQuestion);
        this.interactiveElements.put(msQuestion.getID(), msQuestion);
    }

    @Override
    public void finalizeGeneration() {
        this.setStepMode(false);
        if (!this.interactiveElements.isEmpty()) {
            Set interactionKeys = this.interactiveElements.keySet();
            for (String key : interactionKeys) {
                InteractiveElement element = (InteractiveElement)this.interactiveElements.get(key);
                this.internalQuestionSupportGen.createInteractiveElementCode(element);
            }
            this.internalQuestionSupportGen.finalizeInteractiveElements();
        }
    }

    @Override
    public String getAnimationCode() {
        return this.output.toString();
    }

    @Override
    public void setInteractionType(int interactionTypeCode) {
        this.setInteractionType(interactionTypeCode, "intDefFile.txt");
    }

    public void setInteractionType(int interactionTypeCode, String key) {
        if (!this.interactiveElements.isEmpty()) {
            throw new IllegalStateException("You cannot change the interaction type if elements have been generated before!");
        }
        this.internalQuestionSupportGen = interactionTypeCode == 4 ? new AVInteractionTextGenerator(this, key) : new AnimalJHAVETextInteractionGenerator(this);
    }
}

