/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.Group;
import animalscriptapi.primitives.Primitive;
import animalscriptapi.primitives.generators.GroupGenerator;
import animalscriptapi.primitives.generators.Language;
import java.util.Iterator;
import java.util.LinkedList;

public class AnimalGroupGenerator
extends AnimalGenerator
implements GroupGenerator {
    private static int count = 1;

    public AnimalGroupGenerator(Language aLang) {
        super(aLang);
    }

    public void create(Group g) {
        String name = g.getName();
        if (name == null || name == "" || this.isNameUsed(name)) {
            g.setName("Group" + count);
            name = g.getName();
            ++count;
        }
        this.lang.addItem(g);
        StringBuilder def = new StringBuilder(AnimalScript.INITIAL_GENBUFFER_SIZE);
        def.append("group \"" + name + "\" ");
        LinkedList<Primitive> primitives = g.getPrimitives();
        if (primitives != null) {
            Iterator i = primitives.listIterator();
            while (i.hasNext()) {
                Primitive p = (Primitive)i.next();
                def.append("\"" + p.getName() + "\" ");
            }
        }
        this.lang.addLine(def);
    }

    public void remove(Group g, Primitive p) {
        this.lang.addLine("remove \"" + g.getName() + "\" \"" + p.getName() + "\"");
    }
}

