/*
 * Decompiled with CFR 0.152.
 */
package animalscriptapi.animalscript;

import animalscriptapi.animalscript.AnimalGenerator;
import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.IllegalDirectionException;
import animalscriptapi.primitives.Graph;
import animalscriptapi.primitives.generators.GraphGenerator;
import animalscriptapi.properties.GraphProperties;
import animalscriptapi.util.Node;
import animalscriptapi.util.Timing;
import java.awt.Color;

public class AnimalGraphGenerator
extends AnimalGenerator
implements GraphGenerator {
    public AnimalGraphGenerator(AnimalScript as) {
        super(as);
    }

    private void finishDefinition(StringBuilder sb, Timing delay, Timing duration) {
        sb.append(AnimalGenerator.makeDurationTimingDef(duration));
        sb.append(AnimalGenerator.makeOffsetTimingDef(delay));
        this.lang.addLine(sb.toString());
    }

    private void addColorDef(StringBuilder sb, GraphProperties graphProps, String key, String tag) {
        if (graphProps.get(key) != null) {
            sb.append(tag).append(" ");
            sb.append(AnimalGenerator.makeColorDef((Color)graphProps.get(key)));
            sb.append(" ");
        }
    }

    public void create(Graph graph) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("graph \"").append(graph.getName()).append("\" size ");
        sb.append(graph.getSize()).append(" ");
        GraphProperties graphProps = graph.getProperties();
        if (graphProps.get("color") != null) {
            sb.append("color ").append(AnimalGenerator.makeColorDef((Color)graphProps.get("color")));
            sb.append(" ");
        }
        if (graphProps.get("fillColor") != null) {
            sb.append("bgColor ").append(AnimalGenerator.makeColorDef((Color)graphProps.get("fillColor")));
            sb.append(" ");
        }
        this.addColorDef(sb, graphProps, "highlightColor", "highlightColor");
        this.addColorDef(sb, graphProps, "elemHighlight", "elemHighlightColor");
        this.addColorDef(sb, graphProps, "nodeColor", "nodeFontColor");
        this.addColorDef(sb, graphProps, "edgeColor", "edgeFontColor");
        if (((Boolean)graphProps.get("directed")).booleanValue()) {
            sb.append("directed ");
        }
        if (((Boolean)graphProps.get("weighted")).booleanValue()) {
            sb.append("weighted ");
        }
        sb.append("nodes {");
        int nrNodes = graph.getSize();
        int node = 0;
        while (node < nrNodes) {
            sb.append("\"").append(graph.getNodeLabel(node)).append("\" ");
            sb.append(AnimalGenerator.makeNodeDef(graph.getNode(node)));
            if (node < nrNodes - 1) {
                sb.append(',');
            }
            sb.append(" ");
            ++node;
        }
        sb.append("} edges {");
        int row = 0;
        while (row < nrNodes) {
            int col = 0;
            while (col < nrNodes) {
                if (graph.getEdgeWeight(row, col) > 0) {
                    sb.append("(").append(row).append(", ").append(col);
                    sb.append(", \"").append(graph.getEdgeWeight(row, col)).append("\") ");
                }
                ++col;
            }
            ++row;
        }
        sb.append("} ");
        if (graphProps.get("depth") != null) {
            sb.append("depth ");
            sb.append(graphProps.get("depth"));
            sb.append(" ");
        }
        this.lang.addLine(sb.toString());
    }

    public void highlightEdge(Graph graph, int startNode, int endNode, Timing offset, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("highlightEdge on \"").append(graph.getName());
        sb.append("\" (").append(startNode).append(", ");
        sb.append(endNode).append(") ");
        this.finishDefinition(sb, offset, duration);
    }

    public void unhighlightEdge(Graph graph, int startNode, int endNode, Timing offset, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("unhighlightEdge on \"").append(graph.getName());
        sb.append("\" (").append(startNode).append(", ");
        sb.append(endNode).append(") ");
        this.finishDefinition(sb, offset, duration);
    }

    public void highlightNode(Graph graph, int node, Timing offset, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("highlightNode on \"").append(graph.getName());
        sb.append("\" nodes ").append(node);
        this.finishDefinition(sb, offset, duration);
    }

    public void unhighlightNode(Graph graph, int node, Timing offset, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("unhighlightNode on \"").append(graph.getName());
        sb.append("\" nodes ").append(node);
        this.finishDefinition(sb, offset, duration);
    }

    public void hideNode(Graph graph, int index, Timing offset, Timing duration) {
        this.generateShowHideNode(graph, false, index, offset, duration);
    }

    public void hideNodes(Graph graph, int[] indices, Timing offset, Timing duration) {
        this.generateShowHideNodes(graph, true, indices, offset, duration);
    }

    private void generateShowHideNode(Graph graph, boolean isShow, int index, Timing offset, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        String tag = isShow ? "show" : "hide";
        sb.append(tag).append(" \"").append(graph.getName());
        sb.append("\" type \"").append(tag).append("Node ");
        sb.append(index).append("\" ");
        this.finishDefinition(sb, offset, duration);
    }

    private void generateShowHideNodes(Graph graph, boolean isShow, int[] indices, Timing offset, Timing duration) {
        String tag = isShow ? "show" : "hide";
        StringBuilder sb = new StringBuilder(128);
        sb.append(tag).append(" \"").append(graph.getName());
        sb.append("\" type \"").append(tag).append("Nodes");
        int i = 0;
        while (i < indices.length) {
            sb.append(" ").append(indices[i]);
            ++i;
        }
        sb.append("\" ");
        this.finishDefinition(sb, offset, duration);
    }

    public void showNode(Graph graph, int index, Timing offset, Timing duration) {
        this.generateShowHideNode(graph, true, index, offset, duration);
    }

    public void showNodes(Graph graph, int[] indices, Timing offset, Timing duration) {
        this.generateShowHideNodes(graph, true, indices, offset, duration);
    }

    public void hideEdge(Graph graph, int startNode, int endNode, Timing offset, Timing duration) {
        this.generateShowHideEdge(graph, false, startNode, endNode, offset, duration);
    }

    public void hideEdgeWeight(Graph graph, int startNode, int endNode, Timing offset, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("highlightEdge on \"").append(graph.getName());
        sb.append("\" type \"hide edge weight\" (").append(startNode).append(", ");
        sb.append(endNode).append(") ");
        this.finishDefinition(sb, offset, duration);
    }

    public void showEdge(Graph graph, int startNode, int endNode, Timing offset, Timing duration) {
        this.generateShowHideEdge(graph, true, startNode, endNode, offset, duration);
    }

    public void showEdgeWeight(Graph graph, int startNode, int endNode, Timing offset, Timing duration) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("highlightEdge on \"").append(graph.getName());
        sb.append("\" type \"show edge weight\" (").append(startNode).append(", ");
        sb.append(endNode).append(") ");
        this.finishDefinition(sb, offset, duration);
    }

    private void generateShowHideEdge(Graph graph, boolean isShow, int startNode, int endNode, Timing offset, Timing duration) {
        String tag = isShow ? "show" : "hide";
        StringBuilder sb = new StringBuilder(128);
        sb.append(tag).append(" \"").append(graph.getName());
        sb.append("\" type \"").append(tag).append("Edge (");
        sb.append(startNode).append(", ").append(endNode).append(")\" ");
        this.finishDefinition(sb, offset, duration);
    }

    public void setEdgeWeight(Graph graph, int startNode, int endNode, String weight, Timing offset, Timing duration) {
        StringBuilder str = new StringBuilder();
        str.append("setText of \"").append(graph.getName());
        str.append("\" type \"setEdgeWeight(").append(startNode).append(",");
        str.append(endNode).append(")\" to \"");
        str.append(weight).append("\"");
        this.finishDefinition(str, offset, duration);
    }

    public void translateNode(Graph graph, int nodeIndex, Node location, Timing offset, Timing duration) {
        try {
            this.moveTo(graph, null, "translate #" + nodeIndex, location, offset, duration);
        }
        catch (IllegalDirectionException ide) {
            System.err.println("IllegalDirectionException@AnimalGraphGenerator.translateNode");
        }
    }

    public void translateNodes(Graph graph, int[] nodeIndices, Node location, Timing offset, Timing duration) {
        if (nodeIndices != null) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("translateNodes");
            int i = 0;
            while (i < nodeIndices.length) {
                sb.append(' ').append(nodeIndices[i]);
                ++i;
            }
            try {
                this.moveTo(graph, null, sb.toString(), location, offset, duration);
            }
            catch (IllegalDirectionException ide) {
                System.err.println("IllegalDirectionException@AnimalGraphGenerator.translateNodes");
            }
        }
    }

    public void translateWithFixedNodes(Graph graph, int[] nodeIndices, Node location, Timing offset, Timing duration) {
        if (nodeIndices != null) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("translateWithFixedNodes");
            int i = 0;
            while (i < nodeIndices.length) {
                sb.append(' ').append(nodeIndices[i]);
                ++i;
            }
            try {
                this.moveTo(graph, null, sb.toString(), location, offset, duration);
            }
            catch (IllegalDirectionException ide) {
                System.err.println("IllegalDirectionException@AnimalGraphGenerator.translateWithFixedNodes");
            }
        }
    }
}

