/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.animator.Highlight;
import animal.animator.HighlightEdge;
import animal.graphics.PTGraph;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.util.Hashtable;

public class GraphSupport
extends BasicParser
implements AnimalScriptInterface {
    public GraphSupport() {
        this.handledKeywords = new Hashtable();
        this.rulesHash = new XProperties();
        this.handledKeywords.put("graph", "parseGraphInput");
        this.handledKeywords.put("highlightedge", "parseEdgeTransformation");
        this.handledKeywords.put("unhighlightedge", "parseEdgeTransformation");
        this.handledKeywords.put("transformedge", "parseEdgeTransformation");
        this.handledKeywords.put("highlightnode", "parseNodeTransformation");
        this.handledKeywords.put("unhighlightnode", "parseNodeTransformation");
        this.handledKeywords.put("transformnode", "parseNodeTransformation");
        this.handledKeywords.put("setedgeweight", "parseEdgeWeightTransformation");
    }

    public boolean generateNewStep(String command) {
        return !sameStep;
    }

    public void parseGraphInput() throws IOException {
        StringBuilder oids = new StringBuilder();
        ParseSupport.parseWord(stok, "graph type");
        String graphName = AnimalParseSupport.parseText(stok, "graph name");
        ParseSupport.parseMandatoryWord(stok, "graph keyword 'size'", "size");
        int nrNodes = ParseSupport.parseInt(stok, "nr of graph nodes [1, infinity)", 1);
        PTGraph newGraph = new PTGraph(nrNodes);
        Color helper = null;
        helper = AnimalParseSupport.parseAndSetColor(stok, graphName, "color", "black");
        newGraph.setColor(helper);
        helper = AnimalParseSupport.parseAndSetColor(stok, graphName, "bgColor", "white");
        newGraph.setBGColor(helper);
        helper = AnimalParseSupport.parseAndSetColor(stok, graphName, "outlineColor", "black");
        newGraph.setOutlineColor(helper);
        helper = AnimalParseSupport.parseAndSetColor(stok, graphName, "highlightColor", "yellow");
        newGraph.setHighlightColor(helper);
        helper = AnimalParseSupport.parseAndSetColor(stok, graphName, "elemHighlightColor", "red");
        newGraph.setElemHighlightColor(helper);
        helper = AnimalParseSupport.parseAndSetColor(stok, graphName, "nodeFontColor", "blue");
        newGraph.setNodeFontColor(helper);
        helper = AnimalParseSupport.parseAndSetColor(stok, graphName, "edgeFontColor", "blue");
        newGraph.setEdgeFontColor(helper);
        newGraph.setDirection(ParseSupport.parseOptionalWord(stok, "graph keyword 'directed' [optional]", "directed"));
        newGraph.setWeight(ParseSupport.parseOptionalWord(stok, "graph keyword 'weighted' [optional]", "weighted"));
        ParseSupport.parseMandatoryWord(stok, "graph keyword 'nodes'", "nodes");
        ParseSupport.parseMandatoryChar(stok, "graph node keyword '{'", '{');
        if (ParseSupport.parseOptionalWord(stok, "graph keyword 'font' [optional]", "font")) {
            stok.pushBack();
            newGraph.setNodeFont(AnimalParseSupport.parseFontInfo(stok, "graph node font"));
        }
        String localText = null;
        Point coordinate = null;
        int currentNode = 0;
        while (currentNode < nrNodes) {
            localText = AnimalParseSupport.parseText(stok, "graph node value #" + currentNode, null, false, chosenLanguage);
            ParseSupport.parseOptionalWord(stok, "graph keyword 'at' [optional]", "at");
            coordinate = AnimalParseSupport.parseNodeInfo(stok, "graph node #" + currentNode + " location", null);
            newGraph.setPositionNode(currentNode, coordinate);
            newGraph.enterValueNode(currentNode, localText);
            if (currentNode != nrNodes - 1) {
                ParseSupport.parseMandatoryChar(stok, "graph node separator ','", ',');
            }
            ++currentNode;
        }
        ParseSupport.parseMandatoryChar(stok, "graph nodes keychar '}'", '}');
        ParseSupport.parseMandatoryWord(stok, "graph keyword 'edges'", "edges");
        ParseSupport.parseMandatoryChar(stok, "graph edge keyword '{'", '{');
        if (ParseSupport.parseOptionalWord(stok, "graph keyword 'edgeFont' [optional", "font")) {
            stok.pushBack();
            newGraph.setEdgeFont(AnimalParseSupport.parseFontInfo(stok, "graph edge font"));
        }
        String edgeText = "index [0, " + (nrNodes - 1) + "]";
        while (!ParseSupport.parseOptionalChar(stok, "graph edge terminator '}'", '}')) {
            ParseSupport.parseMandatoryChar(stok, "graph edge keychar '('", '(');
            int e1 = ParseSupport.parseInt(stok, "graph edge source " + edgeText, 0, nrNodes - 1);
            ParseSupport.parseMandatoryChar(stok, "graph edge separator ','", ',');
            int e2 = ParseSupport.parseInt(stok, "graph edge target " + edgeText, 0, nrNodes - 1);
            newGraph.setVisibleEdge(e1, e2, true);
            if (ParseSupport.parseOptionalChar(stok, "graph edge weight separator ','", ',')) {
                String edgeWeightText = AnimalParseSupport.parseText(stok, "graph edge weight (" + e1 + ", " + e2 + ")");
                newGraph.enterValueEdge(e1, e2, edgeWeightText);
            } else {
                newGraph.enterValueEdge(e1, e2, "%");
            }
            ParseSupport.parseMandatoryChar(stok, "graph edge keychar ')'", ')');
            ParseSupport.parseOptionalChar(stok, "graph edge separator ',' [optional]", ',');
        }
        if (ParseSupport.parseOptionalWord(stok, "graph keyword 'origin' [optional]", "origin")) {
            Point originPoint = AnimalParseSupport.parseNodeInfo(stok, "graph origin node", null);
            newGraph.setOrigin(originPoint);
        }
        newGraph.setIndices(ParseSupport.parseOptionalWord(stok, "graph keyword 'showIndices' [optional]", "showIndices"));
        AnimalParseSupport.parseAndSetDepth(stok, newGraph, "point");
        BasicParser.addGraphicObject(newGraph, anim);
        oids.append(newGraph.getNum(false));
        GraphSupport.getObjectIDs().put(graphName, newGraph.getNum(false));
        GraphSupport.getObjectTypes().put(graphName, GraphSupport.getTypeIdentifier("graph"));
        GraphSupport.getObjectProperties().put(String.valueOf(graphName) + ".size", nrNodes);
        AnimalParseSupport.showComponents(stok, oids.toString(), "point", true);
    }

    public void parseEdgeTransformation() throws IOException {
        String operationType = ParseSupport.parseWord(stok, "[un]highlightEdge type");
        boolean hlMode = !operationType.startsWith("un");
        StringBuilder msgBuffer = new StringBuilder(64).append(operationType);
        msgBuffer.append(" {0}");
        String baseMsg = msgBuffer.toString();
        ParseSupport.parseMandatoryWord(stok, String.valueOf(baseMsg) + " keyword 'on'", "on");
        String graphName = AnimalParseSupport.parseText(stok, "graph name");
        int graphID = GraphSupport.getObjectIDs().getIntProperty(graphName);
        int nrNodes = GraphSupport.getObjectProperties().getIntProperty(String.valueOf(graphName) + ".size", -1);
        if (nrNodes == -1) {
            MessageDisplay.errorMsg("could not retrieve graph called '" + graphName + "' in line " + stok.lineno() + ", skipping rest of line.", 4);
            return;
        }
        HighlightEdge animator = new HighlightEdge(nrNodes);
        animator.setObjectNums(new int[]{graphID});
        animator.setStep(currentStep);
        String methodName = AnimalParseSupport.parseMethod(stok, String.valueOf(baseMsg) + "operation type", "type", hlMode ? "highlight edges" : "unhighlight edges");
        animator.setMethod(methodName);
        while (stok.nextToken() == 40) {
            int sourceEdgeIndex = ParseSupport.parseInt(stok, "index of first graph node [0, 1]", 0, nrNodes);
            ParseSupport.parseMandatoryChar(stok, String.valueOf(baseMsg) + " edge separator ','", ',');
            int targetEdgeIndex = ParseSupport.parseInt(stok, "index of first graph node [0, 1]", 0, nrNodes);
            ParseSupport.parseMandatoryChar(stok, String.valueOf(baseMsg) + " edge end ')'", ')');
            animator.setHighlightState(sourceEdgeIndex, targetEdgeIndex, true);
        }
        stok.pushBack();
        AnimalParseSupport.parseTiming(stok, animator, "Move");
        BasicParser.addAnimatorToAnimation(animator, anim);
    }

    public void parseEdgeWeightTransformation() throws IOException {
        String operationType = ParseSupport.parseWord(stok, "setEdgeWeight type");
        ParseSupport.parseOptionalWord(stok, "optional setEdgeWeight keyword 'of'", "of");
        String graphName = AnimalParseSupport.parseText(stok, "graph name");
        int graphID = GraphSupport.getObjectIDs().getIntProperty(graphName);
        int nrNodes = GraphSupport.getObjectProperties().getIntProperty(String.valueOf(graphName) + ".size", -1);
        if (nrNodes == -1) {
            MessageDisplay.errorMsg("could not retrieve graph called '" + graphName + "' in line " + stok.lineno() + ", skipping rest of line.", 4);
            return;
        }
        ParseSupport.parseOptionalWord(stok, "optional setEdgeWeight keyword 'edge'", "edge");
        ParseSupport.parseMandatoryChar(stok, "setEdgeWeight char '('", '(');
        int sourceEdgeIndex = ParseSupport.parseInt(stok, "index of first graph node [0, 1]", 0, nrNodes);
        ParseSupport.parseMandatoryChar(stok, "setEdgeWeight edge separator ','", ',');
        int targetEdgeIndex = ParseSupport.parseInt(stok, "index of first graph node [0, 1]", 0, nrNodes);
        ParseSupport.parseMandatoryChar(stok, "setEdgeWeight edge end ')'", ')');
        ParseSupport.parseMandatoryWord(stok, "setEdgeWeight keyword 'to'", "to");
        String newWeight = AnimalParseSupport.parseText(stok, "new edge weight");
        System.err.println("adapt edge weight (" + sourceEdgeIndex + ", " + targetEdgeIndex + ") to value " + newWeight);
        System.err.println("*** animator missing! ***");
        PTGraph graph = (PTGraph)animState.getCloneByNum(graphID);
        graph.enterValueEdge(sourceEdgeIndex, targetEdgeIndex, newWeight);
    }

    public void parseNodeTransformation() throws IOException {
        String operationType = ParseSupport.parseWord(stok, "[un]highlightNode type");
        boolean hlMode = !operationType.startsWith("un");
        StringBuilder msgBuffer = new StringBuilder(64).append(operationType);
        String baseMsg = msgBuffer.toString();
        ParseSupport.parseMandatoryWord(stok, String.valueOf(baseMsg) + " keyword 'on'", "on");
        String graphName = AnimalParseSupport.parseText(stok, "graph name");
        int graphID = GraphSupport.getObjectIDs().getIntProperty(graphName);
        int nrNodes = GraphSupport.getObjectProperties().getIntProperty(String.valueOf(graphName) + ".size", -1);
        if (nrNodes == -1) {
            MessageDisplay.errorMsg("could not retrieve graph called '" + graphName + "' in line " + stok.lineno() + ", skipping rest of line.", 4);
            return;
        }
        Highlight animator = new Highlight(nrNodes);
        animator.setObjectNums(new int[]{graphID});
        animator.setStep(currentStep);
        String methodName = AnimalParseSupport.parseMethod(stok, String.valueOf(baseMsg) + "operation type", "type", hlMode ? "highlight nodes" : "unhighlight nodes");
        animator.setMethod(methodName);
        ParseSupport.parseMandatoryWord(stok, String.valueOf(baseMsg) + " keyword 'nodes'", "nodes");
        int token = Integer.MAX_VALUE;
        while ((token = stok.nextToken()) == -2 || token == -3 || token == 34) {
            int nodeIndex = (int)GraphSupport.stok.nval;
            animator.setHighlightState(nodeIndex, true);
        }
        stok.pushBack();
        AnimalParseSupport.parseTiming(stok, animator, "Move");
        BasicParser.addAnimatorToAnimation(animator, anim);
    }
}

