/*
 * Decompiled with CFR 0.152.
 */
package animalscript.core;

import animal.animator.Animator;
import animal.graphics.PTGraphicObject;
import animal.gui.GraphicVector;
import animal.gui.GraphicVectorEntry;
import animal.main.Animation;
import animal.main.AnimationState;
import animal.misc.MessageDisplay;
import java.util.Vector;

public class QuickAnimationStep
extends AnimationState {
    private Vector<PTGraphicObject> myObjects = null;
    private Animation myAnimation = null;
    private int currentStepNr = -1;
    private GraphicVector myCurrentObjects = new GraphicVector();

    public QuickAnimationStep(Animation targetAnimation) {
        super(targetAnimation);
        this.myObjects = new Vector(32768);
        this.myAnimation = targetAnimation;
        this.resetAnimationState();
    }

    public void addGraphicObject(PTGraphicObject ptgo) {
        if (ptgo == null) {
            return;
        }
        PTGraphicObject clonedObject = (PTGraphicObject)ptgo.clone();
        clonedObject.clonePropertiesFrom(ptgo.getProperties(), true);
        this.myObjects.addElement(clonedObject);
    }

    public PTGraphicObject getCloneByNum(int num) {
        if (num < 0) {
            return null;
        }
        int j = 0;
        while (j < 2) {
            int i = 0;
            while (i < this.myObjects.size()) {
                PTGraphicObject result = this.myObjects.elementAt(i);
                if (result.getNum(true) == num) {
                    return result;
                }
                ++i;
            }
            if (j == 0) {
                if (this.myAnimation.getGraphicObject(num) == null) break;
                int nowStep = this.currentStepNr;
                this.setStep(nowStep, false);
            }
            ++j;
        }
        MessageDisplay.errorMsg("Clone " + num + " not found in step " + this.currentStepNr, 16);
        return null;
    }

    public void resetAnimationState() {
        this.myObjects.removeAllElements();
        if (this.myAnimation == null) {
            return;
        }
        Vector<PTGraphicObject> go = this.myAnimation.getGraphicObjects();
        int size = go.size();
        this.myObjects.ensureCapacity(size);
        int i = 0;
        while (i < size) {
            this.addGraphicObject(go.elementAt(i));
            ++i;
        }
        this.currentStepNr = 0;
        this.myObjects.trimToSize();
        this.myCurrentObjects.removeAllElements();
    }

    public boolean advanceStep(int targetStep) {
        if (this.myAnimation == null) {
            return false;
        }
        Animator a = null;
        this.myCurrentObjects.nextStep();
        Vector<Animator> nowAnimators = this.myAnimation.getAnimatorsAtStep(targetStep);
        int j = 0;
        while (j < nowAnimators.size()) {
            int[] o;
            int k;
            int[] nums;
            a = nowAnimators.elementAt(j);
            a.init(this, 0L, 0.0);
            a.execute();
            if (a.isChangingAnimator() && (nums = a.getObjectNums()) != null) {
                k = 0;
                while (k < nums.length) {
                    GraphicVectorEntry gve = this.myCurrentObjects.getGVEByNum(nums[k]);
                    if (gve != null) {
                        gve.setAnimated();
                    }
                    ++k;
                }
            }
            if ((o = a.getTemporaryObjects()) != null) {
                k = 0;
                while (k < o.length) {
                    this.myCurrentObjects.addElement(this.getCloneByNum(o[k]), 8);
                    ++k;
                }
            }
            ++j;
        }
        ++this.currentStepNr;
        return true;
    }

    public boolean setStep(int targetStep, boolean isDelayed) {
        return this.setStep(targetStep);
    }

    public boolean setStep(int targetStep) {
        int cStep = this.currentStepNr;
        while (cStep < targetStep && this.advanceStep(cStep)) {
            ++cStep;
        }
        return this.currentStepNr == targetStep;
    }
}

