/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.misc.ColorChoice;
import animal.misc.MessageDisplay;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class XProperties
extends Properties {
    private static final long serialVersionUID = 5464880768879063690L;
    public static final Point POINT_OF_ORIGIN = new Point(0, 0);

    public XProperties(Properties defaultProperties) {
        super(defaultProperties);
    }

    public XProperties() {
    }

    public void addAllElements(XProperties otherResource) {
        otherResource.list(System.err);
        Enumeration<?> keys = otherResource.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = otherResource.getProperty(key);
            System.err.println(String.valueOf(key) + "=" + value);
            this.put(key, value);
        }
    }

    public boolean getBoolProperty(String key) {
        return this.getBoolProperty(key, false);
    }

    public boolean getBoolProperty(String key, boolean defaultValue) {
        String result = this.getProperty(key);
        return result == null ? defaultValue : Boolean.valueOf(result);
    }

    public double getDoubleProperty(String key) {
        return this.getDoubleProperty(key, Double.MIN_VALUE);
    }

    public double getDoubleProperty(String key, double defaultValue) {
        String result = this.getProperty(key);
        double value = defaultValue;
        if (result != null) {
            try {
                value = Double.parseDouble(result);
            }
            catch (NumberFormatException noNumber) {
                value = defaultValue;
            }
        }
        return value;
    }

    public int getIntProperty(String key) {
        return this.getIntProperty(key, Integer.MIN_VALUE);
    }

    public int getIntProperty(String key, int defaultValue) {
        String result = this.getProperty(key);
        int value = defaultValue;
        if (result != null) {
            try {
                value = Integer.parseInt(result);
            }
            catch (NumberFormatException noNumber) {
                value = defaultValue;
            }
        }
        return value;
    }

    public int[] getIntArrayProperty(String key) {
        String entry = this.getProperty(key);
        int[] result = null;
        StringTokenizer stok = new StringTokenizer(entry);
        int size = stok.countTokens();
        result = new int[size];
        int i = 0;
        while (i < size) {
            result[i] = Integer.parseInt(stok.nextToken());
            ++i;
        }
        if (result == null) {
            MessageDisplay.errorMsg("noIntArrayProp", key, 4);
        }
        return result;
    }

    public Color getColorProperty(String key) {
        return this.getColorProperty(key, Color.black);
    }

    public Color getColorProperty(String key, Color defaultColor) {
        String result = this.getProperty(key);
        return result == null ? defaultColor : ColorChoice.getColor(result);
    }

    public Font getFontProperty(String key) {
        return this.getFontProperty(key, new Font("SansSerif", 16, 0));
    }

    public Font getFontProperty(String key, Font defaultFont) {
        String value = this.getProperty(key);
        if (value == null) {
            return defaultFont;
        }
        int size = 16;
        int style = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(value);
        String fontName = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            try {
                size = Integer.parseInt(stringTokenizer.nextToken());
                style = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException nfe) {
                size = 16;
                style = 0;
            }
        }
        return new Font(fontName, style, size);
    }

    public Image getImageProperty(String key) {
        return (Image)this.get(key);
    }

    public Point getPointProperty(String key) {
        return this.getPointProperty(key, POINT_OF_ORIGIN);
    }

    public Point getPointProperty(String key, Point defaultPoint) {
        Object result = this.get(key);
        if (result != null) {
            if (result instanceof Point) {
                return (Point)result;
            }
            if (result instanceof String) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)result);
                try {
                    int x = Integer.parseInt(stringTokenizer.nextToken());
                    int y = Integer.parseInt(stringTokenizer.nextToken());
                    return new Point(x, y);
                }
                catch (NumberFormatException e) {
                    MessageDisplay.errorMsg("nfe", stringTokenizer.toString(), 4);
                }
            }
        }
        return defaultPoint;
    }

    public Point[] getPointArrayProperty(String key) {
        Object result = this.get(key);
        if (result != null) {
            if (result instanceof Point) {
                return new Point[]{(Point)result};
            }
            if (result instanceof String) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)result);
                Point[] points = new Point[stringTokenizer.countTokens() >> 1];
                int currentPointNr = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        int x = Integer.parseInt(stringTokenizer.nextToken());
                        int y = Integer.parseInt(stringTokenizer.nextToken());
                        points[currentPointNr++] = new Point(x, y);
                    }
                    catch (NumberFormatException e) {
                        MessageDisplay.errorMsg("nfe", stringTokenizer.toString(), 4);
                    }
                }
                Point[] resultPoints = new Point[currentPointNr];
                System.arraycopy(points, 0, resultPoints, 0, currentPointNr);
                return resultPoints;
            }
        }
        return new Point[]{new Point(0, 0)};
    }

    public String[] getStringArrayProperty(String key) {
        return this.getStringArrayProperty(key, " \t\n\r\f");
    }

    public String[] getStringArrayProperty(String key, String sep) {
        String[] sa = XProperties.makeArrayFromString(this.getProperty(key), sep);
        if (sa == null) {
            MessageDisplay.errorMsg("noStringArrayProp", key, 4);
        }
        return sa;
    }

    public void put(String key, String[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        StringBuilder localBuffer = new StringBuilder(values.length << 4);
        int i = 0;
        while (i < values.length) {
            localBuffer.append(values[i]).append("\n");
            ++i;
        }
        this.put(key, localBuffer.toString());
    }

    public void put(int key, int value) {
        this.put(String.valueOf(key), String.valueOf(value));
    }

    public void put(String key, double value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, int[] values) {
        this.put(key, XProperties.arrayAsString(values));
    }

    public void put(String key, int[] values, int from, int until) {
        this.put(key, XProperties.arrayAsString(values, from, until));
    }

    public void put(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public void put(String key, Color color) {
        this.put(key, ColorChoice.getColorName(color));
    }

    public void put(String key, Font font) {
        this.put(key, String.valueOf(font.getName()) + " " + font.getSize() + " " + font.getStyle());
        this.put(String.valueOf(key) + "Name", font.getName());
        this.put(String.valueOf(key) + "Size", font.getSize());
        this.put(String.valueOf(key) + "Style", font.getStyle());
    }

    public void put(String key, Point point) {
        this.put(key, String.valueOf(point.x) + " " + point.y);
    }

    public void put(String key, Point[] points) {
        int i = 0;
        while (i < points.length) {
            if (points[i] != null) {
                System.err.print(String.valueOf(points[i].toString()) + " ");
            }
            ++i;
        }
        StringBuilder pointsString = new StringBuilder();
        i = 0;
        while (i < points.length) {
            pointsString.append(points[i].x).append(" ").append(points[i].y).append(" ");
            ++i;
        }
        this.put(key, pointsString.toString().substring(0, pointsString.length() - 1));
    }

    public String[] getKeysWithSuffix(String suffix) {
        Enumeration<?> e = this.propertyNames();
        int suffixLength = suffix.length();
        int nrHits = 0;
        Vector<String> helper = new Vector<String>(100);
        while (e.hasMoreElements()) {
            String currentKey = (String)e.nextElement();
            if (!currentKey.regionMatches(true, currentKey.length() - suffixLength, suffix, 0, suffixLength)) continue;
            helper.addElement(currentKey);
        }
        nrHits = helper.size();
        if (nrHits == 0) {
            return null;
        }
        String[] keys = new String[nrHits];
        int i = 0;
        while (i < nrHits) {
            keys[i] = (String)helper.elementAt(i);
            ++i;
        }
        helper.removeAllElements();
        helper = null;
        return keys;
    }

    public String[] getKeys(String prefix) {
        Enumeration<?> e = this.propertyNames();
        int prefixLength = prefix.length();
        int nrHits = 0;
        Vector<String> helper = new Vector<String>(100);
        while (e.hasMoreElements()) {
            String currentKey = (String)e.nextElement();
            if (!currentKey.regionMatches(true, 0, prefix, 0, prefixLength)) continue;
            helper.addElement(currentKey);
        }
        nrHits = helper.size();
        if (nrHits == 0) {
            return null;
        }
        String[] keys = new String[nrHits];
        int i = 0;
        while (i < nrHits) {
            keys[i] = (String)helper.elementAt(i);
            ++i;
        }
        helper.removeAllElements();
        helper = null;
        return keys;
    }

    public XProperties getElementsForPrefix(String prefix) {
        String[] keys = this.getKeys(prefix);
        if (keys == null) {
            return new XProperties();
        }
        XProperties xprops = new XProperties();
        int nrKeys = keys.length;
        int prefixLength = prefix.length();
        int i = 0;
        while (i < nrKeys) {
            String targetKey = String.valueOf(prefix) + keys[i].substring(prefixLength);
            xprops.put(targetKey, this.getProperty(keys[i]));
            ++i;
        }
        return xprops;
    }

    public static String arrayAsString(int[] values) {
        if (values != null) {
            return XProperties.arrayAsString(values, 0, values.length - 1);
        }
        return "";
    }

    public static String arrayAsString(int[] values, int from, int until) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = from;
        while (i <= until && i < values.length) {
            sb.append(values[i]).append(' ');
            ++i;
        }
        return sb.toString();
    }

    public static String[] makeArrayFromString(String array, String sep) {
        if (array != null && sep != null) {
            StringTokenizer st = new StringTokenizer(array, sep);
            String[] s = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                s[i++] = st.nextToken();
            }
            return s;
        }
        return null;
    }

    public void put(String key, String value) {
        if (value == null) {
            return;
        }
        super.put(key, value);
    }
}

