/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.dialog.OptionDialog;
import animal.gui.AnimalMainWindow;
import animal.gui.DrawWindow;
import animal.main.Animal;
import animal.main.AnimationWindow;
import animal.misc.MessageDisplay;
import animal.misc.ObjectSelectionButton;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import translator.AnimalTranslator;

public class InternPanel
extends JPanel
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 104342772853460505L;
    private static final String[] DEFAULT_MAGS = new String[]{"50%", "71%", "100%", "141%", "200%"};
    private DrawWindow drawWindow;
    private AbstractButton snapButton;
    private AbstractButton selectionButton;
    private AbstractButton multiSelectionButton;
    private AbstractButton useEditorsButton;
    private AbstractButton deleteButton;
    private AbstractButton showTempObjectsButton;
    private AbstractButton writeBackButton;
    private JComboBox magnificationCB;
    AbstractButton undoButton;
    AbstractButton redoButton;
    private AbstractButton repaintButton;
    private AbstractButton cloneButton;
    private AbstractButton optionButton;
    private JComboBox choiceGrid;
    private JTextField stepTF;
    private AbstractButton prevStepButton;
    private AbstractButton nextStepButton;
    private AbstractButton runStepButton;
    private boolean oldMultiSelection;
    private boolean oldUseEditors;

    InternPanel(DrawWindow aDrawWindow) {
        this.drawWindow = aDrawWindow;
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        JLabel gridLabel = AnimalTranslator.getGUIBuilder().generateJLabel("grid");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(gridLabel, gbc);
        this.add(gridLabel);
        this.choiceGrid = AnimalTranslator.getGUIBuilder().generateJComboBox("gridBox", null, new String[]{"0", "5", "10", "20", "25", "50"}, String.valueOf(this.drawWindow.getDrawCanvas().getGrid()));
        Insets defaultInsets = new Insets(0, 0, 0, 0);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 0;
        gbc.insets = defaultInsets;
        gridBagLayout.setConstraints(this.choiceGrid, gbc);
        this.choiceGrid.addItemListener(this);
        this.add(this.choiceGrid);
        this.snapButton = AnimalTranslator.getGUIBuilder().generateJButton("snapMode", null, true, this);
        this.snapButton.setSelected(this.drawWindow.getDrawCanvas().isSnap());
        this.registerComponent(this.snapButton, gridBagLayout, false);
        this.showTempObjectsButton = AnimalTranslator.getGUIBuilder().generateJButton("showTempMode", null, true, this);
        this.showTempObjectsButton.setSelected(true);
        this.registerComponent(this.showTempObjectsButton, gridBagLayout, false);
        this.repaintButton = AnimalTranslator.getGUIBuilder().generateJButton("repaint", null, false, this);
        this.registerComponent(this.repaintButton, gridBagLayout, true);
        this.selectionButton = AnimalTranslator.getGUIBuilder().generateJButton("selectionOnOff", null, false, this);
        this.registerComponent(this.selectionButton, gridBagLayout, false);
        this.multiSelectionButton = AnimalTranslator.getGUIBuilder().generateJButton("multiSelect", null, true, this);
        this.registerComponent(this.multiSelectionButton, gridBagLayout, false);
        this.useEditorsButton = AnimalTranslator.getGUIBuilder().generateJButton("showEdit", null, true, this);
        this.registerComponent(this.useEditorsButton, gridBagLayout, true);
        this.undoButton = AnimalTranslator.getGUIBuilder().generateJButton("undo", null, false, this);
        this.registerComponent(this.undoButton, gridBagLayout, false);
        this.redoButton = AnimalTranslator.getGUIBuilder().generateJButton("redo", null, false, this);
        this.registerComponent(this.redoButton, gridBagLayout, false);
        this.deleteButton = AnimalTranslator.getGUIBuilder().generateJButton("delete", null, false, this);
        this.registerComponent(this.deleteButton, gridBagLayout, true);
        this.setSelection(false, false, false, null);
        this.cloneButton = AnimalTranslator.getGUIBuilder().generateJButton("clone", null, false, this);
        this.registerComponent(this.cloneButton, gridBagLayout, false);
        this.writeBackButton = AnimalTranslator.getGUIBuilder().generateJButton("writeBack", null, false, this);
        this.registerComponent(this.writeBackButton, gridBagLayout, false);
        this.runStepButton = AnimalTranslator.getGUIBuilder().generateJButton("runStep", null, false, this);
        this.registerComponent(this.runStepButton, gridBagLayout, true);
        this.prevStepButton = AnimalTranslator.getGUIBuilder().generateJButton("prevStep", null, false, this);
        this.registerComponent(this.prevStepButton, gridBagLayout, false);
        this.stepTF = AnimalTranslator.getGUIBuilder().generateJTextField("stepChoice", null, 3, "1");
        this.stepTF.addActionListener(this);
        this.registerComponent(this.stepTF, gridBagLayout, false);
        this.nextStepButton = AnimalTranslator.getGUIBuilder().generateJButton("nextStep", null, false, this);
        this.registerComponent(this.nextStepButton, gridBagLayout, true);
        this.magnificationCB = AnimalTranslator.getGUIBuilder().generateJComboBox("magnificationBox", null, DEFAULT_MAGS, DEFAULT_MAGS[2]);
        this.registerComponent(this.magnificationCB, gridBagLayout, false);
        this.magnificationCB.addActionListener(this);
        this.optionButton = AnimalTranslator.getGUIBuilder().generateJButton("options", null, false, this);
        this.registerComponent(this.optionButton, gridBagLayout, true);
    }

    public void registerComponent(JComponent component, GridBagLayout layouter, boolean lastElementInRow) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = lastElementInRow ? 0 : 1;
        gbc.fill = 1;
        gbc.anchor = 10;
        layouter.setConstraints(component, gbc);
        this.add(component);
    }

    void setSelection(boolean selection, boolean multiSelection, boolean useEditors, ObjectSelectionButton osb) {
        boolean enableButtons = selection && osb == null;
        this.multiSelectionButton.setEnabled(enableButtons);
        this.useEditorsButton.setEnabled(enableButtons);
        this.deleteButton.setEnabled(enableButtons);
        if (selection) {
            this.drawWindow.getObjectPanel().setCurrentEditor(null);
        }
        this.drawWindow.getDrawCanvas().setSelection(selection, multiSelection, useEditors, osb);
    }

    void setSelection(boolean selection) {
        this.setSelection(selection, this.multiSelectionButton.isSelected(), this.useEditorsButton.isSelected(), null);
    }

    void setExternalSelection(ObjectSelectionButton osb) {
        if (osb != null) {
            this.oldMultiSelection = this.multiSelectionButton.isSelected();
            this.oldUseEditors = this.useEditorsButton.isSelected();
            this.setSelection(true, osb.hasMultiSelection(), false, osb);
        } else {
            this.setSelection(true, this.oldMultiSelection, this.oldUseEditors, null);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object == this.optionButton) {
            OptionDialog.getOptionDialog(Animal.get()).setVisible(true);
        } else if (object == this.selectionButton || object == this.multiSelectionButton || object == this.useEditorsButton) {
            this.setSelection(true, this.multiSelectionButton.isSelected(), this.useEditorsButton.isSelected(), null);
        } else if (object == this.magnificationCB) {
            int i;
            String s = (String)this.magnificationCB.getSelectedItem();
            s = s.substring(0, s.length() - 1);
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException e2) {
                MessageDisplay.errorMsg("illegalMagnification", s, 16);
                i = 1;
            }
            double factor = 0.01 * (double)i;
            this.drawWindow.getDrawCanvas().setMagnification(factor);
        } else if (object == this.deleteButton) {
            this.drawWindow.getDrawCanvas().deleteSelected();
        } else if (object == this.snapButton) {
            this.drawWindow.getDrawCanvas().setSnap(this.snapButton.isSelected());
        } else if (object == this.showTempObjectsButton) {
            this.drawWindow.getDrawCanvas().setShowTempObjects(this.showTempObjectsButton.isSelected());
        } else if (object == this.cloneButton) {
            this.drawWindow.getDrawCanvas().cloneSelectedObjects();
        } else if (object == this.writeBackButton) {
            this.drawWindow.setChanged();
            this.drawWindow.writeBack();
        } else if (object == this.repaintButton) {
            this.drawWindow.getDrawCanvas().repaintAll();
        } else if (object == this.undoButton) {
            this.drawWindow.getDrawCanvas().getUndoAdapter().undo();
        } else if (object == this.redoButton) {
            this.drawWindow.getDrawCanvas().getUndoAdapter().redo();
        } else if (object == this.prevStepButton) {
            this.drawWindow.setStep(this.drawWindow.getAnimationState().getPrevStep());
        } else if (object == this.nextStepButton) {
            int next = this.drawWindow.getAnimationState().getNextStep();
            if (next != Integer.MAX_VALUE) {
                this.drawWindow.setStep(next);
            }
        } else if (object == this.runStepButton) {
            AnimationWindow animWin = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false);
            if (!animWin.isVisible()) {
                animWin.setVisible(true);
                this.requestFocus();
            }
            this.drawWindow.writeBack();
            animWin.setStep(this.drawWindow.getAnimationState().getStep(), false);
        } else if (object == this.stepTF) {
            try {
                if (!this.drawWindow.setStep(Integer.parseInt(this.stepTF.getText()))) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, AnimalTranslator.translateMessage("notAValidStep", this.stepTF.getText()), AnimalTranslator.translateMessage("illegalStepNumberFormat"), 0);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        String grid = (String)((JComboBox)e.getSource()).getSelectedItem();
        if (grid.equals("none")) {
            grid = "0";
        }
        this.drawWindow.getDrawCanvas().setGrid(Integer.parseInt(grid));
    }

    void setStep(int step) {
        this.stepTF.setText(String.valueOf(step));
    }
}

