/*
 * Decompiled with CFR 0.152.
 */
package animal.gui;

import animal.gui.AnimalMainWindow;
import animal.gui.AnimationControlToolBar;
import animal.main.Animation;
import animal.main.AnimationState;
import animal.main.AnimationWindow;
import animal.misc.MessageDisplay;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import translator.AnimalTranslator;

public class AnimationControlToolBarController
implements ActionListener,
ChangeListener {
    private AnimationWindow animationWindow;

    public AnimationControlToolBarController(AnimationWindow animWindow, AnimationControlToolBar toolBar) {
        this.animationWindow = animWindow;
    }

    public void actionPerformed(ActionEvent event) {
        String command;
        if (this.animationWindow == null) {
            this.animationWindow = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false);
        }
        if ((command = event.getActionCommand()).equals("start")) {
            this.animationWindow.startOfAnimation();
        } else if (command.equals("prev")) {
            this.animationWindow.backwardAnimation();
        } else if (command.equals("reverse slideshow")) {
            this.animationWindow.reverseSlideShow();
        } else if (command.equals("reverse play")) {
            this.animationWindow.reversePlay();
        } else if (command.equals("pause")) {
            this.animationWindow.pauseAnimation();
        } else if (command.equals("play")) {
            this.animationWindow.playAnimation();
        } else if (command.equals("slideshow")) {
            this.animationWindow.slideShow();
        } else if (command.equals("next")) {
            this.animationWindow.forwardAnimation();
        } else if (command.equals("end")) {
            this.animationWindow.endOfAnimation();
        } else if (command.equals("stepNumberField")) {
            JTextField source = (JTextField)event.getSource();
            String targetStepString = source.getText();
            int targetStep = 0;
            int currentStep = this.animationWindow.getStep();
            try {
                targetStep = Integer.parseInt(targetStepString);
                if (!this.animationWindow.getAnimationState().setStep(targetStep, false)) {
                    throw new NumberFormatException(AnimalTranslator.translateMessage("illegalStepNumber", targetStep));
                }
                this.animationWindow.setStep(targetStep, true);
            }
            catch (NumberFormatException exc) {
                this.animationWindow.setStep(currentStep, true);
            }
        } else {
            MessageDisplay.errorMsg("nothingAssoc", command, 4);
        }
    }

    public void stateChanged(ChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof JSlider) {
            JSlider targetSlider = (JSlider)source;
            AnimationState animationState = this.animationWindow.getAnimationState();
            Animation anim = animationState.getAnimation();
            int targetStep = Math.round((anim.getNrOfSteps() - 1) * targetSlider.getValue() / 100);
            this.animationWindow.setStep(targetStep, true);
        }
    }
}

