/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTMatrix;
import animal.graphics.PTText;
import animal.misc.MessageDisplay;
import java.util.Vector;

public class PTDoubleMatrix
extends PTMatrix {
    public static final String TYPE_LABEL = "DoubleMatrix";
    private Vector<Vector<Double>> vdata = new Vector();

    public PTDoubleMatrix() {
        this(1, 1);
    }

    public PTDoubleMatrix(double[][] newdata) {
        if (newdata != null && newdata[0] != null) {
            this.init();
            this.setSize(newdata.length, newdata[0].length);
            int r = 0;
            while (r < newdata.length) {
                int c = 0;
                while (c < newdata[r].length) {
                    this.vdata.get(r).set(c, new Double(newdata[r][c]));
                    ++c;
                }
                ++r;
            }
            this.updateTextualRepresentation();
        }
    }

    public PTDoubleMatrix(int rowcnt, int columncnt) {
        this.init();
        this.setSize(rowcnt, columncnt);
    }

    public Object clone() {
        PTDoubleMatrix targetShape = new PTDoubleMatrix();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTDoubleMatrix targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        int rowcount = this.getRowCount();
        targetShape.setRowCount(rowcount);
        int r = 0;
        while (r < rowcount) {
            int columncount = this.getColumnCount(r);
            targetShape.setColumnCount(r, columncount);
            int c = 0;
            while (c < columncount) {
                targetShape.setDataAt(r, c, this.getDataAt(r, c));
                ++c;
            }
            ++r;
        }
    }

    public int getColumnCount(int row) {
        return this.vdata.get(row).size();
    }

    public String getElementAt(int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            return String.valueOf(this.vdata.get(r).get(c));
        }
        return String.valueOf(0.0);
    }

    public int getRowCount() {
        return this.vdata.size();
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    protected void updateTextualRepresentation() {
        int r = 0;
        while (r < this.vdata.size()) {
            int c = 0;
            while (c < this.vdata.get(r).size()) {
                ((PTText)((Vector)this.vTextData.get(r)).get(c)).setText(String.valueOf(this.vdata.get(r).get(c)));
                ++c;
            }
            ++r;
        }
    }

    protected void addDataItem(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.vdata.size()) {
            this.vdata.get(rowIndex).add(0.0);
        }
    }

    protected void addDataRow() {
        this.vdata.add(new Vector());
    }

    protected PTMatrix getPreClone() {
        return new PTDoubleMatrix();
    }

    protected void setDataRowCount(int value) {
        this.vdata.setSize(value);
    }

    protected void shrinkDataRow(int rowIndex, int value) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            this.vdata.get(rowIndex).setSize(value);
        }
    }

    protected void setDataOfSpecialType(int r, int c, String value) {
        try {
            this.vdata.get(r).set(c, Double.valueOf(value));
        }
        catch (NumberFormatException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
    }

    public int getFileVersion() {
        return 1;
    }

    public double getDataAt(int r, int c) {
        if (this.indicesAreInRange(r, c)) {
            return this.vdata.get(r).get(c);
        }
        return 0.0;
    }

    public void setDataAt(int r, int c, double value) {
        if (this.indicesAreInRange(r, c)) {
            this.vdata.get(r).set(c, value);
            this.setTextDataAt(r, c, String.valueOf(value));
        }
    }

    public void setDiagonalData(int r, int c, double value, boolean down) {
        block6: {
            int maxcolumncount = this.getMaxColumnCount();
            int rowcount = this.getRowCount();
            if (r < 0 || r >= rowcount || c < 0 || c >= maxcolumncount) break block6;
            if (down) {
                int x = c;
                int y = r;
                while (x < maxcolumncount && y < rowcount) {
                    if (x < this.getColumnCount(y)) {
                        this.setDataAt(y, x, value);
                        this.setTextDataAt(y, x, String.valueOf(value));
                    }
                    ++x;
                    ++y;
                }
            } else {
                int x = c;
                int y = r;
                while (x < maxcolumncount && y >= 0) {
                    if (x < this.getColumnCount(y)) {
                        this.setDataAt(y, x, value);
                        this.setTextDataAt(y, x, String.valueOf(value));
                    }
                    ++x;
                    --y;
                }
            }
        }
    }
}

