/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.graphics.PTRectangle;
import animal.graphics.PTText;
import animal.graphics.meta.ImmediateTextContainer;
import animal.main.Animal;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class PTBoxPointer
extends PTGraphicObject
implements ImmediateTextContainer {
    public static final String TYPE_LABEL = "BoxPointer";
    private static final long serialVersionUID = 6082233834117817710L;
    private static final Dimension MINIMUM_SIZE = new Dimension(40, 20);
    private static final Point PADDING = new Point(5, 2);
    private static final int POINTER_PADDING = 10;
    public static final int POINTER_POSITION_BOTTOM = 4;
    public static final int POINTER_POSITION_LEFT = 2;
    public static final int POINTER_POSITION_NONE = 0;
    public static final int POINTER_POSITION_RIGHT = 1;
    public static final int POINTER_POSITION_TOP = 3;
    protected PTRectangle pointerArea;
    protected int pointerPosition = 4;
    protected PTPolyline[] pointers = null;
    protected Point position = new Point(0, 0);
    protected PTRectangle textBox;
    protected PTText textComponent;

    public PTBoxPointer() {
        this.initializeWithDefaults(this.getType());
    }

    public PTBoxPointer(int x, int y) {
        this(x, y, "");
    }

    public PTBoxPointer(int x, int y, String text) {
        this.initializeWithDefaults(this.getType());
        this.setText(text);
        this.init(x, y);
    }

    public void initializeBoxPointer() {
        if (this.getPointerCount() == 0) {
            this.makeNullPointer();
        }
        if (this.getPosition() != null) {
            this.initTextBox(this.position.x, this.position.y, 20, 10);
        }
        this.initTextComponent();
        this.init(this.position);
        this.setPointerCount(this.getPointerCount());
    }

    public void init() {
        this.init(this.getOrigin());
    }

    void init(Point p) {
        if (p == null) {
            this.init(10, 10);
        } else {
            this.init(p.x, p.y);
        }
    }

    void init(int x, int y) {
        if (this.position == null) {
            this.position = new Point(x, y);
        } else {
            this.position.setLocation(x, y);
        }
        FontMetrics f = Animal.getConcreteFontMetrics(this.getTextComponent().getFont());
        int width = PTBoxPointer.PADDING.x * 2;
        if (this.getTextComponent() != null) {
            String text = this.textComponent.getText();
            width += Animal.getStringWidth(text, this.textComponent.getFont());
        }
        if (width < PTBoxPointer.MINIMUM_SIZE.width - 20) {
            width = PTBoxPointer.MINIMUM_SIZE.width - 20;
        }
        int right = x + width - 1;
        int bottom = y + PTBoxPointer.MINIMUM_SIZE.height + f.getHeight() - 15;
        int pointerSize = (this.getPointerCount() + 1) * 10;
        switch (this.getPointerPosition()) {
            case 3: {
                this.initPointerArea(x, y - pointerSize, right, y);
                break;
            }
            case 4: {
                this.initPointerArea(x, bottom, right, bottom + pointerSize);
                break;
            }
            case 2: {
                this.initPointerArea(x - pointerSize, y, x, bottom);
                break;
            }
            case 1: {
                this.initPointerArea(right, y, right + pointerSize, bottom);
                break;
            }
            default: {
                this.pointerArea = null;
            }
        }
        this.initTextBox(x, y, width, PTBoxPointer.MINIMUM_SIZE.height + f.getHeight() - 15);
        this.textComponent.setLocation(new Point(x, y));
        if (this.pointerArea != null) {
            this.recalcPointerOrigins();
        }
    }

    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
    }

    Point calcPointerOrigin(int pointerNum) {
        Rectangle textBoxBounds = this.textBox.getBoundingBox();
        int left = textBoxBounds.x;
        int right = textBoxBounds.x + textBoxBounds.width;
        int top = textBoxBounds.y;
        int bottom = textBoxBounds.y + textBoxBounds.height;
        int space = (pointerNum + 1) * 10;
        switch (this.getPointerPosition()) {
            case 3: {
                return new Point((left + right) / 2, top - space);
            }
            case 4: {
                return new Point((left + right) / 2, bottom + space);
            }
            case 2: {
                return new Point(left - space, (top + bottom) / 2);
            }
            case 1: {
                return new Point(right + space, (top + bottom) / 2);
            }
        }
        return new Point(0, 0);
    }

    public void makeNullPointer() {
        int count = this.getPointerCount();
        this.pointers = null;
        this.setPointerCount(count);
    }

    PTPolyline makeRectangle(int left, int top, int right, int bottom) {
        return new PTPolyline(new int[]{left, left, right, right, left}, new int[]{top, bottom, bottom, top, top});
    }

    public void recalcPointerOrigins() {
        if (this.pointers != null) {
            int a = 0;
            while (a < this.pointers.length) {
                this.pointers[a].setNode(0, new PTPoint(this.calcPointerOrigin(a)));
                ++a;
            }
        }
    }

    public PTRectangle getTextBox() {
        if (this.textBox == null) {
            this.initTextBox(10, 10, 10, 10);
        }
        return this.textBox;
    }

    public Rectangle getBoundingBox() {
        Rectangle r = this.textBox.getBoundingBox();
        if (this.pointerArea != null) {
            Rectangle r2 = this.pointerArea.getBoundingBox();
            r = SwingUtilities.computeUnion(r2.x, r2.y, r2.width, r2.height, r);
            if (this.pointers != null) {
                int i = 0;
                while (i < this.pointers.length) {
                    Point tip = this.getTip(i);
                    r = SwingUtilities.computeUnion(tip.x, tip.y, 0, 0, r);
                    ++i;
                }
            }
        }
        return r;
    }

    public Rectangle getBoundingBoxWithoutPointers() {
        Rectangle r = this.textBox.getBoundingBox();
        if (this.pointerArea != null) {
            Rectangle r2 = this.pointerArea.getBoundingBox();
            r = SwingUtilities.computeUnion(r2.x, r2.y, r2.width, r2.height, r);
        }
        return r;
    }

    public int getFileVersion() {
        return 6;
    }

    public Color getFillColor() {
        if (this.textBox != null) {
            return this.textBox.getFillColor();
        }
        return Color.BLACK;
    }

    public Point getOrigin() {
        if (this.textBox == null) {
            return new Point(0, 0);
        }
        return this.textBox.getFirstNode();
    }

    public PTRectangle getPointerArea() {
        if (this.pointerArea == null) {
            this.init();
        }
        return this.pointerArea;
    }

    public int getPointerCount() {
        return this.pointers == null ? 0 : this.pointers.length;
    }

    public Point getPointerOrigin(int pointerNum) {
        if (this.pointers != null && pointerNum < this.pointers.length && pointerNum >= 0 && this.pointers[pointerNum] != null) {
            return this.pointers[pointerNum].getNode(0).toPoint();
        }
        return this.calcPointerOrigin(pointerNum);
    }

    public int getPointerPosition() {
        if (!this.validPosition(this.pointerPosition)) {
            this.pointerPosition = 4;
        }
        return this.pointerPosition;
    }

    protected boolean validPosition(int targetPosition) {
        switch (targetPosition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public PTPolyline getPointer(int pos) {
        if (pos >= 0 && this.pointers != null && pos < this.pointers.length && this.pointers[pos] != null) {
            return this.pointers[pos];
        }
        return new PTPolyline();
    }

    public PTPolyline[] getPointers() {
        return this.pointers;
    }

    public Point getPosition() {
        if (this.position == null) {
            this.position = this.textBox != null ? this.textBox.getBoundingBox().getLocation() : new Point(10, 10);
        }
        return this.position;
    }

    public Dimension getSize() {
        return MINIMUM_SIZE;
    }

    public PTText getTextComponent() {
        if (this.textComponent == null) {
            this.initTextComponent();
        }
        return this.textComponent;
    }

    public Point getTip(int pointerNum) {
        if (this.pointers == null || pointerNum < 0 || pointerNum >= this.pointers.length) {
            return null;
        }
        return this.pointers[pointerNum].getNode(1).toPoint();
    }

    public Point getTipOrigin(int pointerNum) {
        if (this.pointers == null || pointerNum < 0 || pointerNum >= this.pointers.length) {
            return null;
        }
        return this.pointers[pointerNum].getNode(0).toPoint();
    }

    public String getType() {
        return TYPE_LABEL;
    }

    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL, "ListElement"};
    }

    protected void initPointerArea(int left, int top, int right, int bottom) {
        if (this.pointerArea == null) {
            this.pointerArea = new PTRectangle(left, top, right - left + 1, bottom - top + 1);
            this.pointerArea.setFilled(true);
            this.pointerArea.initializeWithDefaults(String.valueOf(this.getType()) + ".PointerArea");
        } else {
            this.pointerArea.setFirstNode(left, top);
            this.pointerArea.setWidth(right - left + 1);
            this.pointerArea.setFilled(true);
            this.pointerArea.setHeight(bottom - top + 1);
        }
    }

    public void initTextBox(int x, int y, int width, int height) {
        if (this.textBox == null) {
            this.textBox = new PTRectangle(x, y, width, height);
            this.textBox.initializeWithDefaults(String.valueOf(this.getType()) + ".TextBox");
        } else {
            this.textBox.setFirstNode(x, y);
            this.textBox.setWidth(width);
            this.textBox.setHeight(height);
        }
        this.textBox.setFilled(true);
    }

    protected void initTextComponent() {
        this.textComponent = new PTText();
        this.textComponent.setLocation(this.getPosition());
        this.textComponent.initializeWithDefaults(String.valueOf(this.getType()) + ".Text");
        this.textComponent.setText("");
    }

    private boolean isNullPointer(int i) {
        Point basePoint = this.getPointerOrigin(i);
        if (this.getPointerPosition() == 3 || this.getPointerPosition() == 4) {
            basePoint.translate(i % 2 == 0 ? 30 : -30, 0);
        } else {
            basePoint.translate(0, i % 2 == 0 ? 30 : -30);
        }
        return basePoint.equals(this.getTip(i));
    }

    public void setColor(Color newColor) {
        super.setColor(newColor);
        if (this.pointers != null) {
            int a = 0;
            while (a < this.pointers.length) {
                this.pointers[a].setColor(newColor);
                ++a;
            }
        }
    }

    public void setPosition(Point p) {
        this.init(p);
        this.makeNullPointer();
    }

    public void setPointerCountWithoutReinitialization(int pointerCount) {
        if (pointerCount == 0) {
            this.pointers = null;
            this.pointerArea = null;
        } else {
            this.pointers = new PTPolyline[pointerCount];
        }
    }

    public void setPointerCount(int pointerCount) {
        if (pointerCount == 0) {
            this.pointers = null;
            this.pointerArea = null;
        } else {
            int a;
            PTPolyline[] oldPointers = this.pointers;
            this.pointers = new PTPolyline[pointerCount];
            if (oldPointers != null) {
                a = 0;
                while (a < Math.min(oldPointers.length, pointerCount)) {
                    this.pointers[a] = oldPointers[a];
                    ++a;
                }
            }
            a = oldPointers != null ? oldPointers.length : 0;
            while (a < pointerCount) {
                int[] py;
                int[] px;
                Point p = this.calcPointerOrigin(a);
                int dx = p.x - this.getBoundingBoxWithoutPointers().x;
                int dy = p.y - this.getBoundingBoxWithoutPointers().y;
                if (this.getPointerPosition() == 3 || this.getPointerPosition() == 4) {
                    px = new int[]{p.x, p.x + (a % 2 == 0 ? dx : -dx)};
                    py = new int[]{p.y, p.y};
                } else {
                    px = new int[]{p.x, p.x};
                    py = new int[]{p.y, p.y + (a % 2 == 0 ? dy : -dy)};
                }
                this.pointers[a] = new PTPolyline(px, py);
                this.pointers[a].setObjectName(String.valueOf(this.getObjectName()) + ".pointer_" + a);
                this.pointers[a].setFWArrow(true);
                this.pointers[a].setBWArrow(false);
                this.pointers[a].setColor(this.getColor());
                ++a;
            }
        }
        this.init();
    }

    public void setPointerPosition(int targetPosition) {
        if (this.validPosition(targetPosition)) {
            this.pointerPosition = targetPosition;
            this.init();
        }
    }

    public void setPointerPositionWithoutReinitizalization(int targetPosition) {
        if (this.validPosition(targetPosition)) {
            this.pointerPosition = targetPosition;
        }
    }

    public void setTip(int pointerNum, int tipX, int tipY) {
        Point p = this.getPointerOrigin(pointerNum);
        if (tipX == 0 && tipY == 0) {
            tipX = p.x;
            tipY = p.y + PTBoxPointer.MINIMUM_SIZE.height + PTBoxPointer.MINIMUM_SIZE.height / 2;
        }
        if (this.pointers != null && pointerNum < this.pointers.length) {
            if (this.pointers[pointerNum] != null) {
                this.pointers[pointerNum].setNode(1, new PTPoint(tipX, tipY, 1));
            } else {
                this.pointers[pointerNum] = new PTPolyline(new Point[]{p, new Point(tipX, tipY)});
                this.pointers[pointerNum].setFWArrow(true);
            }
            return;
        }
    }

    public void setTip(int pointerNum, Point p) {
        this.setTip(pointerNum, p.x, p.y);
    }

    public void setTipRelative(int pointerNum, int tipX, int tipY) {
        Point p = this.getPointerOrigin(pointerNum);
        if (tipX == 0 && tipY == 0) {
            tipX = p.x;
            tipY = p.y + PTBoxPointer.MINIMUM_SIZE.height + PTBoxPointer.MINIMUM_SIZE.height / 2;
        }
        if (this.pointers != null && pointerNum < this.pointers.length && this.pointers[pointerNum] != null) {
            this.pointers[pointerNum].setNode(1, new PTPoint(p.x + tipX, p.y + tipY, 1));
            return;
        }
    }

    public void setTipRelative(int pointerNum, Point p) {
        Point orig = this.getPointerOrigin(pointerNum);
        this.setTip(pointerNum, orig.x + p.x, orig.y + p.y);
    }

    public void setTips(boolean[] nodeMap, int tipX, int tipY) {
    }

    public void paint(Graphics g) {
        if (this.getOrigin().x == -1 && this.getOrigin().y == -1) {
            return;
        }
        this.getTextBox().paint(g);
        this.getTextComponent().paint(g);
        if (this.pointerArea != null) {
            this.pointerArea.paint(g);
        }
        g.setColor(this.getColor());
        if (this.pointerArea != null && this.pointers != null) {
            int i = 0;
            while (i < this.pointers.length) {
                if (this.pointers[i] != null) {
                    this.pointers[i].paint(g);
                }
                ++i;
            }
        }
    }

    public void translate(int x, int y) {
        this.textBox.translate(x, y);
        this.textComponent.translate(x, y);
        if (this.pointerArea != null) {
            this.pointerArea.translate(x, y);
        }
        if (this.pointers != null) {
            int i = 0;
            while (i < this.pointers.length) {
                this.pointers[i].translate(x, y);
                ++i;
            }
        }
    }

    public void translateWithFixedTips(boolean[] staticTips, int x, int y) {
        if (staticTips != null && this.pointers != null) {
            Point[] points = new Point[this.getPointerCount()];
            int i = 0;
            while (i < this.pointers.length) {
                points[i] = staticTips[i] ? this.getTip(i) : null;
                ++i;
            }
            this.translateWithFixedTips(points, x, y);
        } else {
            this.translate(x, y);
        }
    }

    public void translateWithFixedTips(Point[] tipsToKeep, int x, int y) {
        this.translate(x, y);
        int i = 0;
        while (i < this.pointers.length) {
            if (tipsToKeep[i] != null) {
                this.setTip(i, tipsToKeep[i]);
            }
            ++i;
        }
    }

    public void translateWithFixedTips(int x, int y) {
        if (this.pointers != null) {
            Point[] points = new Point[this.getPointerCount()];
            int i = 0;
            while (i < this.pointers.length) {
                points[i] = !this.isNullPointer(i) ? this.getTip(i) : null;
                ++i;
            }
            this.translateWithFixedTips(points, x, y);
        } else {
            this.translate(x, y);
        }
    }

    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".fillColor", this.getFillColor());
        Font f = this.getTextComponent().getFont();
        if (f != null) {
            defaultProperties.put(String.valueOf(this.getType()) + ".font", f);
            defaultProperties.put(String.valueOf(this.getType()) + ".fontName", f.getFamily());
            defaultProperties.put(String.valueOf(this.getType()) + ".fontSize", f.getSize());
            defaultProperties.put(String.valueOf(this.getType()) + ".fontStyle", f.getStyle());
        }
        defaultProperties.put(String.valueOf(this.getType()) + ".nrPointers", this.getPointerCount());
        PTRectangle r = this.getPointerArea();
        if (r != null) {
            defaultProperties.put(String.valueOf(this.getType()) + ".pointerAreaColor", r.getColor());
            defaultProperties.put(String.valueOf(this.getType()) + ".pointerAreaFillColor", r.getFillColor());
        }
        defaultProperties.put(String.valueOf(this.getType()) + ".pointerPosition", this.getPointerPosition());
        PTText t = this.getTextComponent();
        if (t != null) {
            defaultProperties.put(String.valueOf(this.getType()) + ".text", t.getText());
            defaultProperties.put(String.valueOf(this.getType()) + ".textColor", t.getColor());
        }
    }

    public Object clone() {
        PTBoxPointer b = new PTBoxPointer();
        b.setNum(this.getNum(false));
        b.setDepth(this.getDepth());
        b.setColor(this.createColor(this.color));
        b.textBox = (PTRectangle)this.textBox.clone();
        if (this.pointerArea != null) {
            b.pointerArea = (PTRectangle)this.pointerArea.clone();
            b.pointerArea.setFilled(true);
        }
        if (this.pointers != null) {
            b.pointers = new PTPolyline[this.pointers.length];
            int a = 0;
            while (a < this.pointers.length) {
                b.pointers[a] = (PTPolyline)this.pointers[a].clone();
                ++a;
            }
        }
        if (this.textComponent != null) {
            b.textComponent = (PTText)this.textComponent.clone();
        }
        b.setPointerPositionWithoutReinitizalization(this.pointerPosition);
        return b;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(60);
        sb.append("ListElement ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append(this.textBox.toString()).append(",");
        if (this.pointers != null) {
            sb.append(this.pointers.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean operationRequiresSpecialSelector(String operation) {
        return operation != null && operation.indexOf("Tips") != -1;
    }

    public String baseOperationName(String methodName) {
        if (methodName.endsWith("...")) {
            return methodName.substring(0, methodName.indexOf(46));
        }
        if (methodName.indexOf("Tips") != 0) {
            return methodName.substring(0, methodName.indexOf(32));
        }
        return methodName;
    }

    public boolean enableMultiSelectionFor(String operation) {
        return operation != null && operation.indexOf("Tips") != -1;
    }

    public boolean compatibleMethod(String method) {
        return method != null && method.indexOf("Tips") != -1;
    }

    public void discard() {
        super.discard();
        this.pointerArea.discard();
        int i = 0;
        while (i < this.pointers.length) {
            this.pointers[i].discard();
            this.pointers[i] = null;
            ++i;
        }
        this.pointers = null;
        this.textBox.discard();
        this.textComponent.discard();
    }

    public Font getFont() {
        return this.getTextComponent().getFont();
    }

    public String getText() {
        return this.getTextComponent().getText();
    }

    public void setFont(Font targetFont) {
        this.getTextComponent().setFont(targetFont);
        this.init();
    }

    public void setText(String newText) {
        this.getTextComponent().setText(newText);
        this.init();
    }
}

