/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolygon;
import animal.graphics.PTPolyline;
import animal.graphics.PTText;
import animal.graphics.meta.TextContainer;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import translator.AnimalTranslator;

public abstract class PTArray
extends PTGraphicObject
implements TextContainer {
    protected Font myFont;
    protected Color backgroundColor;
    protected Color fontColor;
    protected Color highlightColor;
    protected Color elementHighlightColor;
    protected FontMetrics fm;
    protected PTText[] entry;
    protected PTPolygon[] cells;
    protected boolean showIndices;
    protected final byte DEACTIVATED = 0;
    protected final byte ACTIVATED = 1;
    protected final byte HIGHLIGHTED = (byte)2;
    protected final byte ELEM_HIGHLIGHTED = (byte)4;
    protected byte[] states;
    protected int[] entryPos;
    protected Point origin;
    protected byte swapPercentage = 0;
    int[] swap = new int[]{-1, -1};
    public int length;

    public void setNum(int index, int cellID) {
        this.entry[index].setNum(cellID);
    }

    public void turnIndicesOff() {
        this.showIndices = false;
    }

    public void setDepth(int newDepth) {
        newDepth = newDepth < 2 ? 2 : newDepth;
        super.setDepth(newDepth);
        if (this.entry != null) {
            int i = 0;
            while (i < this.entry.length) {
                if (this.entry[i] != null) {
                    this.entry[i].setDepth(newDepth - 2);
                }
                if (this.cells[i] != null) {
                    this.cells[i].setDepth(newDepth);
                }
                ++i;
            }
        }
    }

    public void setActivated(int i, boolean state) {
        if (i >= 0 && i < this.states.length) {
            if (state) {
                this.states[i] = (byte)(this.states[i] | 1);
                this.cells[i].setFillColor(this.isHighlighted(i) ? this.getHighlightColor() : this.getBGColor());
                this.entry[i].setColor(this.isElemHighlighted(i) ? this.getElemHighlightColor() : this.getFontColor());
            } else {
                this.states[i] = (byte)(this.states[i] & 0xFFFFFFFE);
                this.cells[i].setFillColor(Color.GRAY);
                this.entry[i].setColor(Color.DARK_GRAY);
            }
        }
    }

    public boolean isActivated(int i) {
        if (i >= 0 && i < this.states.length) {
            return (this.states[i] & 1) == 1;
        }
        return false;
    }

    public void setHighlighted(int i, boolean state) {
        if (i >= 0 && i < this.states.length) {
            byte by = this.states[i] = state ? (byte)(this.states[i] | 2) : (byte)(this.states[i] & 0xFFFFFFFD);
            if (this.isActivated(i)) {
                this.cells[i].setFillColor(state ? this.getHighlightColor() : this.getBGColor());
            }
        }
    }

    public boolean isHighlighted(int i) {
        if (i >= 0 && i < this.states.length) {
            return (this.states[i] & 2) == 2;
        }
        return false;
    }

    public void setElemHighlighted(int i, boolean state) {
        if (i >= 0 && i < this.states.length) {
            byte by = this.states[i] = state ? (byte)(this.states[i] | 4) : (byte)(this.states[i] & 0xFFFFFFFB);
            if (this.isActivated(i)) {
                this.entry[i].setColor(state ? this.getElemHighlightColor() : this.getFontColor());
            }
        }
    }

    public boolean isElemHighlighted(int i) {
        if (i >= 0 && i < this.states.length) {
            return (this.states[i] & 4) == 4;
        }
        return false;
    }

    public void setLocation(Point p) {
        this.setOrigin(p);
    }

    public void setOrigin(Point p) {
        this.setOrigin(p.x, p.y);
    }

    public void setOrigin(int xpos, int ypos) {
        this.translate(xpos - this.origin.x, ypos - this.origin.y);
    }

    public void setSize(int n) {
        this.init(n);
    }

    public int getSize() {
        if (this.entry != null) {
            return this.entry.length;
        }
        return 0;
    }

    public void setBGColor(Color c) {
        this.backgroundColor = c;
        int i = 0;
        while (i < this.cells.length) {
            if (this.isActivated(i)) {
                this.cells[i].setFillColor(this.isHighlighted(i) ? this.getHighlightColor() : c);
            }
            ++i;
        }
    }

    public Color getBGColor() {
        return this.backgroundColor;
    }

    public void setFont(Font f) {
        this.myFont = f;
        this.fm = this.getFontMetrics();
        int textOffset = -this.fm.getAscent();
        int heightOffset = -this.fm.getAscent() - this.fm.getDescent();
        this.fm = Animal.getConcreteFontMetrics(f);
        textOffset += this.fm.getAscent();
        heightOffset = heightOffset + this.fm.getAscent() + this.fm.getDescent();
        int widthOffset = 0;
        int i = 0;
        while (i < this.entry.length) {
            this.entry[i].setFont(f);
            this.translate(i, 0, textOffset, true, false);
            this.resizeCell(i, heightOffset);
            this.translate(i, widthOffset, 0, true, true);
            int prevOffset = widthOffset;
            widthOffset = widthOffset + this.cellWidth(i) - this.getBoundingBox((int)i).width;
            this.resizeCell(i, this.cellWidth(i) - this.getBoundingBox((int)i).width, false);
            if (i > 0) {
                this.entryPos[i - 1] = this.entryPos[i - 1] + prevOffset;
            }
            ++i;
        }
        this.entryPos[this.entryPos.length - 1] = this.entryPos[this.entryPos.length - 1] + widthOffset;
    }

    public Font getFont() {
        if (this.myFont == null) {
            this.myFont = new Font("SansSerif", 0, 12);
        }
        return this.myFont;
    }

    public FontMetrics getFontMetrics() {
        this.fm = Animal.getConcreteFontMetrics(this.getFont());
        return this.fm;
    }

    public void setFontColor(Color c) {
        if (c != null) {
            this.fontColor = c;
        }
        int i = 0;
        while (i < this.entry.length) {
            if (this.isActivated(i)) {
                this.entry[i].setColor(this.isElemHighlighted(i) ? this.getElemHighlightColor() : c);
            }
            ++i;
        }
    }

    public Color getFontColor() {
        if (this.fontColor == null) {
            this.fontColor = Color.BLACK;
        }
        return this.fontColor;
    }

    public void setHighlightColor(Color c) {
        if (c != null) {
            this.highlightColor = c;
        }
        int i = 0;
        while (i < this.cells.length) {
            if (this.isActivated(i)) {
                this.cells[i].setFillColor(this.isHighlighted(i) ? c : this.getBGColor());
            }
            ++i;
        }
    }

    public Color getHighlightColor() {
        if (this.highlightColor == null) {
            this.highlightColor = Color.YELLOW;
        }
        return this.highlightColor;
    }

    public void setElemHighlightColor(Color c) {
        this.elementHighlightColor = c;
        int i = 0;
        while (i < this.entry.length) {
            if (this.isActivated(i)) {
                this.entry[i].setColor(this.isElemHighlighted(i) ? c : this.getFontColor());
            }
            ++i;
        }
    }

    public Color getElemHighlightColor() {
        return this.elementHighlightColor;
    }

    public void setOutlineColor(Color c) {
        this.color = c;
        int i = 0;
        while (i < this.cells.length) {
            this.cells[i].setColor(c);
            ++i;
        }
    }

    public Color getOutlineColor() {
        return this.color;
    }

    public int put(int index, PTText content) {
        this.showIndices = this.indicesShown();
        if (index >= 0 && index < this.entry.length) {
            this.entry[index] = content;
            int delta = index == 0 ? this.cellWidth(0) - this.entryPos[0] : this.cellWidth(index) - this.getBoundingBox((int)index).width;
            int i = index;
            while (i < this.entry.length) {
                int n = i++;
                this.entryPos[n] = this.entryPos[n] + delta;
            }
            return 0;
        }
        return -1;
    }

    public PTText getEntry(int index) {
        if (index >= 0 && index < this.entry.length) {
            this.entry[index].setNum(this.entry[index].getNum(true));
            return this.entry[index];
        }
        return null;
    }

    public String getStringValueAt(int index) {
        PTText textEntry = this.getEntry(index);
        if (textEntry == null) {
            return "";
        }
        return textEntry.getText();
    }

    public abstract void enterStringValueAt(int var1, String var2);

    public PTPolygon getCell(int index) {
        if (index >= 0 && index < this.entry.length) {
            this.cells[index].setNum(this.cells[index].getNum(true));
            return this.cells[index];
        }
        return null;
    }

    public Rectangle getBoundingBox() {
        return new Rectangle(this.origin.x, this.origin.y, this.entryPos[this.entry.length - 1], this.fm.getAscent() + this.fm.getDescent() + 10);
    }

    public Rectangle getBoundingBox(int i) {
        if (i >= this.entry.length || i < 0) {
            return new Rectangle(-1, -1, -1, -1);
        }
        if (i == 0) {
            return new Rectangle(this.origin.x, this.origin.y, this.entryPos[0], this.fm.getAscent() + this.fm.getDescent() + 10);
        }
        return new Rectangle(this.origin.x + this.entryPos[i - 1], this.origin.y, this.entryPos[i] - this.entryPos[i - 1], this.fm.getAscent() + this.fm.getDescent() + 10);
    }

    public Rectangle[] getBoundingBoxes() {
        Rectangle[] bBoxes = new Rectangle[this.entryPos.length];
        int i = 0;
        while (i < this.entryPos.length) {
            bBoxes[i] = this.getBoundingBox(i);
            ++i;
        }
        return bBoxes;
    }

    public Point getArrowPoint(int i) {
        if (i == 0) {
            return new Point(this.origin.x + this.entryPos[0] / 2, this.origin.y + this.fm.getAscent() + this.fm.getDescent() + 15);
        }
        if (i > 0 && i < this.entry.length) {
            return new Point(this.origin.x + this.entryPos[i - 1] + (this.entryPos[i] - this.entryPos[i - 1]) / 2, this.origin.y + this.fm.getAscent() + this.fm.getDescent() + 15);
        }
        return new Point(-1, -1);
    }

    public void translate(int dx, int dy) {
        this.origin.x += dx;
        this.origin.y += dy;
        int i = 0;
        while (i < this.entry.length) {
            this.translate(i, dx, dy, true, true);
            ++i;
        }
    }

    public void translate(int[] index, int dx, int dy, boolean text, boolean cell) {
        if (index != null) {
            int idx = 0;
            while (idx < index.length) {
                this.translate(index[idx], dx, dy, text, cell);
                ++idx;
            }
        }
    }

    public void translate(int index, int dx, int dy, boolean text, boolean cell) {
        if (index >= 0 && index < this.entry.length) {
            if (text) {
                this.entry[index].translate(dx, dy);
            }
            if (cell) {
                this.cells[index].translate(dx, dy);
            }
        }
    }

    public void resizeCell(int index, int dx, boolean leftRight) {
        if (this.cells[index].getNodeCount() != 4) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("nodeCountError"), 8);
        } else if (leftRight) {
            boolean[] blArray = new boolean[5];
            blArray[0] = true;
            blArray[3] = true;
            blArray[4] = true;
            this.cells[index].translate(blArray, dx, 0);
        } else {
            boolean[] blArray = new boolean[5];
            blArray[1] = true;
            blArray[2] = true;
            this.cells[index].translate(blArray, dx, 0);
        }
    }

    public void resizeCell(int index, int dy) {
        if (this.cells[index].getNodeCount() != 4) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("nodeCountError"), 8);
        } else {
            boolean[] blArray = new boolean[5];
            blArray[2] = true;
            blArray[3] = true;
            this.cells[index].translate(blArray, 0, dy);
        }
    }

    public byte getSwapPercentage() {
        return this.swapPercentage;
    }

    public void setSwapPercentage(int p) {
        this.setSwapPercentage((byte)p);
    }

    public void setSwapPercentage(float p) {
        if (p >= 0.0f && p <= 1.0f) {
            this.setSwapPercentage((byte)(100.0f * p));
        } else {
            this.setSwapPercentage((byte)p);
        }
    }

    public void setSwapPercentage(byte p) {
        this.swapPercentage = (byte)Math.max(0, Math.min(100, p));
    }

    public void setSwapCells(int a, int b) {
        if (b != a) {
            if (b < a) {
                int x = a;
                a = b;
                b = x;
            }
            if (a < 0 || b >= this.entry.length) {
                this.swap[0] = -1;
                this.swap[1] = -1;
            } else {
                this.swap[0] = a;
                this.swap[1] = b;
            }
        } else {
            this.swap[0] = -1;
            this.swap[1] = -1;
        }
    }

    public void setSwapCells(int[] affectedCells) {
        if (affectedCells.length == 2) {
            this.setSwapCells(affectedCells[0], affectedCells[1]);
        }
    }

    public void doSwap(int first, int second) {
        if (first >= 0 && second < this.entry.length) {
            int diff = this.getBoundingBox((int)second).width - this.getBoundingBox((int)first).width;
            int j = first;
            while (j < second) {
                int n = j++;
                this.entryPos[n] = this.entryPos[n] + diff;
            }
            PTText tmp = this.entry[first];
            this.entry[first] = this.entry[second];
            this.entry[second] = tmp;
        }
        this.showIndices = this.indicesShown();
    }

    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".arraySize", this.getSize());
        defaultProperties.put(String.valueOf(this.getType()) + ".bgColor", this.getBGColor());
        defaultProperties.put(String.valueOf(this.getType()) + ".elemHighlightColor", this.getElemHighlightColor());
        Font f = this.getFont();
        if (f != null) {
            defaultProperties.put(String.valueOf(this.getType()) + ".font", f);
            defaultProperties.put(String.valueOf(this.getType()) + ".fontColor", this.getFontColor());
            defaultProperties.put(String.valueOf(this.getType()) + ".fontName", f.getFamily());
            defaultProperties.put(String.valueOf(this.getType()) + ".fontSize", f.getSize());
            defaultProperties.put(String.valueOf(this.getType()) + ".fontStyle", f.getStyle());
        }
        defaultProperties.put(String.valueOf(this.getType()) + ".highlightColor", this.getHighlightColor());
        defaultProperties.put(String.valueOf(this.getType()) + ".location", this.origin);
        defaultProperties.put(String.valueOf(this.getType()) + ".outlineColor", this.getOutlineColor());
        defaultProperties.put(String.valueOf(this.getType()) + ".showIndices", this.indicesShown());
    }

    protected void cloneCommonFeaturesInto(PTArray targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.myFont = new Font(this.myFont.getName(), this.myFont.getStyle(), this.myFont.getSize());
        targetShape.fm = Animal.getConcreteFontMetrics(this.fm.getFont());
        targetShape.entryPos = new int[this.entryPos.length];
        targetShape.entry = new PTText[this.entry.length];
        targetShape.cells = new PTPolygon[this.cells.length];
        targetShape.states = new byte[this.states.length];
        targetShape.origin = (Point)this.origin.clone();
        int i = 0;
        while (i < this.entry.length) {
            targetShape.entryPos[i] = this.entryPos[i];
            targetShape.entry[i] = (PTText)this.entry[i].clone();
            targetShape.cells[i] = (PTPolygon)this.cells[i].clone();
            targetShape.states[i] = this.states[i];
            ++i;
        }
    }

    public String toString() {
        String toString = new String();
        toString = this.getType();
        if (this.getObjectName() != null) {
            toString.concat(" '" + this.getObjectName() + "'");
        }
        toString.concat(" with " + this.entry.length + " entries (");
        int c = 0;
        while (c < this.entry.length) {
            toString.concat(this.entry[c].getText());
            if (c == this.entry.length - 1) {
                toString.concat(")");
            } else {
                toString.concat(", ");
            }
            ++c;
        }
        return toString;
    }

    public void showIndices(boolean state) {
        this.showIndices = state;
        this.showIndices = state;
    }

    public boolean indicesShown() {
        return this.showIndices;
    }

    protected abstract PTText createInternalValue(int var1, Font var2);

    protected void init(int nrEntries) {
        this.length = nrEntries;
        if (this.origin == null) {
            this.origin = new Point(10, 10);
        }
        this.entry = new PTText[this.length];
        this.entryPos = new int[this.length];
        this.cells = new PTPolygon[this.length];
        this.setDepth(this.getDepth() < 2 ? 2 : this.getDepth());
        this.getFont();
        this.entry[0] = this.createInternalValue(0, this.myFont);
        this.entryPos[0] = this.cellWidth(0);
        this.entry[0].setPosition(new Point(this.origin.x + 5, this.origin.y + this.getFontMetrics().getAscent() + 5));
        this.entry[0].setColor(this.getFontColor());
        this.entry[0].setDepth(this.getDepth() - 2);
        this.cells[0] = new PTPolygon(new int[]{this.origin.x, this.origin.x + this.entryPos[0], this.origin.x + this.entryPos[0], this.origin.x}, new int[]{this.origin.y, this.origin.y, this.origin.y + this.fm.getAscent() + this.fm.getDescent() + 10, this.origin.y + this.fm.getAscent() + this.fm.getDescent() + 10});
        this.cells[0].setDepth(this.getDepth());
        this.cells[0].setFilled(true);
        this.cells[0].setColor(this.getOutlineColor());
        this.cells[0].setFillColor(this.getBGColor());
        this.states = new byte[this.length];
        this.states[0] = 1;
        int index = 1;
        while (index < this.length) {
            this.entry[index] = this.createInternalValue(index, this.myFont);
            this.entryPos[index] = this.entryPos[index - 1] + this.cellWidth(index);
            this.entry[index].setPosition(new Point(this.origin.x + this.entryPos[index - 1] + 5, this.origin.y + this.fm.getAscent() + 5));
            this.entry[index].setColor(this.getFontColor());
            this.entry[index].setDepth(this.getDepth() - 2);
            this.cells[index] = new PTPolygon(new int[]{this.origin.x + this.entryPos[index - 1], this.origin.x + this.entryPos[index], this.origin.x + this.entryPos[index], this.origin.x + this.entryPos[index - 1]}, new int[]{this.origin.y, this.origin.y, this.origin.y + this.fm.getAscent() + this.fm.getDescent() + 10, this.origin.y + this.fm.getAscent() + this.fm.getDescent() + 10});
            this.cells[index].setDepth(this.getDepth());
            this.cells[index].setFilled(true);
            this.cells[index].setColor(this.getOutlineColor());
            this.cells[index].setFillColor(this.getBGColor());
            this.states[index] = 1;
            ++index;
        }
    }

    public void initializeWithDefaults(String primitiveName) {
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.backgroundColor = config.getDefaultColor(primitiveName, "bgColor", Color.WHITE);
        this.elementHighlightColor = config.getDefaultColor(primitiveName, "elemHighlightColor", Color.BLUE);
        this.fontColor = config.getDefaultColor(primitiveName, "fontColor", Color.BLACK);
        this.highlightColor = config.getDefaultColor(primitiveName, "highlightColor", Color.RED);
        String fontName = config.getProperty(String.valueOf(primitiveName) + ".fontName", "SansSerif");
        int fontSize = config.getDefaultIntValue(primitiveName, "fontSize", 14);
        int fontStyle = config.getDefaultIntValue(primitiveName, "fontStyle", 0);
        this.myFont = new Font(fontName, fontStyle, fontSize);
        this.origin = new Point(10, 10);
        this.showIndices = config.getDefaultBooleanValue(primitiveName, "showIndices", false);
    }

    protected int cellWidth(int index) {
        if (this.entry[index] != null) {
            return this.entry[index].getBoundingBox().width + 10;
        }
        return 10;
    }

    protected int swapOffset(int index) {
        if (this.swap[0] < 0 || this.swap[1] >= this.entry.length || index <= this.swap[0] || index > this.swap[1]) {
            return 0;
        }
        return (this.cellWidth(this.swap[1]) - this.cellWidth(this.swap[0])) * this.getSwapPercentage() / 100;
    }

    protected int widthOffset(int index) {
        if (index == this.swap[0]) {
            return (this.cellWidth(this.swap[1]) - this.cellWidth(this.swap[0])) * this.getSwapPercentage() / 100;
        }
        if (index == this.swap[1]) {
            return (this.cellWidth(this.swap[0]) - this.cellWidth(this.swap[1])) * this.getSwapPercentage() / 100;
        }
        return 0;
    }

    protected Point upperSwapPoint() {
        PTPolyline pl = new PTPolyline();
        Rectangle a = this.getBoundingBox(this.swap[1]);
        Rectangle b = this.getBoundingBox(this.swap[0]);
        pl.addNode(new PTPoint(a.x + 5, a.y + this.fm.getAscent() + 5));
        pl.addNode(new PTPoint(a.x + 5, a.y - this.fm.getDescent() - 5));
        pl.addNode(new PTPoint(b.x + 5, b.y - this.fm.getDescent() - 5));
        pl.addNode(new PTPoint(b.x + 5, b.y + this.fm.getAscent() + 5));
        return pl.getPointAtLength(pl.getLength() * this.getSwapPercentage() / 100);
    }

    protected Point lowerSwapPoint() {
        PTPolyline pl = new PTPolyline();
        Rectangle a = this.getBoundingBox(this.swap[0]);
        Rectangle b = this.getBoundingBox(this.swap[1]);
        pl.addNode(new PTPoint(a.x + 5, a.y + this.fm.getAscent() + 5));
        pl.addNode(new PTPoint(a.x + 5, a.y + a.height + this.fm.getAscent() + 5));
        pl.addNode(new PTPoint(b.x + b.width - a.width + 5, b.y + b.height + this.fm.getAscent() + 5));
        pl.addNode(new PTPoint(b.x + b.width - a.width + 5, b.y + this.fm.getAscent() + 5));
        return pl.getPointAtLength(pl.getLength() * this.getSwapPercentage() / 100);
    }

    public void paint(Graphics g) {
        g.setFont(this.myFont);
        if (!this.getEditor().isVisible()) {
            this.setActivated(0, this.isActivated(0));
        }
        float[] hsb = Color.RGBtoHSB(this.getBGColor().getRed(), this.getBGColor().getGreen(), this.getBGColor().getBlue(), null);
        int index = 0;
        while (index < this.entry.length) {
            this.cells[index].paint(g);
            if (this.showIndices) {
                PTText idx = new PTText(String.valueOf(index), this.myFont);
                idx.setLocation(new Point(this.getBoundingBox((int)index).x + this.getBoundingBox((int)index).width - this.fm.stringWidth(String.valueOf(index)), this.getBoundingBox((int)index).y + this.getBoundingBox((int)index).height));
                idx.setDepth(this.getDepth() - 1);
                if ((double)hsb[2] > 0.5) {
                    if ((double)hsb[1] > 0.5) {
                        idx.setColor(Color.getHSBColor(hsb[0], hsb[1] - 0.1f, hsb[2]).darker());
                    } else {
                        idx.setColor(Color.getHSBColor(hsb[0], hsb[1] + 0.1f, hsb[2]).darker());
                    }
                } else if ((double)hsb[1] > 0.5) {
                    idx.setColor(Color.getHSBColor(hsb[0], hsb[1] - 0.1f, hsb[2]).brighter());
                } else {
                    idx.setColor(Color.getHSBColor(hsb[0], hsb[1] + 0.1f, hsb[2]).brighter());
                }
                idx.paint(g);
            }
            this.entry[index].paint(g);
            ++index;
        }
    }
}

