/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.animalascii.Importer;
import animal.graphics.PTGraphicObject;
import animal.graphics.meta.FillablePrimitive;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import java.io.IOException;
import java.io.StreamTokenizer;

public class PTGraphicObjectImporter
implements Importer {
    public Object importFrom(int version, StreamTokenizer stok) {
        MessageDisplay.errorMsg("invalidImportCall", new String[]{String.valueOf(stok.lineno()), String.valueOf(version), this.getClass().getName()}, 4);
        try {
            MessageDisplay.errorMsg("readErrorLine", new String[]{ParseSupport.consumeIncludingEOL(stok, "object")}, 2);
        }
        catch (IOException e) {
            MessageDisplay.errorMsg("ioErrorImporting", new String[]{e.getMessage()}, 4);
        }
        return null;
    }

    public void parseEndingValuesFrom(StreamTokenizer stok, PTGraphicObject shape, String key) {
        try {
            ParseSupport.parseMandatoryWord(stok, String.valueOf(key) + " keyword 'depth'", "depth");
            shape.setDepth(ParseSupport.parseInt(stok, String.valueOf(key) + " depth"));
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(key) + " keyword [name]", "name")) {
                shape.setObjectName(ParseSupport.parseText(stok, "Object name"));
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
    }

    public void parseFillAttributes(StreamTokenizer stok, FillablePrimitive shape, String key) {
        try {
            shape.setFilled(ParseSupport.parseOptionalWord(stok, String.valueOf(key) + " filled", "filled"));
            if (shape.isFilled()) {
                shape.setFillColor(ParseSupport.parseColor(stok, key, "fillColor"));
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
    }
}

