/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalascii;

import animal.exchange.AnimalASCIIImporter;
import animal.exchange.animalascii.PTGraphicObjectImporter;
import animal.graphics.PTArc;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animalscript.core.AnimalParseSupport;
import java.awt.Font;
import java.awt.Point;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;
import translator.AnimalTranslator;

public class PTArcImporter
extends PTGraphicObjectImporter {
    public Object importFrom(int version, StreamTokenizer stok) {
        PTArc arc = new PTArc();
        try {
            if (version > arc.getFileVersion()) {
                throw new StreamCorruptedException(AnimalASCIIImporter.translateMessage("fileVersionMismatch", new Object[]{String.valueOf(version), String.valueOf(arc.getFileVersion()), stok.toString()}));
            }
            ParseSupport.parseMandatoryWord(stok, AnimalTranslator.translateMessage("arcCenter"), "center");
            arc.setCenter(ParseSupport.parseNode(stok, AnimalTranslator.translateMessage("arcCenter")));
            ParseSupport.parseMandatoryWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Arc", "rX"), "rX");
            int x = ParseSupport.parseInt(stok, AnimalASCIIImporter.translateMessage("arcRadiusXY", (Object)"x"));
            ParseSupport.parseMandatoryWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Move", "rY"), "rY");
            int y = ParseSupport.parseInt(stok, AnimalASCIIImporter.translateMessage("arcRadiusXY", (Object)"y"));
            arc.setRadius(new Point(x, y));
            arc.setColor(ParseSupport.parseColor(stok, "Arc"));
            if (version >= 5 && ParseSupport.parseOptionalWord(stok, "Arc fillColor", "fillColor")) {
                stok.pushBack();
                arc.setFillColor(ParseSupport.parseColor(stok, "Arc fillColor", "fillColor"));
            }
            ParseSupport.parseMandatoryWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Arc", "angle"), "angle");
            arc.setArcAngle(ParseSupport.parseInt(stok, "Arc angle value"));
            ParseSupport.parseMandatoryWord(stok, AnimalASCIIImporter.translateMessage("otKw", "Move", "starts"), "starts");
            arc.setStartAngle(ParseSupport.parseInt(stok, "Arc angle start"));
            arc.setFilled(ParseSupport.parseOptionalWord(stok, "Arc filled", "filled"));
            arc.setCircle(ParseSupport.parseOptionalWord(stok, "Arc circle", "circle"));
            arc.setClockwise(ParseSupport.parseOptionalWord(stok, "Arc clockwise", "clockwise"));
            arc.setFWArrow(ParseSupport.parseOptionalWord(stok, "Arc fwArrow", "fwArrow"));
            arc.setBWArrow(ParseSupport.parseOptionalWord(stok, "Arc bwArrow", "bwArrow"));
            arc.setClosed(ParseSupport.parseOptionalWord(stok, "Arc closed", "closed"));
            ParseSupport.parseMandatoryWord(stok, "Arc keyword 'text'", "text");
            ParseSupport.parseMandatoryChar(stok, "Arc keyword text ':'", ':');
            arc.setText(AnimalParseSupport.parseText(stok, "Arc text component"));
            arc.setTextColor(ParseSupport.parseColor(stok, "Arc textColor", "textColor"));
            if (version >= 5 && ParseSupport.parseOptionalWord(stok, "Arc Font into", "Font")) {
                stok.pushBack();
                ParseSupport.parseMandatoryWord(stok, "Arc keyword 'Font'", "Font");
                ParseSupport.parseMandatoryChar(stok, "Arc keyword text '{'", '{');
                String fontName = AnimalParseSupport.parseText(stok, "Arc FontName");
                int fontStyle = ParseSupport.parseInt(stok, "Arc textStyle");
                int fontSize = ParseSupport.parseInt(stok, "Arc textSize");
                arc.getTextComponent().setFont(new Font(fontName, fontStyle, fontSize));
                ParseSupport.parseMandatoryChar(stok, "Arc keyword text '}'", '}');
            }
            if (version >= 4 && ParseSupport.parseOptionalWord(stok, "Arc Depth into", "depth")) {
                stok.pushBack();
                ParseSupport.parseMandatoryWord(stok, "Arc keyword 'depth'", "depth");
                arc.setDepth(ParseSupport.parseInt(stok, "Arc depth"));
            }
        }
        catch (IOException e) {
            MessageDisplay.errorMsg(e.getMessage(), 4);
        }
        return arc;
    }
}

