/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange;

import animal.gui.AnimalMainWindow;
import animal.main.Animal;
import animal.main.AnimationCanvas;
import animal.misc.MessageDisplay;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import translator.AnimalTranslator;

public class AnimationPrintJob {
    public AnimationPrintJob(Animal animal) {
        PrintJob pj = animal.getToolkit().getPrintJob(animal, "animPrint", null);
        if (pj != null) {
            Graphics g = pj.getGraphics();
            AnimationCanvas canvas = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(true).getAnimationCanvas();
            if (canvas != null) {
                Image animationImage = canvas.getCurrentImage();
                g.drawImage(animationImage, 0, 0, canvas);
                g.dispose();
                pj.end();
            } else {
                MessageDisplay.message(AnimalTranslator.translateMessage("canvasNullForPrinting"));
            }
        } else {
            MessageDisplay.message(AnimalTranslator.translateMessage("printJobNullForPrinting"));
        }
    }
}

