/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.graphics;

import animal.editor.Editor;
import animal.editor.graphics.AbstractTextEditor;
import animal.editor.graphics.IntArrayEditor;
import animal.editor.graphics.StringArrayEditor;
import animal.graphics.PTArray;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTIntArray;
import animal.graphics.PTStringArray;
import animal.gui.DrawCanvas;
import animal.main.Animation;
import animal.misc.ColorChooserAction;
import animal.misc.EditPoint;
import animal.misc.EditableObject;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import translator.AnimalTranslator;
import translator.ExtendedActionButton;
import translator.TranslatableGUIElement;

public abstract class AbstractArrayEditor
extends AbstractTextEditor
implements ChangeListener,
ActionListener,
PropertyChangeListener,
KeyListener {
    private static final long serialVersionUID = 2295451210979833754L;
    protected String actualType;
    protected ColorChooserAction colorChooser;
    protected ColorChooserAction highlightColorChooser;
    protected ColorChooserAction elemHighlightColorChooser;
    protected ColorChooserAction fillColorChooser;
    protected ColorChooserAction fontColorChooser;
    protected JTextField arraySize;
    protected JTextField content;
    protected int nrArrayElems = 10;
    protected JSpinner arraySpinner;
    protected JCheckBox showIndicesCB;
    protected boolean firstEdit = true;

    public AbstractArrayEditor(String arrayType) {
        this.actualType = arrayType;
    }

    protected void buildGUI(String arrayType) {
        this.actualType = arrayType;
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        this.addBox(this.createArraySizeBox(generator));
        if (this.nrArrayElems == 0) {
            this.nrArrayElems = 10;
        }
        this.addBox(this.createArrayValueBox(generator, this.nrArrayElems));
        this.addBox(this.createIndicesOptionsBox(generator));
        this.addBox(this.createColorBox(generator, arrayType));
        this.addBox(this.generateFontAndStyleBox(generator, "AbstractTextEditor.fontBL"));
        this.finishBoxes();
    }

    protected AbstractArrayEditor(String type, int i) {
        this(type);
        this.arraySize.setText(String.valueOf(i));
    }

    protected Box createArrayValueBox(TranslatableGUIElement generator, int targetSize) {
        Box spinnerBox = generator.generateBorderedBox(3, "AbstractArrayEditor.arrayValuesBL");
        Box elementChoiceBox = new Box(2);
        elementChoiceBox.add(generator.generateJLabel("AbstractArrayEditor.arrayCell"));
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(0, 0, targetSize - 1, 1);
        this.arraySpinner = new JSpinner(spinnerModel);
        elementChoiceBox.add(this.arraySpinner);
        this.arraySpinner.addChangeListener(this);
        elementChoiceBox.add(new JLabel(" / " + String.valueOf(targetSize)));
        spinnerBox.add(elementChoiceBox);
        Box valueBox = new Box(2);
        valueBox.add(generator.generateJLabel("AbstractArrayEditor.cellContent"));
        int spinnerValue = spinnerModel.getNumber().intValue();
        String text = this.getCurrentObject(false) == null ? "" : ((PTArray)this.getCurrentObject(false)).getStringValueAt(spinnerValue);
        this.content = new JTextField(15);
        this.content.setText(text);
        this.content.addKeyListener(this);
        valueBox.add(this.content);
        spinnerBox.add(valueBox);
        return spinnerBox;
    }

    protected Box createColorBox(TranslatableGUIElement generator, String type) {
        Box colorBox = generator.generateBorderedBox(2, "GenericEditor.colorBL");
        Box firstColumnBox = generator.generateBorderedBox(3, "AbstractArrayEditor.basicColors");
        firstColumnBox.add(generator.generateJLabel("GenericEditor.colorLabel"));
        Color initialColor = this.getCurrentObject(false) == null ? Color.white : ((PTArray)this.getCurrentObject(false)).getOutlineColor();
        this.colorChooser = this.createColorChooser("color", String.valueOf(type) + "Editor.arrayType", initialColor);
        firstColumnBox.add(new ExtendedActionButton(this.colorChooser, 67));
        firstColumnBox.add(generator.generateJLabel("AbstractArrayEditor.fontColorLabel"));
        Color fontInitialColor = this.getCurrentObject(false) == null ? Color.black : ((PTArray)this.getCurrentObject(false)).getFontColor();
        this.fontColorChooser = this.createColorChooser("fontColor", String.valueOf(type) + "Editor.arrayType", fontInitialColor);
        firstColumnBox.add(new ExtendedActionButton(this.fontColorChooser, 70));
        firstColumnBox.add(generator.generateJLabel("GenericEditor.fillColorLabel"));
        Color initialFillColor = this.getCurrentObject(false) == null ? Color.black : ((PTArray)this.getCurrentObject(false)).getOutlineColor();
        this.fillColorChooser = this.createColorChooser("fillColor", String.valueOf(type) + "Editor.arrayType", initialFillColor);
        firstColumnBox.add(new ExtendedActionButton(this.fillColorChooser, 79));
        colorBox.add(firstColumnBox);
        Box secondColumnBox = generator.generateBorderedBox(3, "AbstractArrayEditor.highlightColors");
        secondColumnBox.add(generator.generateJLabel("AbstractIndexedStructureEditor.hlColorLabel"));
        Color highlightInitialColor = this.getCurrentObject(false) == null ? Color.yellow : ((PTArray)this.getCurrentObject(false)).getHighlightColor();
        this.highlightColorChooser = this.createColorChooser("highlightColor", String.valueOf(type) + "Editor.arrayType", highlightInitialColor);
        secondColumnBox.add(new ExtendedActionButton(this.highlightColorChooser, 72));
        secondColumnBox.add(generator.generateJLabel("AbstractIndexedStructureEditor.elemHighlightColorLabel"));
        Color elemHighlightInitialColor = this.getCurrentObject(false) == null ? Color.red : ((PTArray)this.getCurrentObject(false)).getElemHighlightColor();
        this.elemHighlightColorChooser = this.createColorChooser("elemHighlightColor", String.valueOf(type) + "Editor.arrayType", elemHighlightInitialColor);
        secondColumnBox.add(new ExtendedActionButton(this.elemHighlightColorChooser, 69));
        colorBox.add(firstColumnBox);
        colorBox.add(secondColumnBox);
        return colorBox;
    }

    protected void ensureTypeSet() {
        if (this.actualType == null) {
            EditableObject o = this.getCurrentObject(false);
            if (o instanceof PTIntArray) {
                this.actualType = "IntArray";
            } else if (o instanceof PTStringArray) {
                this.actualType = "StringArray";
            }
        }
    }

    public void setProperties(XProperties props) {
        this.ensureTypeSet();
        this.colorChooser.setColor(props.getColorProperty(String.valueOf(this.actualType) + ".outlineColor", Color.WHITE));
        this.highlightColorChooser.setColor(props.getColorProperty(String.valueOf(this.actualType) + ".highlightColor", Color.YELLOW));
        this.elemHighlightColorChooser.setColor(props.getColorProperty(String.valueOf(this.actualType) + ".elemHighlightColor", Color.RED));
        this.fillColorChooser.setColor(props.getColorProperty(String.valueOf(this.actualType) + ".bgColor", Color.BLACK));
        this.fontColorChooser.setColor(props.getColorProperty(String.valueOf(this.actualType) + ".fontColor", Color.BLACK));
        this.arraySize.setText(String.valueOf(props.getIntProperty(String.valueOf(this.actualType) + ".arraySize", 1)));
        this.fontName.setSelectedItem(props.getProperty(String.valueOf(this.actualType) + ".fontName", "Monospaced"));
        this.fontSize.setSelectedItem(props.getProperty(String.valueOf(this.actualType) + ".fontSize", "14"));
        this.showIndicesCB.setSelected(props.getBoolProperty(String.valueOf(this.actualType) + ".showIndices", true));
    }

    protected Box createArraySizeBox(TranslatableGUIElement generator) {
        Box sizeBox = generator.generateBorderedBox(3, "arraySizeBL");
        Box internalBox = new Box(2);
        internalBox.add(generator.generateJLabel("AbstractArrayEditor.arraySize"));
        this.arraySize = new JTextField(8);
        this.arraySize.addActionListener(this);
        internalBox.add(this.arraySize);
        sizeBox.add(internalBox);
        sizeBox.add(this.createIndicesOptionsBox(generator));
        return sizeBox;
    }

    protected Box createIndicesOptionsBox(TranslatableGUIElement generator) {
        Box optionsBox = new Box(2);
        this.showIndicesCB = generator.generateJCheckBox("AbstractIndexedStructureEditor.showIndices", null, this);
        optionsBox.add(this.showIndicesCB);
        return optionsBox;
    }

    public void getProperties(XProperties props) {
        this.ensureTypeSet();
        props.put(String.valueOf(this.actualType) + ".outlineColor", this.colorChooser.getColor());
        props.put(String.valueOf(this.actualType) + ".highlightColor", this.highlightColorChooser.getColor());
        props.put(String.valueOf(this.actualType) + ".elemHighlightColor", this.elemHighlightColorChooser.getColor());
        props.put(String.valueOf(this.actualType) + ".bgColor", this.fillColorChooser.getColor());
        props.put(String.valueOf(this.actualType) + ".fontColor", this.fontColorChooser.getColor());
        props.put(String.valueOf(this.actualType) + ".arraySize", this.getInt(this.arraySize.getText(), 1));
        props.put((Object)(String.valueOf(this.actualType) + ".fontName"), this.fontName.getSelectedItem());
        props.put((Object)(String.valueOf(this.actualType) + ".fontSize"), this.fontSize.getSelectedItem());
        props.put(String.valueOf(this.actualType) + ".font", new Font((String)this.fontName.getSelectedItem(), 0, this.getInt((String)this.fontSize.getSelectedItem(), 14)));
        props.put(String.valueOf(this.actualType) + ".showIndices", this.showIndicesCB.isSelected());
    }

    public int pointsNeeded() {
        return 2;
    }

    public boolean nextPoint(int num, Point p) {
        switch (num) {
            case 1: 
            case 2: {
                ((PTArray)this.getCurrentObject()).setOrigin(p);
            }
        }
        return true;
    }

    public int getMinDist(PTGraphicObject go, Point p) {
        return MSMath.dist(p, go.getBoundingBox());
    }

    public EditPoint[] getEditPoints(PTGraphicObject go) {
        Rectangle bBox = ((PTArray)go).getBoundingBox();
        return new EditPoint[]{new EditPoint(-1, new Point(bBox.x, bBox.y)), new EditPoint(-2, new Point(bBox.x + bBox.width, bBox.y)), new EditPoint(-3, new Point(bBox.x, bBox.y + bBox.height)), new EditPoint(-4, new Point(bBox.x + bBox.width, bBox.y + bBox.height)), new EditPoint(-5, new Point(bBox.x + bBox.width / 2, bBox.y + bBox.height / 2))};
    }

    protected void storeAttributesInto(EditableObject eo) {
        super.storeAttributesInto(eo);
        PTArray array = (PTArray)eo;
        array.setOutlineColor(this.colorChooser.getColor());
        array.setHighlightColor(this.highlightColorChooser.getColor());
        array.setElemHighlightColor(this.elemHighlightColorChooser.getColor());
        array.setBGColor(this.fillColorChooser.getColor());
        array.setFontColor(this.fontColorChooser.getColor());
        if (this.arraySize != null) {
            array.setSize(this.getInt(this.arraySize.getText(), 1));
        }
        array.enterStringValueAt(this.calcIndex(), this.content.getText());
        array.setFont(this.storeFont());
        array.showIndices(this.showIndicesCB.isSelected());
    }

    Font storeFont() {
        String name = (String)this.fontName.getSelectedItem();
        String size = (String)this.fontSize.getSelectedItem();
        int fontStyle = 0;
        if (this.italic.isSelected()) {
            fontStyle |= 2;
        }
        if (this.bold.isSelected()) {
            fontStyle |= 1;
        }
        return new Font(name, fontStyle, this.getInt(size, 12));
    }

    void extractFont(Font f) {
        this.fontName.setSelectedItem(f.getName());
        this.fontSize.setSelectedItem(String.valueOf(f.getSize()));
        this.italic.setSelected(f.isItalic());
        this.bold.setSelected(f.isBold());
    }

    public Editor getSecondaryEditor(EditableObject e) {
        AbstractArrayEditor result = null;
        if (this.getCurrentObject(false) instanceof PTStringArray) {
            result = new StringArrayEditor(((PTArray)e).length);
        } else if (this.getCurrentObject(false) instanceof PTIntArray) {
            result = new IntArrayEditor(((PTArray)e).length);
        }
        result.firstEdit = false;
        this.nrArrayElems = ((PTArray)e).length;
        result.extractAttributesFrom(e);
        return result;
    }

    protected int calcIndex() {
        return this.arraySpinner == null ? -1 : ((SpinnerNumberModel)this.arraySpinner.getModel()).getNumber().intValue();
    }

    protected void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        PTArray array = (PTArray)eo;
        this.colorChooser.setColor(array.getOutlineColor());
        this.highlightColorChooser.setColor(array.getHighlightColor());
        this.elemHighlightColorChooser.setColor(array.getElemHighlightColor());
        this.fillColorChooser.setColor(array.getBGColor());
        this.fontColorChooser.setColor(array.getFontColor());
        if (this.arraySize != null) {
            this.arraySize.setText(String.valueOf(array.getSize()));
        }
        this.content.setText(array.getStringValueAt(this.calcIndex()));
        this.extractFont(array.getFont());
        this.showIndicesCB.setSelected(array.indicesShown());
    }

    public String getStatusLineMsg() {
        return AnimalTranslator.translateMessage(String.valueOf(this.actualType) + "Editor.statusLine", new Object[]{DrawCanvas.translateDrawButton(), DrawCanvas.translateFinishButton(), DrawCanvas.translateCancelButton()});
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        PTArray array = (PTArray)this.getCurrentObject();
        if (e.getSource() == this.content) {
            array.enterStringValueAt(this.calcIndex(), this.content.getText());
        }
        if (e.getSource() == this.arraySize) {
            array.setSize(this.getInt(this.arraySize.getText(), 1));
        }
        if (e.getSource() == this.fontName || e.getSource() == this.fontSize) {
            array.setFont(this.storeFont());
        }
        if (e.getSource() == this.showIndicesCB) {
            array.showIndices(this.showIndicesCB.isSelected());
        }
        this.repaintNow();
        Animation.get().doChange();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        PTArray array = (PTArray)this.getCurrentObject();
        if (e.getSource() == this.content) {
            array.enterStringValueAt(this.calcIndex(), this.content.getText());
        }
        this.repaintNow();
        Animation.get().doChange();
    }

    public abstract void keyTyped(KeyEvent var1);

    public void stateChanged(ChangeEvent e) {
        PTArray array = (PTArray)this.getCurrentObject();
        if (e.getSource() == this.arraySpinner) {
            this.content.setText(array.getStringValueAt(this.calcIndex()));
        }
        this.repaintNow();
        Animation.get().doChange();
    }

    public void propertyChange(PropertyChangeEvent event) {
        PTArray array = (PTArray)this.getCurrentObject();
        String eventName = event.getPropertyName();
        if ("color".equals(eventName)) {
            array.setOutlineColor((Color)event.getNewValue());
        }
        if ("highlightColor".equals(eventName)) {
            array.setHighlightColor((Color)event.getNewValue());
            array.getCell(0).setFillColor((Color)event.getNewValue());
        }
        if ("elemHighlightColor".equals(eventName)) {
            array.setElemHighlightColor((Color)event.getNewValue());
            array.getEntry(0).setColor((Color)event.getNewValue());
        }
        if ("fillColor".equals(eventName)) {
            array.setBGColor((Color)event.getNewValue());
        }
        if ("fontColor".equals(eventName)) {
            array.setFontColor((Color)event.getNewValue());
        }
        if (!event.getOldValue().equals(event.getNewValue())) {
            this.repaintNow();
            Animation.get().doChange();
        }
    }
}

