/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.animators;

import animal.animator.VariableUpdate;
import animal.editor.Editor;
import animal.editor.animators.AnimatorEditor;
import animal.misc.EditableObject;
import animal.misc.XProperties;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

public class VariableUpdateEditor
extends AnimatorEditor {
    private static final long serialVersionUID = -8972332883991718878L;
    private JTextField varNameField;
    private JTextField targetValueField;

    protected void buildGUI() {
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(2, 2));
        p.add(generator.generateJLabel("VariableUpdateEditor.name"));
        this.varNameField = new JTextField();
        p.add(this.varNameField);
        this.varNameField.setEditable(false);
        p.add(generator.generateJLabel("VariableUpdateEditor.value"));
        this.targetValueField = new JTextField();
        p.add(this.targetValueField);
        this.addLayer(p);
        this.finish();
    }

    public void setProperties(XProperties props) {
    }

    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        VariableUpdate varUpdate = (VariableUpdate)eo;
        this.varNameField.setText(varUpdate.getName());
        this.targetValueField.setText(varUpdate.getTargetValue());
    }

    public void storeAttributesInto(EditableObject editableObject) {
        super.storeAttributesInto(editableObject);
        VariableUpdate varUpdate = (VariableUpdate)editableObject;
        varUpdate.setName(this.varNameField.getText());
        varUpdate.setTargetValue(this.targetValueField.getText());
    }

    public Editor getSecondaryEditor(EditableObject eo) {
        VariableUpdateEditor result = new VariableUpdateEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    public EditableObject createObject() {
        VariableUpdate varDecl = new VariableUpdate();
        this.storeAttributesInto(varDecl);
        return varDecl;
    }
}

