/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.animators;

import animal.animator.VariableDeclaration;
import animal.editor.Editor;
import animal.editor.animators.AnimatorEditor;
import animal.misc.EditableObject;
import animal.misc.XProperties;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import translator.AnimalTranslator;
import translator.TranslatableGUIElement;

public class VariableDeclarationEditor
extends AnimatorEditor {
    private static final long serialVersionUID = -8972332883991718878L;
    private JTextField varNameField;
    private JTextField initialValueField;
    private JComboBox typeSelection;
    private JTextField activationFrameField;

    protected void buildGUI() {
        JPanel p = new JPanel();
        TranslatableGUIElement generator = AnimalTranslator.getGUIBuilder();
        p.setLayout(new GridLayout(4, 2));
        p.add(generator.generateJLabel("VariableDeclarationEditor.name"));
        this.varNameField = new JTextField();
        p.add(this.varNameField);
        p.add(generator.generateJLabel("VariableDeclarationEditor.type"));
        this.typeSelection = new JComboBox<String>(new String[]{"byte", "boolean", "char", "double", "float", "int", "long", "short", "String"});
        p.add(this.typeSelection);
        p.add(generator.generateJLabel("VariableDeclarationEditor.initialValue"));
        this.initialValueField = new JTextField();
        p.add(this.initialValueField);
        p.add(generator.generateJLabel("VariableDeclarationEditor.frame"));
        this.activationFrameField = new JTextField();
        p.add(this.activationFrameField);
        this.addLayer(p);
        this.finish();
    }

    public void setProperties(XProperties props) {
    }

    public void extractAttributesFrom(EditableObject eo) {
        super.extractAttributesFrom(eo);
        VariableDeclaration varDecl = (VariableDeclaration)eo;
        this.varNameField.setText(varDecl.getName());
        this.typeSelection.setSelectedItem(varDecl.getVariableType());
        this.activationFrameField.setText(varDecl.getActivationFrame());
        this.initialValueField.setText(varDecl.getInitialValue());
    }

    public void storeAttributesInto(EditableObject editableObject) {
        super.storeAttributesInto(editableObject);
        VariableDeclaration varDecl = (VariableDeclaration)editableObject;
        varDecl.setActivationFrame(this.activationFrameField.getText());
        varDecl.setName(this.varNameField.getText());
        varDecl.setInitialValue(this.initialValueField.getText());
        varDecl.setType((String)this.typeSelection.getSelectedItem());
    }

    public Editor getSecondaryEditor(EditableObject eo) {
        VariableDeclarationEditor result = new VariableDeclarationEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    public EditableObject createObject() {
        VariableDeclaration varDecl = new VariableDeclaration();
        this.storeAttributesInto(varDecl);
        return varDecl;
    }
}

