/*
 * Decompiled with CFR 0.152.
 */
package animal.editor.animators;

import animal.animator.Move;
import animal.animator.MoveBase;
import animal.animator.TimedAnimator;
import animal.editor.Editor;
import animal.editor.NodeSelector;
import animal.editor.animators.TimedAnimatorEditor;
import animal.graphics.PTBoxPointer;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTPolygon;
import animal.graphics.PTPolyline;
import animal.gui.AnimalMainWindow;
import animal.main.Animation;
import animal.misc.EditableObject;
import animal.misc.ObjectSelectionButton;
import animal.misc.XProperties;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import translator.AnimalTranslator;

public class MoveEditor
extends TimedAnimatorEditor
implements ItemListener,
ActionListener {
    private static final long serialVersionUID = -7803131333584934158L;
    private ObjectSelectionButton pathOSB;
    private boolean[] selectedNodes;
    private NodeSelector nodeSelector;

    protected void buildGUI() {
        super.buildGUI();
        JPanel c = new JPanel();
        c.add(AnimalTranslator.getGUIBuilder().generateJLabel("MoveEditor.moveVia"));
        this.pathOSB = new ObjectSelectionButton(false);
        c.add(this.pathOSB);
        this.addLayer(c);
        this.methodChoice.addItemListener(this);
        this.finish();
    }

    public void setProperties(XProperties props) {
        super.setProperties(props);
    }

    public void extractAttributesFrom(EditableObject move) {
        this.methodChoice.removeItemListener(this);
        super.extractAttributesFrom(move);
        TimedAnimator ta = (TimedAnimator)move;
        if (ta.getMethod() != null && !this.methodChoice.getSelectedItem().equals(ta.getMethod())) {
            this.methodChoice.addItem(ta.getMethod());
            this.methodChoice.setSelectedItem(ta.getMethod());
        }
        this.methodChoice.addItemListener(this);
        this.pathOSB.setObjectNum(((Move)move).getMoveBaseNum());
    }

    public void storeAttributesInto(EditableObject move) {
        super.storeAttributesInto(move);
        ((Move)move).setMoveBaseNum(this.pathOSB.getObjectNum());
    }

    public Editor getSecondaryEditor(EditableObject eo) {
        MoveEditor result = new MoveEditor();
        result.extractAttributesFrom(eo);
        return result;
    }

    public EditableObject createObject() {
        Move m = new Move();
        this.storeAttributesInto(m);
        return m;
    }

    public void itemStateChanged(ItemEvent e) {
        block10: {
            block4: {
                block5: {
                    String methodName;
                    PTGraphicObject g;
                    block8: {
                        block6: {
                            block9: {
                                block7: {
                                    if (e.getSource() != this.methodChoice || e.getStateChange() != 1 || this.objectNums == null) break block4;
                                    g = Animation.get().getGraphicObject(this.objectNums[0]);
                                    if (!g.operationRequiresSpecialSelector(methodName = (String)this.methodChoice.getSelectedItem())) break block5;
                                    if (this.selectedNodes != null) break block6;
                                    if (!(g instanceof PTPolyline)) break block7;
                                    this.selectedNodes = new boolean[((PTPolyline)g).getDifferentNodesCount()];
                                    break block8;
                                }
                                if (!(g instanceof PTPolygon)) break block9;
                                this.selectedNodes = new boolean[((PTPolygon)g).getNodeCount()];
                                break block8;
                            }
                            if (!(g instanceof PTBoxPointer)) break block8;
                            this.selectedNodes = new boolean[((PTBoxPointer)g).getPointerCount()];
                            break block8;
                        }
                        int j = 0;
                        while (j < this.selectedNodes.length) {
                            this.selectedNodes[j] = false;
                            ++j;
                        }
                    }
                    int firstPos = methodName.indexOf(32);
                    if (firstPos != -1) {
                        StringTokenizer stok = new StringTokenizer(methodName.substring(firstPos + 1));
                        while (stok.hasMoreTokens()) {
                            this.selectedNodes[Integer.parseInt((String)stok.nextToken()) - 1] = true;
                        }
                    }
                    if (this.nodeSelector != null) {
                        this.nodeSelector.close();
                    }
                    this.nodeSelector = new NodeSelector(this, this.selectedNodes, g.baseOperationName(methodName), g.enableMultiSelectionFor(methodName));
                }
                this.methodChoice.repaint();
                break block10;
            }
            super.itemStateChanged(e);
        }
    }

    public void setNewMethod(String methodName) {
        this.methodChoice.removeItemListener(this);
        this.methodChoice.addItem(methodName);
        this.methodChoice.setSelectedItem(methodName);
        this.methodChoice.addItemListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            if (this.apply()) {
                this.close();
            }
        } else if (e.getSource() == this.applyButton) {
            this.apply();
        } else if (e.getSource() == this.cancelButton) {
            this.close();
        }
    }

    protected String isOK() {
        String result = super.isOK();
        if (result != null) {
            return result;
        }
        this.pathOSB.checkObjects();
        int num = this.pathOSB.getObjectNum();
        if (num == 0) {
            return AnimalTranslator.translateMessage("MoveEditor.noPath");
        }
        PTGraphicObject go = MoveEditor.getGraphicObject(num);
        if (!(go instanceof MoveBase)) {
            return AnimalTranslator.translateMessage("MoveEditor.invalidPathType");
        }
        ((MoveBase)((Object)go)).useAsMoveBase();
        AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).setChanged();
        return null;
    }

    protected boolean apply() {
        Object currentMessage = this.methodChoice.getSelectedItem();
        String error = this.isOK();
        if (error != null) {
            return false;
        }
        this.methodChoice.removeItemListener(this);
        EditableObject a = this.getCurrentObject();
        if (a != null) {
            this.storeAttributesInto(a);
        }
        if (a instanceof Move && !Animation.get().containsAnimator((Move)a)) {
            Animation.get().insertAnimator((Move)a);
            AnimalMainWindow.getWindowCoordinator().getAnimationOverview(true).initList(true);
        } else {
            Animation.get().doChange();
            this.repaintNow();
        }
        if (a instanceof PTGraphicObject) {
            AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).setChanged();
        } else {
            Animation.get().doChange();
        }
        this.methodChoice.addItem(currentMessage);
        this.methodChoice.setSelectedItem(currentMessage);
        currentMessage = null;
        this.methodChoice.addItemListener(this);
        return true;
    }
}

