/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.others;

import gfgaa.gui.components.SPanel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public final class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = -8646539574006805794L;
    protected JProgressBar progress;
    protected Thread t;
    protected boolean ready = false;

    public ProgressDialog(Thread t, JFrame gui) {
        super((Frame)gui, true);
        this.t = t;
        this.setTitle("Progress");
        this.setSize(200, 150);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.setContentPane(new ProgressPanel());
    }

    public void close() {
        this.setVisible(false);
        if (this.t.isAlive()) {
            this.t.interrupt();
        }
    }

    public void run() {
        this.setVisible(true);
    }

    public void setProgress(int percent) {
        this.progress.setIndeterminate(false);
        this.progress.setValue(percent);
    }

    private final class ProgressPanel
    extends SPanel {
        private static final long serialVersionUID = 6273422310267699571L;
        private JButton cancel;
        private JLabel proLab1;
        private JLabel proLab2;

        public ProgressPanel() {
            this.setLayout(null);
            this.create();
        }

        private void create() {
            this.cancel = new JButton("Cancel");
            this.cancel.setBounds(50, 90, 100, 25);
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressDialog.this.close();
                }
            });
            this.add(this.cancel);
            this.proLab1 = new JLabel("* Operation in progress * ");
            this.proLab1.setFont(new Font("Serif", 1, 15));
            this.proLab1.setBounds(20, 5, 175, 25);
            this.add(this.proLab1);
            this.proLab2 = new JLabel("... Please wait ...");
            this.proLab2.setFont(new Font("Serif", 1, 15));
            this.proLab2.setBounds(20, 30, 105, 25);
            this.add(this.proLab2);
            ProgressDialog.this.progress = new JProgressBar();
            ProgressDialog.this.progress.setBounds(25, 60, 150, 15);
            ProgressDialog.this.progress.setIndeterminate(true);
            this.add(ProgressDialog.this.progress);
        }

        @Override
        public void refreshPanelComponents() {
            Dimension size = this.getSize();
            this.cancel.setLocation((size.width - 100) / 2, (size.height - 100) / 2 + 75);
            this.proLab1.setLocation((size.width - 175) / 2, 5);
            this.proLab2.setLocation((size.width - 105) / 2, 30);
            ProgressDialog.this.progress.setLocation((size.width - 150) / 2, 60);
        }

        @Override
        public void paint(Graphics g) {
            this.refreshPanelComponents();
            super.paint(g);
            if (!ProgressDialog.this.ready) {
                ProgressDialog.this.t.start();
                ProgressDialog.this.ready = true;
            }
        }
    }
}

