/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui.graphs;

import gfgaa.gui.graphs.AbstractEdge;
import gfgaa.gui.graphs.AbstractNode;
import gfgaa.gui.graphs.basic.Uppercorner;
import java.util.ArrayList;
import java.util.HashSet;

public abstract class AbstractGraph {
    public static final int GRAPHSIZE_BASIC = 18;
    public static final int GRAPHSIZE_BIPARTIT = 17;
    public static final int GRAPHSIZE_MANHATTAN = 18;
    public static final int GRAPHSIZE_NEGATIVE = 15;
    public static final int GRAPHSIZE_RESIDUAL = 17;
    public static final Integer GRAPHTYP_BASIC = new Integer(0);
    public static final Integer GRAPHTYP_BIPARTIT = new Integer(1);
    public static final Integer GRAPHTYP_MANHATTAN = new Integer(2);
    public static final Integer GRAPHTYP_NEGATIVE = new Integer(3);
    public static final Integer GRAPHTYP_RESIDUAL = new Integer(4);
    private int diameter = 40;
    private boolean directed;
    private HashSet<String> knownTags = new HashSet();
    private ArrayList<AbstractNode> nodes;
    private boolean weighted;
    private AbstractNode startNode;
    private AbstractNode targetNode;
    private Uppercorner ecke;

    public AbstractGraph(int size) {
        this.nodes = new ArrayList(size);
    }

    public abstract Integer getGraphTyp();

    public abstract int maxsize();

    public boolean isDirected() {
        return this.directed;
    }

    public boolean isWeighted() {
        return this.weighted;
    }

    public void setDirected(boolean directed) {
        this.directed = directed;
    }

    public void setWeighted(boolean weighted) {
        this.weighted = weighted;
    }

    public void setCorner(Uppercorner ecke) {
        this.ecke = ecke;
    }

    public Uppercorner getCorner() {
        return this.ecke;
    }

    public void addNode(AbstractNode node) {
        char cTag = node.getTag();
        if (!this.containsTag("" + cTag)) {
            this.addTag("" + node.getTag());
            node.setGraph(this);
            int anz = this.getNumberOfNodes();
            int i = 0;
            while (i < anz) {
                if (cTag < this.getNode(i).getTag()) {
                    this.nodes.add(i, node);
                    return;
                }
                ++i;
            }
            this.nodes.add(node);
        }
    }

    public AbstractNode getNode(char cTag) {
        int i = 0;
        while (i < this.nodes.size()) {
            AbstractNode node = this.getNode(i);
            if (node.getTag() == cTag) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public AbstractNode getNode(int pos) {
        if (pos > -1 && pos < this.nodes.size()) {
            return this.nodes.get(pos);
        }
        return null;
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public void removeNode(char cTag) {
        AbstractNode node = this.getNode(cTag);
        while (node.getNumberOfEdges() > 0) {
            this.removeEdge(node.getEdge(0));
        }
        while (node.getNumberOfAgainstEdges() > 0) {
            this.removeEdge(node.getAgainstEdge(0));
        }
        this.nodes.remove(node);
        this.removeTag("" + cTag);
    }

    public void removeEdge(AbstractEdge edge) {
        if (!edge.getSource().removeEdge(edge)) {
            System.out.println("Internal Error at graphen.removeEdge\n -> #1 " + edge.toString() + " can't be removed.\n");
        }
        if (!edge.getTarget().removeAgainstEdge(edge)) {
            System.out.println("Internal Error at graphen.removeEdge\n -> #2 " + edge.toString() + " can't be removed.\n");
        }
    }

    public void removeEdge(AbstractNode from, AbstractNode to) {
        AbstractEdge edge = from.getEdgeTo(to);
        if (edge == null) {
            System.out.println("Internal Error at graphen.removeEdge\n -> #5 Edge " + from.getTag() + " -> " + to.getTag() + " does not exist.\n");
            return;
        }
        if (!from.removeEdge(edge)) {
            System.out.println("Internal Error at graphen.removeEdge\n -> #3 " + edge.toString() + " can't be removed from" + " Node " + from.getTag() + "\n");
        }
        if (!to.removeAgainstEdge(edge)) {
            System.out.println("Internal Error at graphen.removeEdge\n -> #4 " + edge.toString() + " can't be removed from" + " Node " + to.getTag() + "\n");
        }
    }

    public int getDiameter() {
        return this.diameter;
    }

    public int getRadius() {
        return this.diameter / 2;
    }

    public void setDiameter(int diameter) {
        this.diameter = diameter;
    }

    public void addTag(String sTag) {
        this.knownTags.add(sTag);
    }

    public boolean containsTag(String sTag) {
        return this.knownTags.contains(sTag);
    }

    public void removeTag(String sTag) {
        this.knownTags.remove(sTag);
    }

    public char[] getNodeTagArray() {
        int anz = this.getNumberOfNodes();
        char[] tags = new char[anz];
        int i = 0;
        while (i < anz) {
            tags[i] = this.getNode(i).getTag();
            ++i;
        }
        return tags;
    }

    public void setStartNode(AbstractNode node) {
        this.startNode = node;
    }

    public AbstractNode getStartNode() {
        return this.startNode;
    }

    public void setTargetNode(AbstractNode node) {
        this.targetNode = node;
    }

    public AbstractNode getTargetNode() {
        return this.targetNode;
    }
}

