/*
 * Decompiled with CFR 0.152.
 */
package gfgaa.gui;

import gfgaa.gui.GraphAlgController;
import gfgaa.gui.GraphDrawer;
import gfgaa.gui.components.ColorChooserComboBox;
import gfgaa.gui.components.SComponent;
import gfgaa.gui.components.SPanel;
import gfgaa.gui.graphs.AbstractGraph;
import gfgaa.gui.others.LanguageInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;

public class ColorChooser
extends JDialog
implements LanguageInterface {
    private static final long serialVersionUID = 8380845671758741151L;
    public static final int COLOR_BACKGROUND = 0;
    public static final int COLOR_EDGE_ONE = 1;
    public static final int COLOR_EDGE_TWO = 2;
    public static final int COLOR_EDGE_WEIGHT = 3;
    public static final int COLOR_EDGE_TOP = 4;
    public static final int COLOR_NODE_BORDER = 5;
    public static final int COLOR_NODE_BACKGROUND = 6;
    public static final int COLOR_NODE_TAG = 7;
    public static final int COLOR_EDGE_FLOW = 8;
    public static final int COLOR_EDGE_CAP = 9;
    public static final int COLOR_EDGE_RTOP = 10;
    GraphAlgController mainclass;
    GraphDrawer drawer;
    Color[] colors;

    public ColorChooser(GraphAlgController mainclass) {
        super((Frame)mainclass.getGUI(), true);
        this.mainclass = mainclass;
        this.drawer = mainclass.getGraphDrawer();
        this.colors = (Color[])this.drawer.getColorSettings().clone();
        if (mainclass.getLanguageSettings() == 0) {
            this.setTitle("Farbeinstellungen");
        } else {
            this.setTitle("Color Settings");
        }
        this.setSize(330, 320);
        this.getContentPane().setLayout(null);
        this.setResizable(false);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getSize().width) / 2, (d.height - this.getSize().height) / 2);
        this.setContentPane(new ColorPanel());
    }

    void close() {
        this.setVisible(false);
        this.dispose();
    }

    private final class ColorPanel
    extends SPanel {
        private static final long serialVersionUID = 5475101644497374656L;
        ColorChooserComboBox[] chooser;
        private JLabel[] chooserLabel;
        private JButton apply;
        private JButton reset;
        private JButton exit;

        public ColorPanel() {
            this.setLayout(null);
            this.chooser = new ColorChooserComboBox[8];
            this.chooserLabel = new JLabel[8];
            String[][] text = new String[][]{{"Hintergrund", "Background"}, {"Kante I", "Edge I"}, {"Kante II", "Edge II"}, {"Gewicht", "Weight"}, {"Kantenspitze", "Edge Arrow"}, {"Rand der Knoten", "Node Borders"}, {"Knoten", "Node Background"}, {"Knoten Kennzeichnung", "Node Tag"}};
            int i = 0;
            while (i < 8) {
                this.createChooser(i, text[i], 10 + 30 * i);
                ++i;
            }
            this.add(this.createResetButton());
            this.add(this.createApplyButton());
            this.add(this.createReturnButton());
            this.setColorSelection();
            this.changeLanguageSettings(ColorChooser.this.mainclass.getLanguageSettings());
        }

        void setColorSelection() {
            int i = 0;
            while (i < this.chooser.length) {
                if (ColorChooser.this.mainclass.getGraphTyp() == AbstractGraph.GRAPHTYP_RESIDUAL) {
                    switch (i) {
                        case 1: {
                            this.chooser[i].setColorSelected(ColorChooser.this.colors[8]);
                            break;
                        }
                        case 2: {
                            this.chooser[i].setColorSelected(ColorChooser.this.colors[9]);
                            break;
                        }
                        case 4: {
                            this.chooser[i].setColorSelected(ColorChooser.this.colors[10]);
                            break;
                        }
                        default: {
                            this.chooser[i].setColorSelected(ColorChooser.this.colors[i]);
                            break;
                        }
                    }
                } else {
                    this.chooser[i].setColorSelected(ColorChooser.this.colors[i]);
                }
                ++i;
            }
        }

        private void createChooser(int nr, String[] chooserText, int pos) {
            this.chooserLabel[nr] = new JLabel();
            this.chooserLabel[nr].setFont(new Font("Serif", 1, 14));
            this.chooserLabel[nr].setBounds(10, pos, 150, 25);
            this.add(this.chooserLabel[nr]);
            this.add(new SComponent(this.chooserLabel[nr], chooserText));
            this.chooser[nr] = new ColorChooserComboBox();
            this.chooser[nr].setBounds(210, pos, 100, 25);
            this.add(this.chooser[nr]);
        }

        private JButton createApplyButton() {
            this.apply = new JButton();
            this.apply.setBounds(5, 260, 100, 25);
            this.add(new SComponent(this.apply, new String[]{"Anpassen", "Apply"}, new String[]{"Speichert die Farbeinstellungen.", "Saves the color settings."}));
            this.apply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color[] col = new Color[8];
                    int i = 0;
                    while (i < 8) {
                        if (((ColorPanel)ColorPanel.this).ColorChooser.this.mainclass.getGraphTyp() == AbstractGraph.GRAPHTYP_RESIDUAL) {
                            switch (i) {
                                case 1: {
                                    col[i] = ColorPanel.this.chooser[8].getColorSelected();
                                    break;
                                }
                                case 2: {
                                    col[i] = ColorPanel.this.chooser[9].getColorSelected();
                                    break;
                                }
                                case 4: {
                                    col[i] = ColorPanel.this.chooser[10].getColorSelected();
                                    break;
                                }
                                default: {
                                    col[i] = ColorPanel.this.chooser[i].getColorSelected();
                                    break;
                                }
                            }
                        } else {
                            col[i] = ColorPanel.this.chooser[i].getColorSelected();
                        }
                        ++i;
                    }
                    ((ColorPanel)ColorPanel.this).ColorChooser.this.drawer.setColorSettings(col);
                    ((ColorPanel)ColorPanel.this).ColorChooser.this.mainclass.repaint();
                }
            });
            return this.apply;
        }

        private JButton createResetButton() {
            this.reset = new JButton();
            this.reset.setBounds(110, 260, 100, 25);
            this.add(new SComponent(this.reset, new String[]{"Reset", "Reset"}, new String[]{"Stellt die Farbeinstellungen wieder her, die beim \u02c6ffnen des Fensters ausgew\u2030hlt waren.", "Reloads the color settings that was used when opening the dialog."}));
            this.reset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((ColorPanel)ColorPanel.this).ColorChooser.this.drawer.setColorSettings(((ColorPanel)ColorPanel.this).ColorChooser.this.colors);
                    ColorPanel.this.setColorSelection();
                    ((ColorPanel)ColorPanel.this).ColorChooser.this.mainclass.repaint();
                }
            });
            return this.reset;
        }

        private JButton createReturnButton() {
            this.exit = new JButton();
            this.exit.setBounds(215, 260, 100, 25);
            this.add(new SComponent(this.exit, new String[]{"Schlie\ufb02en", "Close"}, new String[]{"Schlie\ufb02t das Fenster.", "Closes the window."}));
            this.exit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorChooser.this.close();
                }
            });
            return this.exit;
        }

        @Override
        public void paint(Graphics g) {
            int[] pos;
            Dimension size = this.getSize();
            pos = new int[]{(size.width - 310) / 2, (size.width - 275) / 2, pos[1] + 175, (size.height - 275) / 2, pos[3] + 250};
            this.apply.setLocation(pos[0], pos[4]);
            this.reset.setLocation(pos[0] + 105, pos[4]);
            this.exit.setLocation(pos[0] + 210, pos[4]);
            int i = 0;
            while (i < 8) {
                this.chooserLabel[i].setLocation(pos[1], pos[3] + i * 30);
                this.chooser[i].setLocation(pos[2], pos[3] + i * 30);
                ++i;
            }
            super.paint(g);
        }

        @Override
        public void refreshPanelComponents() {
        }
    }
}

