/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.util.Coordinates;
import algoanim.util.TicksTiming;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class SwapSort2
implements Generator {
    protected Language lang;
    private ArrayProperties arrayProps;
    private ArrayMarkerProperties ami;
    private SourceCode sc;
    private static final String[] DESCRIPTION = new String[]{"        Die Idee von Swap-Sort ist, von jedem Element eines Arrays A(1..n) die Anzahl m", "der kleineren Werte (die in A sind) zu z\u221a\u00a7hlen und das Element dann mit dem Element", "in A( m+1 ) zu vertauschen. Somit ist sichergestellt, dass das ausgetauschte Element", "bereits an der richtigen, also endg\u221a\u00baltigen Stelle steht.", "        Nachteil dieses Algorithmus ist, dass jedes Element nur einmal vorkommen darf,", "da sonst keine Terminierung erfolgt."};

    public static void main(String[] args) {
        SwapSort2 SS = new SwapSort2();
        SS.init();
        int[] original = new int[]{7, 8, 5, 2, 4, 9, 3, 1};
        SS.swapSort(original);
        System.out.println(SS.lang.toString());
    }

    @Override
    public void init() {
        this.lang = new AnimalScript("Swap-Sort", "Lu,Zheng Yin,Yanan Yang,Yang", 640, 480);
        this.lang.setStepMode(true);
        this.lang.addLine("text \"des1\"\"" + DESCRIPTION[0] + " \"(20,35) color (0,0,0) depth 1 font SansSerif size 20 bold\n");
        this.lang.addLine("text \"des2\"\"" + DESCRIPTION[1] + " \"(20,70) color (0,0,0) depth 1 font SansSerif size 20 bold\n");
        this.lang.addLine("text \"des3\"\"" + DESCRIPTION[2] + " \"(20,105) color (0,0,0) depth 1 font SansSerif size 20 bold\n");
        this.lang.addLine("text \"des4\"\"" + DESCRIPTION[3] + " \"(20,140) color (0,0,0) depth 1 font SansSerif size 20 bold\n");
        this.lang.addLine("text \"des5\"\"" + DESCRIPTION[4] + " \"(20,175) color (0,0,0) depth 1 font SansSerif size 20 bold\n");
        this.lang.addLine("text \"des6\"\"" + DESCRIPTION[5] + " \"(20,210) color (0,0,0) depth 1 font SansSerif size 20 bold\n}\n");
        this.lang.addLine("{\nhideAll\n");
        this.arrayProps = new ArrayProperties();
        this.arrayProps.set("elementColor", Color.BLACK);
        this.arrayProps.set("filled", true);
        this.arrayProps.set("fillColor", Color.YELLOW);
        this.arrayProps.set("cellHighlight", Color.GREEN);
        this.arrayProps.set("elemHighlight", Color.RED);
        this.ami = new ArrayMarkerProperties();
        this.ami.set("color", Color.BLACK);
        this.ami.set("label", "i");
    }

    public void swapSort(int[] inputArray) {
        IntArray array = this.lang.newIntArray(new Coordinates(650, 100), inputArray, "array", null, this.arrayProps);
        TicksTiming defaultTiming = new TicksTiming(15);
        TicksTiming changeTiming = new TicksTiming(30);
        this.lang.addLine("text \"des7\" \"kleineren Werte: \" (600,150) color (0,0,0) depth 1 font SansSerif size 20 \n");
        this.lang.addLine("text \"des8\" \"Start Werte:\" (600,180) color (0,0,0) depth 1 font SansSerif size 20 \n");
        this.showSourceCode();
        this.sc.highlight(0);
        this.lang.nextStep();
        this.sc.toggleHighlight(0, 1);
        ArrayMarker i = this.lang.newArrayMarker(array, 0, "i", null, this.ami);
        this.lang.nextStep();
        this.sc.toggleHighlight(1, 2);
        i.move(0, null, defaultTiming);
        this.lang.nextStep();
        while (i.getPosition() < array.getLength() - 1) {
            int kleinere = this.countSmallerOnes(inputArray, i.getPosition());
            array.highlightElem(kleinere + i.getPosition(), null, defaultTiming);
            this.sc.unhighlight(2);
            this.sc.unhighlight(3);
            this.sc.unhighlight(5);
            this.sc.unhighlight(6);
            this.sc.unhighlight(7);
            this.sc.unhighlight(10);
            this.sc.highlight(3);
            this.sc.highlight(14);
            this.lang.addLine("hide \"des7\"");
            this.lang.addLine("hide \"des8\"");
            this.lang.addLine("text \"des7\" \"kleineren Werte: " + kleinere + "\" (600,150) color (0,0,0) depth 1 font SansSerif size 20 \n");
            this.lang.addLine("text \"des8\" \"Start Werte: " + i.getPosition() + "\" (600,180) color (0,0,0) depth 1 font SansSerif size 20 \n");
            this.lang.nextStep();
            this.sc.toggleHighlight(3, 4);
            this.sc.unhighlight(14);
            this.lang.nextStep();
            if (kleinere > 0) {
                this.sc.toggleHighlight(4, 5);
                this.sc.highlight(6);
                this.sc.highlight(7);
                array.unhighlightElem(kleinere + i.getPosition(), null, defaultTiming);
                array.swap(i.getPosition(), i.getPosition() + kleinere, null, changeTiming);
                this.lang.nextStep();
                continue;
            }
            this.sc.unhighlight(3);
            this.sc.unhighlight(4);
            this.sc.highlight(10);
            array.unhighlightElem(kleinere + i.getPosition(), null, defaultTiming);
            array.highlightCell(i.getPosition(), null, defaultTiming);
            i.move(i.getPosition() + 1, null, defaultTiming);
            this.lang.nextStep();
        }
        array.highlightCell(i.getPosition(), null, defaultTiming);
        this.lang.addLine("text \"des8\" \"Der Algorithmus ist fertig!\" (550,500) color (0,0,0) depth 1 font SansSerif size 22 bold\n");
    }

    private int countSmallerOnes(int[] countHere, int index) {
        int counter = 0;
        int i = index + 1;
        while (i < countHere.length) {
            if (countHere[index] > countHere[i]) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public void showSourceCode() {
        SourceCodeProperties scProps = new SourceCodeProperties();
        scProps.set("contextColor", Color.BLUE);
        scProps.set("font", new Font("Monospaced", 0, 18));
        scProps.set("highlightColor", Color.RED);
        scProps.set("color", Color.BLACK);
        this.sc = this.lang.newSourceCode(new Coordinates(40, 50), "sourceCode", null, scProps);
        this.sc.addCodeLine("public void sort(int[] sortMe) {", null, 0, null);
        this.sc.addCodeLine("int startwert = 0;", null, 1, null);
        this.sc.addCodeLine("while (startwert < sortMe.length - 1) {", null, 1, null);
        this.sc.addCodeLine("int kleinere = countSmallerOnes(sortMe, startwert);", null, 2, null);
        this.sc.addCodeLine("if (kleinere > 0) {", null, 2, null);
        this.sc.addCodeLine("int tmp = sortMe[startwert];", null, 3, null);
        this.sc.addCodeLine("sortMe[startwert] = sortMe[startwert + kleinere];", null, 3, null);
        this.sc.addCodeLine("sortMe[startwert + kleinere] = tmp;", null, 3, null);
        this.sc.addCodeLine("}", null, 2, null);
        this.sc.addCodeLine("else{", null, 2, null);
        this.sc.addCodeLine("startwert++;", null, 3, null);
        this.sc.addCodeLine("}", null, 2, null);
        this.sc.addCodeLine("}", null, 1, null);
        this.sc.addCodeLine("}", null, 0, null);
        this.sc.addCodeLine("private int countSmallerOnes(final int[] countHere, final int index) {", null, 0, null);
        this.sc.addCodeLine("int counter = 0;", null, 1, null);
        this.sc.addCodeLine("for (int i = index + 1; i < countHere.length; i++) {", null, 1, null);
        this.sc.addCodeLine("if (countHere[index] > countHere[i]) {", null, 2, null);
        this.sc.addCodeLine("counter++;", null, 3, null);
        this.sc.addCodeLine("}", null, 2, null);
        this.sc.addCodeLine("}", null, 1, null);
        this.sc.addCodeLine("return counter;", null, 1, null);
        this.sc.addCodeLine("}", null, 0, null);
    }

    @Override
    public String getCodeExample() {
        return "public class SwapSorter {\npublic void sort(int[] sortMe) {\nint startwert = 0;\nwhile (startwert < sortMe.length - 1) {\nint kleinere = countSmallerOnes(sortMe, startwert);\nif (kleinere > 0) {\nint tmp = sortMe[startwert];\nsortMe[startwert] = sortMe[startwert + kleinere];\nsortMe[startwert + kleinere] = tmp;\n}\nelse{\nstartwert++;\n}\n}\n}\nprivate int countSmallerOnes(final int[] countHere, final int index) {\nint counter = 0;\nfor (int i = index + 1; i < countHere.length; i++) {\nif (countHere[index] > countHere[i]) {\ncounter++;\n}\n}\nreturn counter;\n}";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getDescription() {
        return "Die Idee von Swap-Sort ist, von jedem Element eines Arrays A(1..n) die Anzahl m der kleineren Werte (die in A sind) zu z\u221a\u00a7hlen und das Element dann mit dem Element in A( m+1 ) zu vertauschen. Somit ist sichergestellt, dass das ausgetauschte Element bereits an der richtigen, also endg\u221a\u00baltigen Stelle steht.\n Nachteil dieses Algorithmus ist, dass jedes Element nur einmal vorkommen darf, da sonst keine Terminierung erfolgt.";
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "Swap Sort";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.init();
        int[] arrayData = (int[])primitives.get("array");
        this.arrayProps.set("color", props.get("array", "color"));
        this.swapSort(arrayData);
        return this.lang.toString();
    }

    @Override
    public String getAlgorithmName() {
        return "Swap Sort";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAnimationAuthor() {
        return "Zheng Lu, Yanan Yin, Yang Yang";
    }
}

