/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.animalscript.AnimalScript;
import algoanim.exceptions.LineNotExistsException;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.SourceCode;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class GnomeSortTUS
implements Generator {
    private Language lang;
    private static final String DESCRIPTION = "GnomeSort ist ein einfacher Sortier-Algorithmus.\n Als Beispiel stelle man sich einen Gartenzwerg (garden gnome) vor,\nwelcher vor Blument\u2202pfen steht, die unterschiedliche Gr\u2202\u00fcen haben d\u00barfen.\nDie Blument\u2202pfe sind in einer von links nach rechts verlaufenden\nReihe aufgestellt. Ganz links steht der Gartenzwerg und m\u2202chte die\nBlument\u2202pfe von links nach rechts der Gr\u2202\u00fce nach aufsteigend sortieren.\nDazu vergleicht er die beiden Blument\u2202pfe, vor denen er grade steht.\nStellt er fest, dass sie in der richtigen Reihenfolge sind, so macht\ner einen Schritt nach rechts. Stellt er hingegen fest, dass die Reihenfolge\nnicht stimmt, so vertauscht er die beiden Blument\u2202pfe und macht einen Schritt\nnach links. Dies wiederholt er st\u00a7ndig. Fertig ist er, wenn er am ganz rechts\nstehenden Blumentopf ankommt und feststellt, dass dieser in der richtigen\nReihenfolge steht.";
    private static final String SOURCE_CODE = "void gnomesort() {\n int i = 0;\n while (i < arraysize) {\n  if (i == 0  ||  Eintrag i-1 <= Eintrag i) {\n   i++\n  }\n  else {\n   Tausche Eintrag i-1 und i;\n   i--;\n   }\n  }\n }";

    public GnomeSortTUS() {
    }

    public GnomeSortTUS(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void sort(int[] a, AnimationPropertiesContainer aprops) {
        TextProperties txprops = new TextProperties();
        txprops.set("font", new Font("Monospaced", 0, 18));
        txprops.set("color", aprops.get("title", "color"));
        this.lang.newText(new Coordinates(100, 20), "GnomeSort", "title", null, txprops);
        this.lang.nextStep();
        SourceCodeProperties scProps = new SourceCodeProperties();
        scProps.set("contextColor", Color.BLUE);
        scProps.set("font", new Font("Monospaced", 0, 12));
        scProps.set("highlightColor", aprops.get("sourceCode", "highlightColor"));
        scProps.set("color", aprops.get("sourceCode", "color"));
        scProps.set("font", aprops.get("sourceCode", "font"));
        scProps.set("size", aprops.get("sourceCode", "size"));
        SourceCode sc = this.lang.newSourceCode(new Coordinates(40, 160), "sourceCode", null, scProps);
        sc.addCodeLine("void gnomesort() {", null, 0, null);
        sc.addCodeLine("int i = 0;", null, 1, null);
        sc.addCodeLine("while (i < arraylaenge) {", null, 1, null);
        sc.addCodeLine("if (i == 0  ||  Eintrag i-1 <= Eintrag i) {", null, 2, null);
        sc.addCodeLine("i++;", null, 3, null);
        sc.addCodeLine("}", null, 2, null);
        sc.addCodeLine("else {", null, 2, null);
        sc.addCodeLine("Tausche Eintrag i-1 und i;", null, 3, null);
        sc.addCodeLine("i--;", null, 3, null);
        sc.addCodeLine("}", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("}", null, 0, null);
        this.lang.nextStep();
        ArrayProperties arrayProps = new ArrayProperties();
        arrayProps.set("color", aprops.get("array", "color"));
        arrayProps.set("fillColor", aprops.get("array", "fillColor"));
        arrayProps.set("filled", aprops.get("array", "filled"));
        arrayProps.set("elementColor", aprops.get("array", "elementColor"));
        arrayProps.set("elemHighlight", aprops.get("array", "elemHighlight"));
        arrayProps.set("cellHighlight", aprops.get("array", "cellHighlight"));
        IntArray ia = this.lang.newIntArray(new Coordinates(20, 120), a, "intArray", null, arrayProps);
        this.lang.nextStep();
        try {
            this.gnomeSort(a.length, ia, sc);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
    }

    private void gnomeSort(int size, IntArray heap, SourceCode sc) throws LineNotExistsException {
        sc.highlight(0);
        this.lang.nextStep();
        sc.toggleHighlight(0, 1);
        ArrayMarkerProperties arrayJMProps = new ArrayMarkerProperties();
        arrayJMProps.set("label", "  i");
        arrayJMProps.set("color", Color.BLACK);
        ArrayMarker jMarker = this.lang.newArrayMarker(heap, 0, "i", null, arrayJMProps);
        int i = 0;
        this.lang.nextStep();
        sc.toggleHighlight(1, 2);
        while (i < size) {
            this.lang.nextStep();
            sc.toggleHighlight(2, 3);
            if (i == 0 || heap.getData(i - 1) <= heap.getData(i)) {
                this.lang.nextStep();
                sc.toggleHighlight(3, 4);
                if (++i < size) {
                    jMarker.move(i, null, null);
                }
                this.lang.nextStep();
                sc.toggleHighlight(4, 2);
                continue;
            }
            this.lang.nextStep();
            sc.toggleHighlight(3, 6);
            this.lang.nextStep();
            sc.toggleHighlight(6, 7);
            heap.highlightCell(i, null, null);
            heap.highlightCell(i - 1, null, null);
            this.lang.nextStep();
            int temp = heap.getData(i);
            heap.put(i, heap.getData(i - 1), null, null);
            heap.put(i - 1, temp, null, null);
            this.lang.nextStep();
            sc.toggleHighlight(7, 8);
            heap.unhighlightCell(i, null, null);
            heap.unhighlightCell(i - 1, null, null);
            jMarker.move(--i, null, null);
            this.lang.nextStep();
            sc.toggleHighlight(8, 2);
        }
        sc.toggleHighlight(2, 11);
    }

    public static void main(String[] args) {
    }

    @Override
    public String getAlgorithmName() {
        return "GnomeSort";
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMAN;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "GnomeSort";
    }

    @Override
    public String getOutputLanguage() {
        return "Pseudo-Code";
    }

    @Override
    public String generate(AnimationPropertiesContainer arg0, Hashtable<String, Object> arg1) {
        int[] myArray = (int[])arg1.get("array");
        this.lang = new AnimalScript("GnomeSort Animation", "hiuig", 640, 480);
        GnomeSortTUS s = new GnomeSortTUS(this.lang);
        this.lang.setStepMode(true);
        s.sort(myArray, arg0);
        return this.lang.toString();
    }

    @Override
    public String getAnimationAuthor() {
        return "Daniel Thies, Dominik Ulrich, J\u00f6rg Schmalfuss";
    }

    @Override
    public void init() {
    }
}

