/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.sorting;

import algoanim.primitives.ArrayMarker;
import algoanim.primitives.IntArray;
import algoanim.primitives.Text;
import algoanim.primitives.updater.ArrayMarkerUpdater;
import algoanim.primitives.updater.TextUpdater;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.util.Coordinates;
import algoanim.util.TicksTiming;
import algoanim.util.Timing;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.AnnotatedAlgorithm;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Locale;

public class AnnotatedBubbleSort
extends AnnotatedAlgorithm
implements Generator {
    private String comp = "Compares";
    private String assi = "Assignments";
    private int[] arrayData;
    private IntArray array = null;
    private ArrayMarker iMarker;
    private ArrayMarker jMarker;
    private Timing defaultTiming = new TicksTiming(100);
    private ArrayMarkerUpdater amuI;
    private ArrayMarkerUpdater amuJ;

    @Override
    public String getAnimationAuthor() {
        return "Sebastian Proksch <sproksch[at]rbg.informatik.tu-darmstadt.de>";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAnnotatedSrc() {
        return "int[] sort(int[] arr) {\t\t\t\t@label(\"header\")\n\tint i, j;\t\t\t\t\t\t@label(\"vars_marker\") @declare(\"int\", \"i\") @declare(\"int\", \"j\")\n\tboolean swapped = true;\t\t\t@label(\"vars_swapped\") @declare(\"int\", \"swapped\", \"1\") @inc(\"" + this.assi + "\")\n" + "\tfor(i = arr.length;\t\t\t\t@label(\"oForInit\") @inc(\"" + this.assi + "\")\n" + "swapped\t\t\t\t@label(\"oForComp1\") @continue @inc(\"" + this.comp + "\")\n" + "               && i > 0;\t\t\t@label(\"oForComp2\") @continue @inc(\"" + this.comp + "\")\n" + "                    i--) {\t\t@label(\"oForDec\") @continue @dec(\"i\") @inc(\"" + this.assi + "\")\n" + "\t\tswapped = false;\t\t\t@label(\"resetSwapped\") @set(\"swapped\", \"0\") @inc(\"" + this.assi + "\")\n" + "\t\tfor(j = 1;\t\t\t\t\t@label(\"iForInit\") @set(\"j\", \"1\") @inc(\"" + this.assi + "\")\n" + "       j<i;\t\t\t\t\t\t@label(\"iForComp\") @continue @inc(\"" + this.comp + "\")\n" + "         j++) {\t\t\t\t\t@label(\"iForInc\") @continue @inc(\"j\") @inc(\"" + this.assi + "\")\n" + "\t\t\tif(arr[j-1] > arr[j]) {\t@label(\"if\") @inc(\"" + this.comp + "\")\n" + "\t\t\t\tswap(arr, j-1, j);\t@label(\"swap\") @inc(\"" + this.assi + "\") @inc(\"" + this.assi + "\") @inc(\"" + this.assi + "\")\n" + "\t\t\t\tswapped = true;\t\t@label(\"setSwapped\") @set(\"swapped\", \"1\") @inc(\"" + this.assi + "\")\n" + "\t\t\t}\t\t\t\t\t\t@label(\"ifEnd\")\n" + "\t\t}\t\t\t\t\t\t\t@label(\"iForEnd\")\n" + "\t}\t\t\t\t\t\t\t\t@label(\"oForEnd\")\n" + "\treturn arr;\t\t\t\t\t\t@label(\"return\")\n" + "}\t\t\t\t\t\t\t\t@label(\"end\")\n";
    }

    @Override
    public void init() {
        super.init();
        SourceCodeProperties props = new SourceCodeProperties();
        props.set("highlightColor", Color.BLUE);
        props.set("bold", true);
        this.sourceCode = this.lang.newSourceCode(new Coordinates(20, 100), "sumupCode", null, props);
        ArrayProperties iap = new ArrayProperties();
        iap.set("fillColor", Color.WHITE);
        iap.set("cellHighlight", Color.LIGHT_GRAY);
        this.array = this.lang.newIntArray(new Coordinates(20, 70), this.arrayData, "array", null, iap);
        ArrayMarkerProperties ampI = new ArrayMarkerProperties();
        ampI.set("color", Color.RED);
        ampI.set("label", "i");
        this.iMarker = this.lang.newArrayMarker(this.array, 0, "iMarker", null, ampI);
        this.amuI = new ArrayMarkerUpdater(this.iMarker, null, this.defaultTiming, this.array.getLength() - 1);
        ArrayMarkerProperties ampJ = new ArrayMarkerProperties();
        ampJ.set("color", Color.BLUE);
        ampJ.set("label", "j");
        this.jMarker = this.lang.newArrayMarker(this.array, 0, "jMarker", null, ampJ);
        this.amuJ = new ArrayMarkerUpdater(this.jMarker, null, this.defaultTiming, this.array.getLength() - 1);
        this.vars.declare("int", this.comp);
        this.vars.setGlobal(this.comp);
        this.vars.declare("int", this.assi);
        this.vars.setGlobal(this.assi);
        Text text = this.lang.newText(new Coordinates(300, 20), "...", "complexity", null);
        TextUpdater tu = new TextUpdater(text);
        tu.addToken("Compares: ");
        tu.addToken(this.vars.getVariable(this.comp));
        tu.addToken(" - Assignments: ");
        tu.addToken(this.vars.getVariable(this.assi));
        tu.update();
        this.parse();
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.arrayData = (int[])primitives.get("Array Data");
        this.init();
        this.sort();
        return this.lang.toString();
    }

    private void sort() {
        this.exec("header");
        this.lang.nextStep();
        this.exec("vars_marker");
        this.amuI.setVariable(this.vars.getVariable("i"));
        this.amuJ.setVariable(this.vars.getVariable("j"));
        this.lang.nextStep();
        this.exec("vars_swapped");
        this.lang.nextStep();
        this.exec("oForInit");
        this.vars.set("i", String.valueOf(this.array.getLength()));
        this.lang.nextStep();
        this.exec("oForComp1");
        this.lang.nextStep();
        this.exec("oForComp2");
        this.lang.nextStep();
        if (Integer.parseInt(this.vars.get("i")) > 0) {
            while (!"0".equals(this.vars.get("swapped")) && Integer.parseInt(this.vars.get("i")) > 0) {
                this.exec("resetSwapped");
                this.lang.nextStep();
                this.exec("iForInit");
                this.lang.nextStep();
                this.exec("iForComp");
                this.lang.nextStep();
                while (Integer.parseInt(this.vars.get("j")) < Integer.parseInt(this.vars.get("i"))) {
                    this.exec("if");
                    this.lang.nextStep();
                    int j = Integer.parseInt(this.vars.get("j"));
                    if (this.array.getData(j - 1) > this.array.getData(j)) {
                        this.exec("swap");
                        this.array.swap(j - 1, j, null, this.defaultTiming);
                        this.lang.nextStep();
                        this.exec("setSwapped");
                        this.lang.nextStep();
                    }
                    this.exec("iForInc");
                    this.lang.nextStep();
                    this.exec("iForComp");
                    this.lang.nextStep();
                }
                this.exec("oForDec");
                this.array.highlightCell(Integer.parseInt(this.vars.get("i")), null, null);
                this.lang.nextStep();
                this.exec("oForComp1");
                this.lang.nextStep();
                if ("0".equals(this.vars.get("swapped"))) continue;
                this.exec("oForComp2");
                this.lang.nextStep();
            }
        }
        this.exec("return");
        int i = 0;
        while (i < this.array.getLength()) {
            this.array.highlightCell(i, null, null);
            ++i;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "BubbleSort";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public String getDescription() {
        return "This bubblesort implementation represents the third example for the usage of the new annotationsystem.";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(1);
    }

    @Override
    public String getName() {
        return "BubbleSort [annotation based]";
    }
}

