/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.searching;

import algorithm.animalTranslator.AnimalTranslator;
import algorithm.fileHandler.FileHandler;
import algorithm.stringSearch.KMPStringSearch;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.util.Hashtable;
import java.util.Locale;

public class KnuthMorrisPrattStringSearchWrapper
implements Generator {
    private static final String DESCRIPTION = "Im Unterschied zur direkten Brute-Force Suche eines Textes in einer Zeichenfolge versucht der Algorithmus von Knuth, Morris und Pratt, das Wissen \u00b8ber die bereits gelesenen Zeichen auszunutzen. Dazu wird zun\u2030chst f\u00b8r jedes m\u02c6gliche Eingabezeichen eine 'Verschiebetabelle' berechnet. Diese gibt f\u00b8r jedes Eingabezeichen an, wie die Suchmaske \u00b8ber den Text weiterzuschieben ist, wenn das gegebene Zeichen gefunden wird.";
    private static final String SOURCE_CODE = "fehlt noch.";
    private GeneratorType myType = new GeneratorType(2);

    @Override
    public GeneratorType getGeneratorType() {
        return this.myType;
    }

    @Override
    public String getName() {
        return "Knuth/Morris/Pratt-Suche in Strings";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String fullText = (String)primitives.get("text");
        String toSearch = (String)primitives.get("searchFor");
        FileHandler handler = new FileHandler("demo.asu");
        AnimalTranslator animalTrans = new AnimalTranslator(handler);
        KMPStringSearch kmpSearch = new KMPStringSearch(animalTrans);
        kmpSearch.initialize(fullText, toSearch);
        try {
            kmpSearch.generateAnimation();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return handler.getAnimationCode();
    }

    @Override
    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    @Override
    public String getAnimationAuthor() {
        return "Michael Maur";
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String getAlgorithmName() {
        return "Knuth-Morris-Pratch Searching";
    }

    @Override
    public void init() {
    }
}

