/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.searching;

import algoanim.primitives.ArrayMarker;
import algoanim.primitives.Text;
import algoanim.util.Offset;
import generator.Generator;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.searching.AbstractBinaryStringSearching;
import java.util.Hashtable;
import java.util.Locale;

public class GenericRecursiveBinaryStringSearching
extends AbstractBinaryStringSearching
implements Generator {
    protected Text lPos = null;
    protected Text rPos = null;
    ArrayMarker lMarker = null;
    ArrayMarker rMarker = null;
    ArrayMarker midMarker = null;

    public GenericRecursiveBinaryStringSearching(String aResourceName, Locale aLocale) {
        super(aResourceName, aLocale);
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.setUpDefaultElements(props, prims, "array", "code", "code", 0, 20);
        String valueToSearchFor = (String)prims.get("value");
        this.search(valueToSearchFor, 0, this.array.getLength() - 1);
        this.wrapUpAnimation();
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    protected int search(String valueToSearchFor, int lowerBound, int upperBound) {
        if (this.valueText == null) {
            this.valueText = this.installText("value", "value: " + valueToSearchFor, new Offset(30, 0, this.array, "SE"));
            this.lPos = this.installText("value", "l: " + lowerBound, new Offset(20, 0, this.valueText, "baseline end"));
            this.rPos = this.installText("value", "r: " + upperBound, new Offset(20, 0, this.lPos, "baseline end"));
            this.lMarker = this.installArrayMarker("lMarker", this.array, lowerBound);
            this.rMarker = this.installArrayMarker("rMarker", this.array, upperBound);
        } else {
            this.lPos.setText("l: " + lowerBound, null, DEFAULT_TIMING);
            this.rPos.setText("r: " + upperBound, null, DEFAULT_TIMING);
            this.lMarker.move(lowerBound, null, DEFAULT_TIMING);
            this.rMarker.move(upperBound, null, DEFAULT_TIMING);
        }
        if (lowerBound > 0) {
            this.array.unhighlightCell(0, lowerBound - 1, null, null);
        }
        if (upperBound < this.array.getLength() - 1) {
            this.array.unhighlightCell(upperBound + 1, this.array.getLength() - 1, null, null);
        }
        this.array.highlightCell(lowerBound, upperBound, null, null);
        this.code.highlight("header");
        this.lang.nextStep();
        this.code.toggleHighlight("header", "ifNull");
        this.incrementNrComparisons();
        this.lang.nextStep();
        if (valueToSearchFor == null) {
            this.code.unhighlight("ifNull");
            this.lang.nextStep();
            return -1;
        }
        this.code.toggleHighlight("ifNull", "invalidIndex");
        this.incrementNrComparisons(5);
        if (lowerBound > upperBound || lowerBound < 0 || upperBound >= this.array.getLength()) {
            this.lang.nextStep();
            this.code.toggleHighlight("invalidIndex", "invalidIndexReturn");
            this.result = this.installText("value", this.translator.translateMessage("result", new Integer[]{new Integer(-1)}), new Offset(20, 0, this.valueText, "baseline end"));
            this.lang.nextStep();
            this.code.unhighlight("invalidIndexReturn");
            return -1;
        }
        this.lang.nextStep();
        this.code.toggleHighlight("invalidIndex", "installMidMarker");
        if (this.midMarker == null) {
            this.midMarker = this.installArrayMarker("midMarker", this.array, (lowerBound + upperBound) / 2);
        } else {
            this.midMarker.move((lowerBound + upperBound) / 2, null, DEFAULT_TIMING);
        }
        this.incrementNrAssignments();
        this.array.highlightElem(this.midMarker.getPosition(), null, null);
        this.lang.nextStep();
        this.code.toggleHighlight("installMidMarker", "checkFound");
        this.incrementNrComparisons();
        if (valueToSearchFor.equals(this.array.getData(this.midMarker.getPosition()))) {
            this.lang.nextStep();
            this.code.toggleHighlight("checkFound", "found");
            this.result = this.installText("value", this.translator.translateMessage("result", new Integer[]{new Integer(this.midMarker.getPosition())}), new Offset(20, 0, this.rPos, "baseline end"));
            this.lang.nextStep();
            this.code.unhighlight("found");
            return this.midMarker.getPosition();
        }
        if (valueToSearchFor.compareTo(this.array.getData(this.midMarker.getPosition())) < 0) {
            this.code.toggleHighlight("checkFound", "ifLess");
            this.incrementNrComparisons();
            this.lang.nextStep();
            this.code.toggleHighlight("ifLess", "continueLeft");
            this.lang.nextStep();
            this.code.unhighlight("continueLeft");
            int resultingPosition = this.search(valueToSearchFor, lowerBound, this.midMarker.getPosition() - 1);
            this.code.highlight("continueLeft");
            if (lowerBound > 0) {
                this.array.unhighlightCell(0, lowerBound - 1, null, null);
            }
            if (upperBound < this.array.getLength() - 1) {
                this.array.unhighlightCell(upperBound + 1, null, null);
            }
            this.array.highlightCell(lowerBound, upperBound, null, null);
            this.lPos.setText("l: " + this.lMarker.getPosition(), null, null);
            this.rPos.setText("r: " + this.rMarker.getPosition(), null, null);
            this.lang.nextStep();
            return resultingPosition;
        }
        this.code.toggleHighlight("checkFound", "ifLess");
        this.incrementNrComparisons();
        this.lang.nextStep();
        this.code.toggleHighlight("ifLess", "continueRight");
        this.lang.nextStep();
        this.code.unhighlight("continueRight");
        int resultingPosition = this.search(valueToSearchFor, this.midMarker.getPosition() + 1, upperBound);
        this.code.highlight("continueRight");
        if (lowerBound > 0) {
            this.array.unhighlightCell(0, lowerBound - 1, null, null);
        }
        if (upperBound < this.array.getLength() - 1) {
            this.array.unhighlightCell(upperBound + 1, null, null);
        }
        this.array.highlightCell(lowerBound, upperBound, null, null);
        this.lPos.setText("l: " + this.lMarker.getPosition(), null, null);
        this.rPos.setText("r: " + this.rMarker.getPosition(), null, null);
        this.lang.nextStep();
        return resultingPosition;
    }

    @Override
    protected void hideNrStepsArrayCode() {
        super.hideNrStepsArrayCode();
        if (this.lPos != null) {
            this.lPos.hide();
        }
        if (this.rPos != null) {
            this.rPos.hide();
        }
    }
}

