/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.helpers;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.ArrayMarker;
import algoanim.primitives.ArrayPrimitive;
import algoanim.primitives.Primitive;
import algoanim.primitives.Rect;
import algoanim.primitives.SourceCode;
import algoanim.primitives.StringArray;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.AnimationProperties;
import algoanim.properties.ArrayMarkerProperties;
import algoanim.properties.ArrayProperties;
import algoanim.properties.GraphProperties;
import algoanim.properties.MatrixProperties;
import algoanim.properties.RectProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.properties.TextProperties;
import algoanim.util.Coordinates;
import algoanim.util.Hidden;
import algoanim.util.Node;
import algoanim.util.Offset;
import algoanim.util.TicksTiming;
import algoanim.util.Timing;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import translator.ResourceLocator;
import translator.Translator;

public abstract class AnimatedCompressionAlgorithm
implements Generator {
    public static final String CODE_LABEL = "@CodeLabel";
    protected static final Timing DEFAULT_TIMING = new TicksTiming(10);
    protected AnimationPropertiesContainer animationProperties;
    protected SourceCode code = null;
    protected SourceCode complexity = null;
    protected Locale contentLocale = null;
    protected SourceCode description = null;
    protected Text descriptionHeader = null;
    protected Text header = null;
    protected HashMap<String, Integer> labelsToLines;
    protected Language lang;
    protected GeneratorType localType = new GeneratorType(64);
    protected Rect nrAssBox = null;
    protected Text nrAssLabel = null;
    protected Rect nrCompBox = null;
    protected Text nrCompLabel = null;
    protected int nrAssignments = 0;
    protected int nrComparisons = 0;
    protected Text nrStepsText = null;
    protected Hashtable<String, AnimationProperties> primitiveProps;
    protected Hashtable<String, Object> primitives;
    protected String resourceName;
    protected Translator translator;
    protected ArrayPrimitive array;
    protected static MatrixProperties mp;
    protected static ArrayProperties ap;
    protected static ArrayMarkerProperties amp;
    protected static TextProperties tpsteps;
    protected static TextProperties tptopic;
    protected static TextProperties tpwords;
    protected static SourceCodeProperties scp;
    protected static GraphProperties gp;
    protected static RectProperties rctp;

    public AnimatedCompressionAlgorithm() {
    }

    public AnimatedCompressionAlgorithm(String resourceName, Locale locale) {
        this.translator = new Translator(resourceName, locale);
        this.contentLocale = locale;
        this.primitiveProps = new Hashtable(59);
    }

    @Override
    public void init() {
        mp = new MatrixProperties();
        mp.set("color", Color.BLACK);
        mp.set("fillColor", Color.WHITE);
        mp.set("elementColor", Color.BLACK);
        ap = new ArrayProperties();
        ap.set("color", Color.BLACK);
        ap.set("fillColor", Color.WHITE);
        ap.set("filled", Boolean.TRUE);
        ap.set("elementColor", Color.BLACK);
        ap.set("elemHighlight", Color.RED);
        ap.set("cellHighlight", Color.YELLOW);
        amp = new ArrayMarkerProperties();
        amp.set("label", "i");
        amp.set("color", Color.BLACK);
        tptopic = new TextProperties();
        tptopic.set("color", Color.RED);
        tptopic.set("font", new Font("Monospaced", 1, 32));
        tpsteps = new TextProperties();
        tpsteps.set("color", Color.BLACK);
        tpsteps.set("font", new Font("SansSerif", 0, 16));
        tpwords = new TextProperties();
        tpwords.set("font", new Font("Serif", 2, 22));
        tpwords.set("color", Color.BLACK);
        scp = new SourceCodeProperties();
        scp.set("contextColor", Color.RED);
        scp.set("font", new Font("Monospaced", 0, 12));
        scp.set("highlightColor", Color.RED);
        scp.set("color", Color.BLACK);
        gp = new GraphProperties();
        gp.set("directed", false);
        gp.set("weighted", true);
        gp.set("color", Color.BLACK);
        gp.set("highlightColor", Color.YELLOW);
        gp.set("fillColor", Color.WHITE);
        gp.set("edgeColor", Color.BLACK);
        gp.set("nodeColor", Color.BLACK);
        rctp = new RectProperties();
        rctp.set("color", Color.BLACK);
    }

    protected void setContentLocale(Locale locale) {
        this.contentLocale = locale;
    }

    @Override
    public String getAlgorithmName() {
        return this.translator.translateMessage("algorithm");
    }

    @Override
    public String getOutputLanguage() {
        String outputLanguage = this.translator.translateMessage("outputLanguage", null, false);
        if (outputLanguage != null && !outputLanguage.startsWith("Invalid")) {
            return outputLanguage;
        }
        return "Java";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return this.localType;
    }

    @Override
    public String getName() {
        return this.translator.translateMessage("algoName");
    }

    @Override
    public String getDescription() {
        return this.translator.translateMessage("algoDesc");
    }

    @Override
    public String getAnimationAuthor() {
        return this.translator.translateMessage("algoAuthor");
    }

    @Override
    public String getCodeExample() {
        return this.translator.translateMessageWithoutParameterExpansion("codeExample");
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    protected void setParameters(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.animationProperties = props;
        this.primitives = prims;
    }

    private void setUpAnimation(int width, int height) {
        this.lang = new AnimalScript(this.translator.translateMessage("animTitle"), this.translator.translateMessage("algoAuthor"), width, height);
        this.lang.setStepMode(true);
    }

    protected void setUpAnimation() {
        this.setUpAnimation(640, 480);
    }

    protected void createTitle() {
        boolean titleVisible;
        String message = this.translator.translateMessage("algoTitle");
        boolean bl = titleVisible = message != null;
        if (titleVisible) {
            this.header = this.installText("title", message, new Coordinates(20, 35));
            RectProperties rectProps = new RectProperties();
            rectProps.set("depth", this.animationProperties.get("headerRect", "depth"));
            rectProps.set("filled", this.animationProperties.get("headerRect", "filled"));
            rectProps.set("fillColor", (Color)this.animationProperties.get("headerRect", "fillColor"));
            this.lang.newRect(new Offset(-5, -5, this.header, "NW"), new Offset(5, 5, this.header, "SE"), "headerRect", null, rectProps);
            this.primitiveProps.put("headerRect", rectProps);
        }
    }

    protected void createAlgorithmDescription() {
        String message = this.translator.translateMessage("animDesc");
        if (message != null) {
            this.descriptionHeader = this.lang.newText(new Coordinates(20, 80), message, "descrHd", null, (TextProperties)this.primitiveProps.get("title"));
            this.description = this.installCodeBlock("description", "descr", new Offset(0, 30, this.descriptionHeader, "SW"));
            this.lang.nextStep();
        }
    }

    protected void createAnimationHeader() {
        this.createTitle();
        this.createAlgorithmDescription();
        if (this.descriptionHeader != null) {
            this.descriptionHeader.hide();
        }
        if (this.description != null) {
            this.description.hide();
        }
    }

    protected void createNrStepsDisplay() {
    }

    protected void createComplexityDisplay() {
        this.complexity = this.installCodeBlock("complexity", "complexity", new Offset(0, 30, this.header, "SW"));
        this.lang.nextStep();
        if (this.complexity != null) {
            this.complexity.hide();
        }
    }

    protected void wrapUpAnimation() {
        this.createNrStepsDisplay();
        this.hideNrStepsArrayCode();
        this.createComplexityDisplay();
        this.lang.newText(new Offset(0, 50, this.header, "SW"), this.translator.translateMessage("adForURL"), "adForURL", null, (TextProperties)this.primitiveProps.get("title"));
    }

    protected void hideNrStepsArrayCode() {
        if (this.nrStepsText != null) {
            this.nrStepsText.hide();
        }
        if (this.code != null) {
            this.code.hide();
        }
        if (this.array != null) {
            this.array.hide();
        }
        if (this.nrAssBox != null) {
            this.nrAssBox.hide();
        }
        if (this.nrAssLabel != null) {
            this.nrAssLabel.hide();
        }
        if (this.nrCompBox != null) {
            this.nrCompBox.hide();
        }
        if (this.nrCompLabel != null) {
            this.nrCompLabel.hide();
        }
    }

    protected void incrementNrAssignments() {
        this.incrementNrAssignments(1);
    }

    protected void incrementNrAssignments(int howMany) {
        this.nrAssignments += howMany;
        if (this.nrAssBox != null) {
            this.nrAssBox.moveBy("translate #2", howMany * 2, 0, null, null);
        }
    }

    protected void incrementNrComparisons() {
        this.incrementNrComparisons(1);
    }

    protected void incrementNrComparisons(int howMany) {
        this.nrComparisons += howMany;
        if (this.nrCompBox != null) {
            this.nrCompBox.moveBy("translate #2", howMany * 2, 0, null, null);
        }
    }

    protected StringArray installStringArray(String key) {
        String[] arrayData = (String[])this.primitives.get(key);
        ArrayProperties iap = new ArrayProperties();
        iap.set("color", this.animationProperties.get(key, "color"));
        iap.set("fillColor", this.animationProperties.get(key, "fillColor"));
        iap.set("filled", Boolean.TRUE);
        iap.set("elementColor", this.animationProperties.get(key, "elementColor"));
        iap.set("elemHighlight", this.animationProperties.get(key, "elemHighlight"));
        iap.set("cellHighlight", this.animationProperties.get(key, "cellHighlight"));
        StringArray stringArray = this.lang.newStringArray(new Coordinates(30, 150), arrayData, "array", null, iap);
        return stringArray;
    }

    protected ArrayMarker installArrayMarker(String key, ArrayPrimitive baseArray, int initialPosition) {
        ArrayMarkerProperties amp = new ArrayMarkerProperties();
        amp.set("color", this.animationProperties.get(key, "color"));
        amp.set("label", this.animationProperties.get(key, "label"));
        amp.set("depth", this.animationProperties.get(key, "depth"));
        amp.set("hidden", this.animationProperties.get(key, "hidden"));
        if (key.equals("iMarker")) {
            amp.set("short", true);
        }
        if (key.equals("jMarker")) {
            amp.set("long", true);
        }
        ArrayMarker aMarker = this.lang.newArrayMarker(baseArray, initialPosition, key, null, amp);
        return aMarker;
    }

    private void formatText(SourceCode sourceCode, String key) {
        int lineNo = -1;
        int indentationLevel = 0;
        String message = null;
        String filename = this.translator.translateMessage(String.valueOf(key) + ".filename");
        StringBuilder sb = new StringBuilder(32337);
        String indenter = this.translator.translateMessage(String.valueOf(key) + ".level");
        int spacesPerLevel = new Integer(indenter);
        String labelChar = this.translator.translateMessage(String.valueOf(key) + ".labelSymbol");
        String lineLabel = null;
        if (this.labelsToLines == null) {
            this.labelsToLines = new HashMap(47);
        }
        if (filename != null) {
            try {
                InputStream f = ResourceLocator.getResourceLocator().getResourceStream(filename);
                BufferedReader br = new BufferedReader(new InputStreamReader(f));
                while ((message = br.readLine()) != null) {
                    sb.append(message).append("\n");
                    ++lineNo;
                    indentationLevel = 0;
                    lineLabel = null;
                    while (indentationLevel < message.length() && message.charAt(indentationLevel) == ' ') {
                        ++indentationLevel;
                    }
                    int startPos = indentationLevel;
                    int endPos = message.indexOf(labelChar);
                    if (endPos != -1) {
                        lineLabel = message.substring(endPos + 1, message.length()).trim();
                    } else {
                        endPos = message.indexOf(CODE_LABEL);
                        if (endPos != -1) {
                            lineLabel = message.substring(endPos + CODE_LABEL.length() + 2, message.indexOf("\")", endPos));
                        } else {
                            endPos = message.length();
                        }
                    }
                    sourceCode.addCodeLine(message.substring(startPos, endPos).trim(), lineLabel, indentationLevel / spacesPerLevel, null);
                }
                f.close();
                br.close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    protected Text installText(String key, String message, Node location, TextProperties textProps) {
        boolean textHidden = (Boolean)this.animationProperties.get(key, "hidden");
        if (textHidden || message == null) {
            return null;
        }
        this.primitiveProps.put(key, textProps);
        Text aText = this.lang.newText(location, message, key, null, textProps);
        return aText;
    }

    protected Text installText(String key, String message, Node location) {
        TextProperties textProps = new TextProperties();
        textProps.set("color", (Color)this.animationProperties.get(key, "color"));
        textProps.set("centered", this.animationProperties.get(key, "centered"));
        Font userFont = (Font)this.animationProperties.get(key, "font");
        textProps.set("font", new Font(userFont.getFamily(), 1, 20));
        textProps.set("depth", this.animationProperties.get(key, "depth"));
        return this.installText(key, message, location, textProps);
    }

    protected SourceCode installCodeBlock(String key, String codeName, Node location) {
        boolean codeHidden = (Boolean)this.animationProperties.get(key, "hidden");
        SourceCodeProperties codeProps = new SourceCodeProperties();
        codeProps.set("color", (Color)this.animationProperties.get(key, "color"));
        codeProps.set("highlightColor", (Color)this.animationProperties.get(key, "highlightColor"));
        Font userFont = (Font)this.animationProperties.get(key, "font");
        int fontProps = 0;
        if (this.animationProperties.get(key, "bold") == Boolean.TRUE) {
            ++fontProps;
        }
        if (this.animationProperties.get(key, "italic") == Boolean.TRUE) {
            fontProps += 2;
        }
        codeProps.set("font", new Font(userFont.getFamily(), fontProps, 16));
        codeProps.set("depth", 3);
        Hidden display = null;
        if (codeHidden) {
            display = new Hidden();
        }
        codeProps.set("hidden", new Boolean(codeHidden));
        SourceCode aCode = this.lang.newSourceCode(location, codeName, display, codeProps);
        this.formatText(aCode, key);
        return aCode;
    }

    public abstract Primitive installAdditionalComponents(String var1, String var2, String var3, int var4, int var5);

    protected void setUpDefaultElements(AnimationPropertiesContainer props, Hashtable<String, Object> prims, String arrayKey, String codeKey, String codeName, int dx, int dy) {
        this.setParameters(props, prims);
        this.setUpAnimation();
        this.createAnimationHeader();
        this.installAdditionalComponents(arrayKey, codeKey, codeName, dx, dy);
        this.nrComparisons = 0;
        this.nrAssignments = 0;
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> prims) {
        this.setUpDefaultElements(props, prims, "intArray", "code", "code", 0, 20);
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }
}

