/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations.graph;

import algoanim.animalscript.AnimalScript;
import algoanim.primitives.Graph;
import algoanim.primitives.IntMatrix;
import algoanim.primitives.Point;
import algoanim.primitives.Primitive;
import algoanim.primitives.SourceCode;
import algoanim.primitives.Text;
import algoanim.primitives.generators.Language;
import algoanim.properties.GraphProperties;
import algoanim.properties.MatrixProperties;
import algoanim.properties.PointProperties;
import algoanim.properties.SourceCodeProperties;
import algoanim.util.Coordinates;
import algoanim.util.MsTiming;
import algoanim.util.Node;
import algoanim.util.Offset;
import algoanim.util.Timing;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Locale;

public class Warshall
implements Generator {
    private static final String DESCRIPTION = "Takes a given graph in form of an adjacencymatrix and calculates the corresponding reachability graph. In an outer loop every nodeis considered as a transitnode. Then in a first inner loop each possible source node is used to add all paths which go trough the transitnode to another node (which is done in the inner most loop). When all possible transitnodes are processed the reachability graph is completed.";
    private static final String SOURCE_CODE = "public void warshall(int[][]a) {\n  for(int k=0; k<a.length; k++) {\n    for(int i= 0; i<a.length; i++) {\n      if(a[i][k]==1){\n        for(int j=0; j<a.length; j++){\n          if(a[k][j]==1) {\n            a[i][j]=1 }\n        }\n      }\n    }\n  }\n}";
    private static final String AUTHOR = "Patrick Fongue, Matthias Prager, Daniel Staesche";
    private static final String ALGORITHM_NAME = "Warshall";
    private Language lang;
    private final int spacing_distance = 70;
    private final int rowspacing = 30;
    private static final int[][] standardmatrix;
    private String[] alphabet = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private final int upperleftOffsetX = 10;
    private final int upperleftOffsetY = 30;
    private Coordinates upperLeftIntMatrix;
    private GraphProperties graphProperties;
    private MatrixProperties adjMatrixProperties;
    final Timing ifDuration = new MsTiming(1500);
    private IntMatrix animalIntMatrix;
    private Graph animalGraph;
    private SourceCode animalSourceCode;
    private Text animalTextK;
    private Text animalTextJ;
    private Text animalTextI;
    private Text animalTextTransit;
    private Text animalTextSource;
    private Text animalTextTarget;

    static {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[2] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[3] = 1;
        nArrayArray[2] = nArray3;
        nArrayArray[3] = new int[4];
        standardmatrix = nArrayArray;
    }

    @Override
    public void init() {
        this.lang = new AnimalScript(this.getName(), this.getAnimationAuthor(), 620, 480);
        this.lang.setStepMode(true);
        this.lang.newText(new Coordinates(0, 0), this.getName(), "AlgoTitle", null);
        this.adjMatrixProperties = new MatrixProperties();
        this.adjMatrixProperties.set("fillColor", Color.WHITE);
        this.adjMatrixProperties.set("elemHighlight", Color.RED);
        this.adjMatrixProperties.set("elementColor", Color.BLACK);
        this.upperLeftIntMatrix = new Coordinates(10, 30);
        this.graphProperties = new GraphProperties();
        this.graphProperties.set("color", Color.BLACK);
        this.graphProperties.set("fillColor", Color.WHITE);
        this.graphProperties.set("edgeColor", Color.BLACK);
        this.graphProperties.set("elemHighlight", Color.RED);
        this.graphProperties.set("highlightColor", Color.GREEN);
        this.graphProperties.set("directed", true);
    }

    private void placeNodes(Node[] nodes, Primitive reference, int distanceToTop, int radialfactor, String direction) {
        int y;
        int radial_stretch = 10;
        int dim = nodes.length;
        int r = 10 * dim;
        double stepwidth = Math.PI * 2 / (double)dim;
        double angle = 0.0;
        int x = y = r;
        int i = 0;
        while (i < dim) {
            int dx = (int)((double)r * Math.cos(angle));
            int dy = (int)((double)r * Math.sin(angle));
            nodes[i] = new Offset(70 + radialfactor * x + dx, distanceToTop + y + dy, reference, direction);
            angle += stepwidth;
            ++i;
        }
    }

    private SourceCode initSourceCode(SourceCodeProperties scProps, Primitive reference) {
        scProps.set("contextColor", Color.BLUE);
        scProps.set("font", new Font("Monospaced", 0, 12));
        scProps.set("highlightColor", Color.RED);
        scProps.set("color", Color.BLACK);
        SourceCode sc = this.lang.newSourceCode(new Offset(70, 0, reference, "NE"), "sourceCode", null, scProps);
        sc.addCodeLine("public void warshall(int[][]a) {", null, 0, null);
        sc.addCodeLine("for(int k=0; k<a.length; k++) {", null, 1, null);
        sc.addCodeLine("for(int i= 0; i<a.length; i++) {", null, 2, null);
        sc.addCodeLine("if(a[i][k]==1){", null, 3, null);
        sc.addCodeLine("for(int j=0; j<a.length; j++){", null, 4, null);
        sc.addCodeLine("if(a[k][j]==1) {", null, 5, null);
        sc.addCodeLine("a[i][j]=1 }", null, 6, null);
        sc.addCodeLine("}", null, 4, null);
        sc.addCodeLine("}", null, 3, null);
        sc.addCodeLine("}", null, 2, null);
        sc.addCodeLine("}", null, 1, null);
        sc.addCodeLine("}", null, 0, null);
        return sc;
    }

    private void initOnScreenVariables(SourceCode sc) {
        int columnspacing = 100;
        this.lang.newText(new Offset(70, 0, sc, "NE"), "sourcenode =".toUpperCase(), "sourceLabel", null);
        this.lang.newText(new Offset(70, 30, sc, "NE"), "transitnode =".toUpperCase(), "transitLabel", null);
        this.lang.newText(new Offset(70, 60, sc, "NE"), "targetnode =".toUpperCase(), "targetLabel", null);
        this.animalTextSource = this.lang.newText(new Offset(70 + columnspacing, 0, sc, "NE"), "", "source", null);
        this.animalTextTransit = this.lang.newText(new Offset(70 + columnspacing, 30, sc, "NE"), "", "transit", null);
        this.animalTextTarget = this.lang.newText(new Offset(70 + columnspacing, 60, sc, "NE"), "", "target", null);
        columnspacing = 30;
        this.lang.newText(new Offset(70, 120, sc, "NE"), "K =", "textkLabel", null);
        this.lang.newText(new Offset(70, 150, sc, "NE"), "J =", "textjLabel", null);
        this.lang.newText(new Offset(70, 180, sc, "NE"), "I =", "textiLabel", null);
        this.animalTextK = this.lang.newText(new Offset(70 + columnspacing, 120, sc, "NE"), "", "textk", null);
        this.animalTextJ = this.lang.newText(new Offset(70 + columnspacing, 150, sc, "NE"), "", "textj", null);
        this.animalTextI = this.lang.newText(new Offset(70 + columnspacing, 180, sc, "NE"), "", "texti", null);
    }

    private void updateVariablesOuterLoop(int transitnode, int lastNode) {
        this.animalTextK.setText(Integer.toString(transitnode), null, null);
        if (transitnode > 0) {
            this.animalIntMatrix.unhighlightCellColumnRange(transitnode - 1, 0, lastNode, null, null);
            this.animalIntMatrix.unhighlightCellRowRange(0, lastNode, transitnode - 1, null, null);
        }
        this.animalTextTransit.setText(this.animalGraph.getNodeLabel(transitnode), null, null);
    }

    private void highlightMatrixCross(int transitnode, int lastNode) {
        this.animalIntMatrix.highlightCellColumnRange(transitnode, 0, lastNode, null, null);
        this.animalIntMatrix.highlightCellRowRange(0, lastNode, transitnode, null, null);
    }

    private void updateVariablesMiddleLoop(int sourcenode) {
        this.animalTextI.setText(Integer.toString(sourcenode).toUpperCase(), null, null);
        this.animalTextSource.setText(this.animalGraph.getNodeLabel(sourcenode), null, null);
    }

    private void updateVariablesInnerLoop(int targetnode) {
        this.animalTextJ.setText(Integer.toString(targetnode).toUpperCase(), null, null);
        this.animalTextTarget.setText(this.animalGraph.getNodeLabel(targetnode), null, null);
    }

    private void highlightSourceCodeOuterLoop() {
        this.animalSourceCode.highlight(1);
        this.lang.nextStep();
        this.animalSourceCode.unhighlight(1);
    }

    private void highlightSourceCodeMiddleLoop() {
        this.animalSourceCode.highlight(2);
        this.lang.nextStep();
        this.animalSourceCode.unhighlight(2);
        this.animalSourceCode.highlight(3);
        this.lang.nextStep(this.ifDuration.getDelay());
    }

    private void highlightInnerLoop(int sourcenode, int transitnode) {
        this.animalGraph.highlightNode(sourcenode, null, null);
        this.lang.nextStep();
        this.animalGraph.highlightNode(transitnode, null, null);
        this.animalGraph.highlightEdge(sourcenode, transitnode, null, null);
        this.lang.nextStep();
        this.animalSourceCode.unhighlight(3);
    }

    private void highlightSourceCodeInnerLoop() {
        this.animalSourceCode.highlight(4);
        this.lang.nextStep();
        this.animalSourceCode.unhighlight(4);
        this.animalSourceCode.highlight(5);
        this.lang.nextStep(this.ifDuration.getDelay());
    }

    private String[] createLabels(int n) {
        String[] result = new String[n];
        int rounds = n / 26 + 1;
        int zeros = (int)Math.log10(rounds);
        int i = 0;
        while (i < rounds) {
            if ((i + 1) % 11 == 0) {
                --zeros;
            }
            int iletter = 0;
            while (iletter < 26 && iletter + i * 26 < n) {
                result[iletter + i * 26] = this.alphabet[iletter];
                int j = 0;
                while (j < zeros) {
                    result[iletter + i * 26] = String.valueOf(result[iletter + i * 26]) + "0";
                    ++j;
                }
                if (n > 26) {
                    result[iletter + i * 26] = String.valueOf(result[iletter + i * 26]) + i;
                }
                ++iletter;
            }
            ++i;
        }
        return result;
    }

    private boolean isReachable(int from, int to) {
        return this.animalIntMatrix.getElement(from, to) == 1;
    }

    private void highlightChange(int i, int j, int k) {
        this.animalGraph.highlightNode(k, null, null);
        this.animalGraph.highlightEdge(j, k, null, null);
        this.animalIntMatrix.highlightElem(i, k, null, null);
    }

    private void highlightSCUpdate() {
        this.animalSourceCode.unhighlight(5);
        this.animalSourceCode.highlight(6);
        this.lang.nextStep();
    }

    private void updateGraphAndMatrix(int sourcenode, int transitnode, int targetnode) {
        this.animalGraph.setEdgeWeight(sourcenode, targetnode, "", null, null);
        this.lang.nextStep();
        this.animalIntMatrix.put(sourcenode, targetnode, 1, null, null);
        this.lang.nextStep();
        this.animalIntMatrix.highlightElem(sourcenode, targetnode, null, null);
        this.animalGraph.unhighlightEdge(transitnode, targetnode, null, null);
        this.animalGraph.unhighlightNode(targetnode, null, null);
        this.animalSourceCode.unhighlight(6);
    }

    private void resetForNextLoop(int sourcenode, int transitnode) {
        this.animalTextJ.setText("", null, null);
        this.animalTextTarget.setText("", null, null);
        this.animalGraph.unhighlightNode(sourcenode, null, null);
        this.animalGraph.unhighlightEdge(sourcenode, transitnode, null, null);
        this.animalGraph.unhighlightNode(transitnode, null, null);
    }

    public void warshall(int[][] adjacencyMatrix) {
        int dim = adjacencyMatrix.length;
        this.animalIntMatrix = this.lang.newIntMatrix(this.upperLeftIntMatrix, adjacencyMatrix, "Erreichbarkeitsmatrix", null, this.adjMatrixProperties);
        int extra_space = 0;
        if (dim < 8) {
            extra_space = 30 * (8 - dim);
        }
        Node[] animalNodes = new Node[dim];
        this.placeNodes(animalNodes, this.animalIntMatrix, 70 + extra_space, 1, "SW");
        String[] labels = this.createLabels(dim);
        this.animalGraph = this.lang.newGraph("AnimierterGraph", adjacencyMatrix, animalNodes, labels, null, this.graphProperties);
        Point animalPointG1 = this.lang.newPoint(animalNodes[dim - 1], "g1_position", null, new PointProperties());
        Node[] animalResultNodes = new Node[dim];
        this.placeNodes(animalResultNodes, animalPointG1, 0, 2, "NE");
        this.lang.newGraph("Ursprungsgraph", adjacencyMatrix, animalResultNodes, labels, null, this.graphProperties);
        SourceCodeProperties scProps = new SourceCodeProperties();
        this.animalSourceCode = this.initSourceCode(scProps, this.animalIntMatrix);
        this.animalSourceCode.highlight(0);
        this.lang.nextStep();
        this.initOnScreenVariables(this.animalSourceCode);
        this.lang.nextStep();
        int lastNode = dim - 1;
        this.animalSourceCode.unhighlight(0);
        int transitnode = 0;
        while (transitnode < dim) {
            this.updateVariablesOuterLoop(transitnode, lastNode);
            this.highlightMatrixCross(transitnode, lastNode);
            this.highlightSourceCodeOuterLoop();
            int sourcenode = 0;
            while (sourcenode < dim) {
                this.updateVariablesMiddleLoop(sourcenode);
                this.highlightSourceCodeMiddleLoop();
                if (this.isReachable(sourcenode, transitnode)) {
                    this.highlightInnerLoop(sourcenode, transitnode);
                    int targetnode = 0;
                    while (targetnode < dim) {
                        this.updateVariablesInnerLoop(targetnode);
                        this.highlightSourceCodeInnerLoop();
                        if (this.isReachable(transitnode, targetnode)) {
                            this.highlightChange(sourcenode, transitnode, targetnode);
                            this.highlightSCUpdate();
                            this.updateGraphAndMatrix(sourcenode, transitnode, targetnode);
                        } else {
                            this.animalSourceCode.unhighlight(5);
                        }
                        ++targetnode;
                    }
                    this.resetForNextLoop(sourcenode, transitnode);
                } else {
                    this.animalSourceCode.unhighlight(4);
                    this.animalSourceCode.unhighlight(3);
                    this.animalTextSource.setText("", null, null);
                }
                this.animalSourceCode.unhighlight(2);
                ++sourcenode;
            }
            this.animalTextI.setText("", null, null);
            this.animalTextK.setText("", null, null);
            this.animalTextTransit.setText("", null, null);
            ++transitnode;
        }
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    @Override
    public String getName() {
        return String.valueOf(this.getAlgorithmName()) + " algorithm";
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getFileExtension() {
        return ".asu";
    }

    @Override
    public Locale getContentLocale() {
        return Locale.US;
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(8);
    }

    @Override
    public String getAlgorithmName() {
        return ALGORITHM_NAME;
    }

    @Override
    public String getAnimationAuthor() {
        return AUTHOR;
    }

    @Override
    public String getOutputLanguage() {
        return "Java";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.init();
        int[][] mat = Warshall.parseMatrix((String)primitives.get("adjacencymatrix"));
        this.warshall(mat);
        return this.lang.toString();
    }

    private static int[][] parseMatrix(String input) {
        String[] lines = input.split(";");
        int n = lines.length;
        lines[0] = lines[0].trim();
        lines[n - 1] = lines[n - 1].trim();
        if (lines[0].charAt(0) == '[') {
            if (lines[n - 1].charAt(lines[n - 1].length() - 1) == ']') {
                lines[0] = lines[0].substring(1);
                lines[n - 1] = lines[n - 1].substring(0, lines[n - 1].length() - 1);
            } else {
                System.err.println("Syntax error: Closing paranthesis for input matrix expected.");
                return standardmatrix;
            }
        }
        int[][] result = new int[n][n];
        int i = 0;
        String[] stringArray = lines;
        int n2 = lines.length;
        int n3 = 0;
        while (n3 < n2) {
            String line = stringArray[n3];
            String[] elemente = (line = line.trim()).split(",");
            if (elemente.length != n) {
                System.err.println("Syntax error: Input matrix must be symmetric.");
                return standardmatrix;
            }
            int j = 0;
            while (j < n) {
                try {
                    result[i][j] = Integer.parseInt(elemente[j].trim());
                    if (result[i][j] != 0 && result[i][j] != 1) {
                        System.err.println("Syntax error: Values for input matrix must be 0 or 1.");
                        return standardmatrix;
                    }
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Syntax error: Number expected for input matrix.");
                    return standardmatrix;
                }
                ++j;
            }
            ++i;
            ++n3;
        }
        return result;
    }

    public static void main(String[] args) {
        Warshall s = new Warshall();
        String inputmatrix = "[0,0,1,0; 1,0,0,0; 0,0,0,1; 0,0,0,0]";
        int[][] w = Warshall.parseMatrix(inputmatrix);
        s.init();
        s.warshall(w);
        System.out.println(s.lang);
    }
}

