/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.IntegerTextFieldEx;
import components.MatrixInputTable;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MatrixInputPanel
extends JPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 3257289145079313976L;
    public IntegerTextFieldEx txtNumberOfRows;
    public IntegerTextFieldEx txtNumberOfColumns;
    public MatrixInputTable tblElements;
    public static final int[][] DEFAULT_INT_ARRAY = new int[][]{{1, 2, 3, 4}, {5, 6, 7, 8}};
    public static final String[][] DEFAULT_STRING_ARRAY = new String[][]{{"A", "B", "C", "D"}, {"E", "F", "G", "H"}};

    public MatrixInputPanel() {
        int[][] values = DEFAULT_INT_ARRAY;
        this.init(values);
    }

    public MatrixInputPanel(int[][] values) {
        if (values == null || values.length == 0) {
            int[][] elems = DEFAULT_INT_ARRAY;
            this.init(elems);
        } else {
            int[][] elems = this.copyMatrix(values);
            this.init(elems);
        }
    }

    private int[][] copyMatrix(int[][] input) {
        Object result = null;
        if (input == null) {
            return this.copyMatrix(DEFAULT_INT_ARRAY);
        }
        int nrCols = input.length;
        int colLength = 0;
        result = new int[nrCols][];
        int i = 0;
        while (i < nrCols) {
            if (input[i] == null) {
                result[i] = new int[0];
            } else {
                colLength = input[i].length;
                result[i] = new int[colLength];
                System.arraycopy(input[i], 0, result[i], 0, colLength);
            }
            ++i;
        }
        return result;
    }

    public MatrixInputPanel(String[][] values) {
        if (values == null || values.length == 0) {
            String[][] elems = DEFAULT_STRING_ARRAY;
            this.init(elems);
        } else {
            String[][] elems = this.copyMatrix(values);
            this.init(elems);
        }
    }

    private String[][] copyMatrix(String[][] input) {
        String[][] result = null;
        if (input == null) {
            return this.copyMatrix(DEFAULT_STRING_ARRAY);
        }
        int nrCols = input.length;
        int colLength = 0;
        result = new String[nrCols][];
        int i = 0;
        while (i < nrCols) {
            if (input[i] == null) {
                result[i] = new String[0];
            } else {
                colLength = input[i].length;
                result[i] = new String[colLength];
                System.arraycopy(input[i], 0, result[i], 0, colLength);
            }
            ++i;
        }
        return result;
    }

    private void init(int[][] elements) {
        this.commonInit(elements.length);
        this.tblElements = new MatrixInputTable(elements);
        this.finishCommonInit();
    }

    private void commonInit(int defaultSize) {
        this.setLayout(new BoxLayout(this, 3));
        this.txtNumberOfRows = new IntegerTextFieldEx(1, 128);
        this.txtNumberOfRows.setDefaultValue(new Integer(8));
        this.txtNumberOfRows.setText(Integer.toString(defaultSize));
        this.txtNumberOfRows.addActionListener(this);
        this.txtNumberOfRows.addFocusListener(this);
        this.txtNumberOfRows.setAlignmentX(0.0f);
        this.txtNumberOfColumns = new IntegerTextFieldEx(1, 128);
        this.txtNumberOfColumns.setDefaultValue(new Integer(8));
        this.txtNumberOfColumns.setText(Integer.toString(defaultSize));
        this.txtNumberOfColumns.addActionListener(this);
        this.txtNumberOfColumns.addFocusListener(this);
        this.txtNumberOfColumns.setAlignmentX(0.0f);
    }

    private void finishCommonInit() {
        this.tblElements.setAlignmentX(0.0f);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        p.add(new JLabel("Number of rows:"));
        p.add(Box.createRigidArea(new Dimension(10, 1)));
        p.add(this.txtNumberOfRows);
        p.setAlignmentX(0.0f);
        p.add(new JLabel("Number of columns:"));
        p.add(Box.createRigidArea(new Dimension(10, 1)));
        p.add(this.txtNumberOfColumns);
        p.setAlignmentX(0.0f);
        this.add(p);
        this.add(Box.createRigidArea(new Dimension(1, 8)));
        this.add(Box.createRigidArea(new Dimension(1, 2)));
        this.add(this.tblElements);
    }

    private void init(String[][] elements) {
        this.commonInit(elements.length);
        this.tblElements = new MatrixInputTable(elements);
        this.finishCommonInit();
    }

    private void updateTable() {
        this.tblElements.setNumberOfRows(this.txtNumberOfRows.getValue());
        this.tblElements.setNumberOfColumns(this.txtNumberOfColumns.getValue());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        this.updateTable();
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e == null) {
            return;
        }
        this.updateTable();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e == null) {
            return;
        }
    }
}

