/*
 * Decompiled with CFR 0.152.
 */
package components;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class FontChooserComboBox
extends JComboBox
implements ActionListener {
    private static final long serialVersionUID = 1252859137529793065L;
    private static final String[] strFontStyles = new String[]{"Serif", "SansSerif", "Monospaced"};
    private FontChooserComboBoxRenderer renderer = new FontChooserComboBoxRenderer();
    private String strSelected = "Serif";
    private Object[][] values = new Object[strFontStyles.length][2];
    private boolean bChangeByComponent = false;

    public FontChooserComboBox() {
        this.init();
    }

    public FontChooserComboBox(String strNew) {
        this.init();
        this.setFontSelected(strNew);
    }

    public FontChooserComboBox(Font fontNew) {
        this.init();
        this.setFontSelected(fontNew.getFamily());
    }

    public void setFontSelected(String strNew) {
        if (strNew == null) {
            return;
        }
        String newString = strNew.trim().toLowerCase();
        int iNewIndex = -1;
        int i = 0;
        while (i < strFontStyles.length) {
            if (newString.equals(strFontStyles[i].toLowerCase())) {
                this.strSelected = strFontStyles[i];
                iNewIndex = i;
            }
            ++i;
        }
        if (iNewIndex == -1) {
            return;
        }
        this.bChangeByComponent = true;
        this.setSelectedIndex(iNewIndex);
        this.bChangeByComponent = false;
        this.repaint();
    }

    public String getFontSelectedAsString() {
        return this.strSelected;
    }

    public Font getFontSelected() {
        return new Font(this.strSelected, 0, 12);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        if (this.bChangeByComponent) {
            return;
        }
        int index = this.getSelectedIndex();
        if (index < 0 || index >= strFontStyles.length) {
            return;
        }
        this.strSelected = strFontStyles[index];
        this.setFont(new Font(this.strSelected, 0, 14));
    }

    private void init() {
        int i = 0;
        while (i < strFontStyles.length) {
            this.values[i][0] = strFontStyles[i];
            this.values[i][1] = strFontStyles[i];
            this.addItem(this.values[i]);
            ++i;
        }
        this.setRenderer(this.renderer);
        this.addActionListener(this);
        this.strSelected = strFontStyles[0];
        this.setFont(new Font(this.strSelected, 0, 14));
    }

    private static class FontChooserComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 3266835247180289721L;

        public FontChooserComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (list == null || value == null) {
                this.setText("?");
                return this;
            }
            if ((isSelected || cellHasFocus) && index != -1) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (!(value instanceof Object[])) {
                return this;
            }
            Object[] itemValues = (Object[])value;
            if (!(itemValues[0] instanceof String) || !(itemValues[1] instanceof String)) {
                return this;
            }
            String strDisplay = (String)itemValues[0];
            this.setFont(new Font(strDisplay, 0, 20));
            this.setText((String)itemValues[1]);
            return this;
        }
    }
}

