/*
 * Decompiled with CFR 0.152.
 */
package avinteraction;

import avinteraction.InteractionModule;
import avinteraction.Question;
import avinteraction.TFQuestionInterface;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TFQuestion
extends Question
implements TFQuestionInterface,
ActionListener {
    private static final long serialVersionUID = -6477653165768085409L;
    protected ButtonGroup answerBoxes;
    protected JRadioButton falseBox;
    protected JRadioButton trueBox;
    private String theComment = "";
    private boolean correctAnswer;

    public TFQuestion(String id, String group) {
        this.objectID = id;
        this.groupID = group;
        this.questionText = "";
        this.correctAnswer = false;
    }

    @Override
    public void setAnswer(boolean answer) {
        this.correctAnswer = answer;
    }

    @Override
    public void setComment(String c) {
        this.theComment = c;
    }

    @Override
    public String getComment() {
        if (!this.correct) {
            return this.theComment;
        }
        return "";
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.answerBoxes != null && (this.trueBox.isSelected() || this.falseBox.isSelected())) {
            this.correct = this.trueBox.isSelected() && this.correctAnswer || this.falseBox.isSelected() && !this.correctAnswer;
            this.achievedPoints = this.correct ? this.points : 0;
            this.submitButton.setEnabled(false);
        }
        this.handler.processQuestion(this.objectID, this);
    }

    @Override
    public void makeGUI() {
        this.setLayout(new BorderLayout());
        ImageIcon TFIcon = new ImageIcon("TFGraphic.gif");
        JLabel headlineLabel = new JLabel(TFIcon, 0);
        this.mainPanel = new JPanel(new GridLayout(4, 1, 5, 5));
        this.questionOutput = new JTextArea(this.questionText);
        JScrollPane questionScroller = new JScrollPane(this.questionOutput, 20, 31);
        this.questionOutput.setEditable(false);
        this.questionOutput.setWrapStyleWord(true);
        this.questionOutput.setLineWrap(true);
        this.answerBoxes = new ButtonGroup();
        this.trueBox = new JRadioButton(InteractionModule.translateMessage("true"), false);
        this.falseBox = new JRadioButton(InteractionModule.translateMessage("false"), false);
        JRadioButton fakeBox = new JRadioButton(InteractionModule.translateMessage("fake"), true);
        this.answerBoxes.add(this.trueBox);
        this.answerBoxes.add(this.falseBox);
        this.answerBoxes.add(fakeBox);
        JPanel boxPanel = new JPanel(new BorderLayout());
        boxPanel.add("North", this.trueBox);
        boxPanel.add("South", this.falseBox);
        this.setFeedback(InteractionModule.translateMessage("noAnswerYet"));
        this.setFeedbackRed();
        this.submitButton = new JButton(InteractionModule.translateMessage("submit"));
        this.submitButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.submitButton);
        JPanel bottomPanel = new JPanel(new GridLayout(2, 1));
        bottomPanel.add(buttonPanel);
        this.mainPanel.add(questionScroller);
        this.mainPanel.add(boxPanel);
        this.mainPanel.add(bottomPanel);
        this.mainPanel.add(this.feedbackScroller);
        this.add("North", headlineLabel);
        this.add("Center", this.mainPanel);
        this.guiBuilt = true;
    }

    @Override
    public void rebuildQuestion() {
        this.trueBox.setSelected(false);
        this.falseBox.setSelected(false);
        this.setFeedback("");
        this.submitButton.setEnabled(true);
    }
}

