/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.animator.VariableDeclaration;
import animal.animator.VariableDiscard;
import animal.animator.VariableUpdate;
import animal.misc.ParseSupport;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import java.io.IOException;
import java.util.Hashtable;

public class VariablesSupport
extends BasicParser
implements AnimalScriptInterface {
    public VariablesSupport() {
        this.handledKeywords = new Hashtable();
        this.handledKeywords.put("declare", "parseVariableDeclare");
        this.handledKeywords.put("update", "parseVariableSet");
        this.handledKeywords.put("discard", "parseVariableDiscard");
    }

    @Override
    public boolean generateNewStep(String currentCommand) {
        return !sameStep;
    }

    public void parseVariableDeclare() throws IOException {
        int initStep = AnimalParseSupport.getCurrentStep();
        String value = "";
        ParseSupport.parseWord(stok, "variable key");
        String name = AnimalParseSupport.parseText(stok, "variable name");
        if (ParseSupport.parseOptionalWord(stok, "variable initial value", "initValue")) {
            value = AnimalParseSupport.parseText(stok, "initial value for variable");
        }
        VariableDeclaration varDec = new VariableDeclaration(initStep, name, value);
        BasicParser.addAnimatorToAnimation(varDec, anim);
    }

    public void parseVariableSet() throws IOException {
        int initStep = AnimalParseSupport.getCurrentStep();
        ParseSupport.parseWord(stok, "variable key");
        String name = AnimalParseSupport.parseText(stok, "variable name");
        ParseSupport.parseWord(stok, "variable value", "initValue");
        String value = AnimalParseSupport.parseText(stok, "value for variable");
        VariableUpdate varUpd = new VariableUpdate(initStep, name, value);
        BasicParser.addAnimatorToAnimation(varUpd, anim);
    }

    public void parseVariableDiscard() throws IOException {
        ParseSupport.parseWord(stok, "variable key");
        String varName = AnimalParseSupport.parseText(stok, "variable name");
        VariableDiscard varDisc = new VariableDiscard(AnimalParseSupport.getCurrentStep(), varName);
        BasicParser.addAnimatorToAnimation(varDisc, anim);
    }
}

