/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.graphics.PTGraphicObject;
import animal.graphics.PTPoint;
import animal.graphics.PTPolyline;
import animal.misc.ParseSupport;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import java.awt.Point;
import java.io.IOException;
import java.util.Hashtable;

public class PropertyChangeSupport
extends BasicParser
implements AnimalScriptInterface {
    public PropertyChangeSupport() {
        this.handledKeywords = new Hashtable();
        this.handledKeywords.put("change", "parsePropertyChange");
        this.handledKeywords.put("changeparam", "parsePropertyChange");
        this.handledKeywords.put("changeproperty", "parsePropertyChange");
    }

    @Override
    public boolean generateNewStep(String command) {
        return !sameStep;
    }

    public void parsePropertyChange() throws IOException {
        ParseSupport.parseWord(stok, "property change keyword");
        String targetName = AnimalParseSupport.parseText(stok, "property change target name");
        int[] targetOIDs = PropertyChangeSupport.getObjectIDs().getIntArrayProperty(targetName);
        String methodName = ParseSupport.parseWord(stok, "property change method");
        if (methodName.equalsIgnoreCase("addNode")) {
            Point newPoint = AnimalParseSupport.parseNodeInfo(stok, "node to add to object", null);
            int i = 0;
            while (i < targetOIDs.length) {
                PTGraphicObject go = animState.getCloneByNum(targetOIDs[i]);
                if (go instanceof PTPolyline) {
                    ((PTPolyline)go).addNode(new PTPoint(newPoint));
                }
                ++i;
            }
        } else if (methodName.equalsIgnoreCase("removeNode")) {
            PTGraphicObject go = animState.getCloneByNum(targetOIDs[0]);
            if (go instanceof PTPolyline) {
                PTPolyline poly = (PTPolyline)go;
                int targetPosition = ParseSupport.parseInt(stok, "target index for node removal", 0, poly.getNodeCount() - 1);
                poly.removeNode(targetPosition);
            } else {
                System.err.println("Sorry, only possible for PTPolyline objects!");
            }
        } else if (methodName.equalsIgnoreCase("fwArrow")) {
            int i = 0;
            while (i < targetOIDs.length) {
                PTGraphicObject go = animState.getCloneByNum(targetOIDs[i]);
                if (go instanceof PTPolyline) {
                    PTPolyline p = (PTPolyline)go;
                    p.setFWArrow(true);
                }
                ++i;
            }
        } else if (methodName.equalsIgnoreCase("bwArrow")) {
            int i = 0;
            while (i < targetOIDs.length) {
                PTGraphicObject go = animState.getCloneByNum(targetOIDs[i]);
                if (go instanceof PTPolyline) {
                    PTPolyline p = (PTPolyline)go;
                    p.setBWArrow(true);
                }
                ++i;
            }
        } else {
            System.err.println("Sorry, method is unknown!");
        }
    }
}

