/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.graphics.PTGraphicObject;
import animal.graphics.PTOpenCircleSegment;
import animal.graphics.PTPolyline;
import animal.graphics.PTText;
import animal.main.Animal;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;

public class GridMath {
    static final int DEFAULT_MATRIX_CELL_SPACING = 12;
    static final int DEFAULT_PLAIN_CELL_SPACING = 8;
    static final int DEFAULT_TABLE_CELL_SPACING = 8;
    static final int DEFAULT_MATRIX_BORDER = 10;
    static final int DEFAULT_PLAIN_BORDER = 0;
    static final int DEFAULT_TABLE_BORDER = 0;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_MATRIX = 1;
    public static final int STYLE_TABLE = 2;
    public static final int ALIGN_LEFT = 110;
    public static final int ALIGN_CENTER = 111;
    public static final int ALIGN_RIGHT = 112;

    public static void calculateColumnWidths(int[] colWidths, String[][] content, Font[][] font, int min, int max, int style) {
        int biggest = 0;
        int i = 0;
        while (i < colWidths.length) {
            colWidths[i] = min;
            ++i;
        }
        int col = 0;
        while (col < content[0].length) {
            int line = 0;
            while (line < content.length) {
                FontMetrics fm = Animal.getConcreteFontMetrics(font[line][col]);
                int currentSize = fm.stringWidth(content[line][col]);
                if (currentSize > colWidths[col]) {
                    colWidths[col] = currentSize;
                    if (colWidths[col] > max && max > 0) {
                        colWidths[col] = max;
                        break;
                    }
                    if (colWidths[col] > biggest) {
                        biggest = colWidths[col];
                    }
                }
                ++line;
            }
            if (colWidths[col] > biggest) {
                biggest = colWidths[col];
            }
            ++col;
        }
    }

    public static void calculateColumnWidths(int[] colWidths, PTText[][] content, int min, int max, int style) {
        String[][] contentString = new String[content.length][content[0].length];
        Font[][] contentFont = new Font[content.length][content[0].length];
        int l = 0;
        while (l < content.length) {
            int c = 0;
            while (c < content[0].length) {
                contentString[l][c] = content[l][c].getText();
                contentFont[l][c] = content[l][c].getFont();
                ++c;
            }
            ++l;
        }
        GridMath.calculateColumnWidths(colWidths, contentString, contentFont, min, max, style);
    }

    public static void calculateColumnWidths(int[] colWidths, int min) {
        int col = 0;
        while (col < colWidths.length) {
            colWidths[col] = min;
            ++col;
        }
    }

    public static void calculateColumnWidths(int[] colWidths, int min, Font font) {
        int col = 0;
        while (col < colWidths.length) {
            colWidths[col] = min;
            ++col;
        }
    }

    public static void calculateLineHeights(int[] lineHeights, Font[][] font, int min, int max, int style) {
        int biggest = 0;
        int i = 0;
        while (i < lineHeights.length) {
            lineHeights[i] = min;
            ++i;
        }
        int line = 0;
        while (line < font.length) {
            int col = 0;
            while (col < font[0].length) {
                if (font[line][col] == null) {
                    System.out.println("   = NULL! break!");
                    return;
                }
                FontMetrics fm = Animal.getConcreteFontMetrics(font[line][col]);
                int currentSize = fm.getHeight();
                if (currentSize > lineHeights[line]) {
                    lineHeights[line] = currentSize;
                    if (lineHeights[line] > max && max > 0) {
                        lineHeights[line] = max;
                        break;
                    }
                    if (lineHeights[line] > biggest) {
                        biggest = lineHeights[line];
                    }
                }
                ++col;
            }
            ++line;
        }
    }

    public static void calculateLineHeights(int[] lineHeights, PTText[][] content, int min, int max, int style) {
        Font[][] font = new Font[content.length][content[0].length];
        int l = 0;
        while (l < content.length) {
            int c = 0;
            while (c < content[0].length) {
                font[l][c] = content[l][c].getFont();
                ++c;
            }
            ++l;
        }
        GridMath.calculateLineHeights(lineHeights, font, min, max, style);
    }

    public static void calculateLineHeights(int[] lineHeights, int min) {
        int line = 0;
        while (line < lineHeights.length) {
            lineHeights[line] = min;
            ++line;
        }
    }

    public static void calculateLineHeights(int[] lineHeights, int min, Font font) {
        int actualMinSize = min;
        if (font != null && font.getSize() > min) {
            actualMinSize = font.getSize();
        }
        GridMath.calculateLineHeights(lineHeights, actualMinSize);
    }

    public static void calculateTextPositions(PTText[][] values, int[][] alignments, int[] widths, int[] heights, Point location, int style) {
        int[] cursor = new int[]{location.x, location.y};
        int border = 0;
        int cellSpacing = 0;
        switch (style) {
            case 0: {
                border = 0;
                cellSpacing = 8;
                break;
            }
            case 1: {
                border = 10;
                cellSpacing = 12;
                break;
            }
            case 2: {
                border = 0;
                cellSpacing = 8;
            }
        }
        cursor[0] = cursor[0] + border;
        cursor[1] = cursor[1] + border;
        int leftb = cursor[0];
        int line = 0;
        while (line < values.length) {
            int col = 0;
            while (col < values[0].length) {
                FontMetrics fm = Animal.getConcreteFontMetrics(values[line][col].getFont());
                int x = alignments[line][col] == 110 ? cursor[0] + cellSpacing / 2 : (alignments[line][col] == 112 ? cursor[0] + cellSpacing / 2 + (widths[col] - fm.stringWidth(values[line][col].getText())) : cursor[0] + cellSpacing / 2 + (widths[col] - fm.stringWidth(values[line][col].getText())) / 2);
                int y = cursor[1] + heights[line] - fm.getMaxDescent();
                values[line][col].setPosition(x, y);
                cursor[0] = cursor[0] + widths[col];
                cursor[0] = cursor[0] + cellSpacing;
                ++col;
            }
            cursor[0] = leftb;
            cursor[1] = cursor[1] + heights[line];
            cursor[1] = cursor[1] + cellSpacing;
            ++line;
        }
    }

    public static void calculateTextPositions(int[][][] textPosition, String[][] values, Font[][] font, int[][] alignments, int[] widths, int[] heights, Point location, int style) {
        int[] cursor = new int[]{location.x, location.y};
        int border = 0;
        int cellSpacing = 0;
        switch (style) {
            case 0: {
                border = 0;
                cellSpacing = 8;
                break;
            }
            case 1: {
                border = 10;
                cellSpacing = 12;
                break;
            }
            case 2: {
                border = 0;
                cellSpacing = 8;
            }
        }
        cursor[0] = cursor[0] + border;
        cursor[1] = cursor[1] + border;
        int leftb = cursor[0];
        int line = 0;
        while (line < values.length) {
            int col = 0;
            while (col < values[0].length) {
                FontMetrics fm = Animal.getConcreteFontMetrics(font[line][col]);
                textPosition[line][col][0] = alignments[line][col] == 110 ? cursor[0] + cellSpacing / 2 : (alignments[line][col] == 112 ? cursor[0] + cellSpacing / 2 + (widths[col] - fm.stringWidth(values[line][col])) : cursor[0] + cellSpacing / 2 + (widths[col] - fm.stringWidth(values[line][col])) / 2);
                textPosition[line][col][1] = cursor[1];
                cursor[0] = cursor[0] + widths[col];
                cursor[0] = cursor[0] + cellSpacing;
                ++col;
            }
            cursor[0] = leftb;
            cursor[1] = cursor[1] + heights[line];
            cursor[1] = cursor[1] + cellSpacing;
            ++line;
        }
    }

    public static void calculateBackgroundPositions(int[][][] backgroundPositions, int[] widths, int[] heights, Point location, int style) {
        int border = 0;
        int spacing = 0;
        switch (style) {
            case 0: {
                border = 0;
                spacing = 8;
                break;
            }
            case 2: {
                border = 0;
                spacing = 8;
                break;
            }
            case 1: {
                border = 10;
                spacing = 12;
            }
        }
        int[] cursor = new int[]{location.x + border, location.y + border};
        int col = 0;
        while (col < widths.length) {
            int line = 0;
            while (line < heights.length) {
                backgroundPositions[line][col][0] = cursor[0];
                backgroundPositions[line][col][1] = cursor[1];
                backgroundPositions[line][col][2] = widths[col] + spacing - 1;
                backgroundPositions[line][col][3] = heights[line] + spacing - 1;
                cursor[1] = cursor[1] + (heights[line] + spacing);
                ++line;
            }
            cursor[0] = cursor[0] + (widths[col] + spacing);
            cursor[1] = location.y + border;
            ++col;
        }
    }

    private static void adjustOpenCircleSegmentForMatrix(PTOpenCircleSegment segment, int x, int y, int startAngle) {
        segment.setCenter(new Point(x, y));
        segment.setClockwise(true);
        segment.setRadius(10);
        segment.setStartAngle(startAngle);
        segment.setTotalAngle(90);
        segment.setFWArrow(false);
        segment.setBWArrow(false);
    }

    public static void calculateBracketPositions(PTGraphicObject[] brackets, int[] widths, int[] heights, Point location, int style) {
        int matrixContentHeight = 0;
        int l = 0;
        while (l < heights.length) {
            matrixContentHeight += heights[l];
            ++l;
        }
        int matrixHeight = matrixContentHeight + heights.length * 12 + 20;
        int matrixContentWidth = 0;
        int c = 0;
        while (c < widths.length) {
            matrixContentWidth += widths[c];
            ++c;
        }
        int matrixWidth = matrixContentWidth + widths.length * 12 + 20;
        PTOpenCircleSegment part0 = new PTOpenCircleSegment();
        PTOpenCircleSegment part2 = new PTOpenCircleSegment();
        PTOpenCircleSegment part3 = new PTOpenCircleSegment();
        PTOpenCircleSegment part5 = new PTOpenCircleSegment();
        PTPolyline part1 = new PTPolyline(new int[]{location.x, location.x}, new int[]{location.y + 10, location.y + matrixHeight - 10});
        PTPolyline part4 = new PTPolyline(new int[]{location.x + matrixWidth, location.x + matrixWidth}, new int[]{location.y + 10, location.y + matrixHeight - 10});
        part1.setFWArrow(false);
        part1.setBWArrow(false);
        part4.setFWArrow(false);
        part4.setBWArrow(false);
        GridMath.adjustOpenCircleSegmentForMatrix(part0, location.x + 10, location.y + 10, 90);
        GridMath.adjustOpenCircleSegmentForMatrix(part2, location.x + 10, location.y + matrixHeight - 10, 180);
        GridMath.adjustOpenCircleSegmentForMatrix(part3, location.x + matrixWidth - 10, location.y + 10, 0);
        GridMath.adjustOpenCircleSegmentForMatrix(part5, location.x + matrixWidth - 10, location.y + matrixHeight - 10, 270);
        brackets[0] = part0;
        brackets[1] = part1;
        brackets[2] = part2;
        brackets[3] = part3;
        brackets[4] = part4;
        brackets[5] = part5;
    }

    public static void calculateBracketPositions(int[][] bracketPositions, int[] widths, int[] heights, Point location, int style) {
        int matrixContentHeight = 0;
        int l = 0;
        while (l < heights.length) {
            matrixContentHeight += heights[l];
            ++l;
        }
        int matrixHeight = matrixContentHeight + heights.length * 12 + 20;
        int matrixContentWidth = 0;
        int c = 0;
        while (c < widths.length) {
            matrixContentWidth += widths[c];
            ++c;
        }
        int matrixWidth = matrixContentWidth + widths.length * 12 + 20;
        bracketPositions[0][0] = location.x + 10;
        bracketPositions[0][1] = location.y + 10;
        bracketPositions[0][2] = 10;
        bracketPositions[0][3] = 10;
        bracketPositions[0][4] = 180;
        bracketPositions[0][5] = 90;
        bracketPositions[2][0] = location.x + 10;
        bracketPositions[2][1] = location.y + matrixHeight - 10;
        bracketPositions[2][2] = 10;
        bracketPositions[2][3] = 10;
        bracketPositions[2][4] = 180;
        bracketPositions[2][5] = 90;
        bracketPositions[3][0] = location.x + matrixWidth - 10;
        bracketPositions[3][1] = location.y + 10;
        bracketPositions[3][2] = 10;
        bracketPositions[3][3] = 10;
        bracketPositions[3][4] = 0;
        bracketPositions[3][5] = 90;
        bracketPositions[5][0] = location.x + matrixWidth - 10;
        bracketPositions[5][1] = location.y + matrixHeight - 10;
        bracketPositions[5][2] = 10;
        bracketPositions[5][3] = 10;
        bracketPositions[5][4] = 0;
        bracketPositions[5][5] = 90;
        bracketPositions[1][0] = location.x;
        bracketPositions[1][1] = location.y + 10;
        bracketPositions[1][2] = location.x;
        bracketPositions[1][3] = location.y + matrixHeight - 10;
        bracketPositions[4][0] = location.x + matrixWidth;
        bracketPositions[4][1] = location.y + 10;
        bracketPositions[4][2] = location.x + matrixWidth;
        bracketPositions[4][3] = location.y + matrixHeight - 10;
    }
}

