/*
 * Decompiled with CFR 0.152.
 */
package animalscript.extensions;

import animal.animator.ColorChanger;
import animal.animator.Move;
import animal.animator.Put;
import animal.animator.Swap;
import animal.animator.TimedShow;
import animal.graphics.PTArray;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTIntArray;
import animal.graphics.PTPolyline;
import animal.graphics.PTStringArray;
import animal.graphics.PTText;
import animal.main.Animal;
import animal.misc.MessageDisplay;
import animal.misc.ParseSupport;
import animal.misc.XProperties;
import animalscript.core.AnimalParseSupport;
import animalscript.core.AnimalScriptInterface;
import animalscript.core.BasicParser;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Hashtable;

public class ArraySupportBuiltIn
extends BasicParser
implements AnimalScriptInterface {
    public ArraySupportBuiltIn() {
        this.handledKeywords = new Hashtable();
        this.rulesHash = new XProperties();
        this.handledKeywords.put("array", "parseArrayInput");
        this.handledKeywords.put("field", "parseArrayInput");
        this.handledKeywords.put("arraymarker", "parseArrayMarkerInput");
        this.handledKeywords.put("arraypointer", "parseArrayMarkerInput");
        this.handledKeywords.put("arrayindex", "parseArrayMarkerInput");
        this.handledKeywords.put("highlightarraycell", "parseColorChange");
        this.handledKeywords.put("highlightarrayelem", "parseColorChange");
        this.handledKeywords.put("highlightarrayelement", "parseColorChange");
        this.handledKeywords.put("unhighlightarraycell", "parseColorChange");
        this.handledKeywords.put("unhighlightarrayelem", "parseColorChange");
        this.handledKeywords.put("unhighlightarrayelement", "parseColorChange");
        this.handledKeywords.put("arrayput", "parseArrayPut");
        this.rulesHash.put("arrayput", "# put the given value at the given array position");
        this.handledKeywords.put("arrayswap", "parseArraySwap");
        this.rulesHash.put("arrayswap", "# swap the given array positions on the target array");
        this.handledKeywords.put("jumparrayindex", "parseMovePointer");
        this.handledKeywords.put("jumparraymarker", "parseMovePointer");
        this.handledKeywords.put("jumparraypointer", "parseMovePointer");
        this.handledKeywords.put("jumpindex", "parseMovePointer");
        this.handledKeywords.put("jumpmarker", "parseMovePointer");
        this.handledKeywords.put("jumppointer", "parseMovePointer");
        this.handledKeywords.put("movearrayindex", "parseMovePointer");
        this.handledKeywords.put("movearraymarker", "parseMovePointer");
        this.handledKeywords.put("movearraypointer", "parseMovePointer");
        this.handledKeywords.put("moveindex", "parseMovePointer");
        this.handledKeywords.put("movemarker", "parseMovePointer");
        this.handledKeywords.put("movepointer", "parseMovePointer");
    }

    @Override
    public boolean generateNewStep(String currentCommand) {
        return !sameStep;
    }

    public void parseArrayInput() throws IOException {
        boolean cascadedDisplay;
        boolean verticalMode = false;
        int displayDelay = 0;
        String localType = ParseSupport.parseWord(stok, "Array type").toLowerCase();
        String arrayName = AnimalParseSupport.parseText(stok, "Array object name");
        String basicFeedbackTag = String.valueOf(localType) + " '" + arrayName + "' ";
        ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + " deprecated 'at'", "at");
        Point basePoint = AnimalParseSupport.parseNodeInfo(stok, String.valueOf(basicFeedbackTag) + "start node", null);
        Color arrayColor = AnimalParseSupport.parseAndSetColor(stok, arrayName, "color", "black");
        Color fillColor = AnimalParseSupport.parseAndSetColor(stok, arrayName, "fillColor", "white");
        Color elementColor = AnimalParseSupport.parseAndSetColor(stok, arrayName, "elementColor", "black");
        Color elemHighlightColor = AnimalParseSupport.parseAndSetColor(stok, arrayName, "elemHighlight", "red");
        Color cellHighlightColor = AnimalParseSupport.parseAndSetColor(stok, arrayName, "cellHighlight", "yellow");
        verticalMode = ParseSupport.parseOptionalWord(stok, "Array '" + arrayName + "'orientation 'vertical'", "vertical");
        if (!verticalMode) {
            ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "orientation 'horizontal'", "horizontal");
        }
        ParseSupport.parseMandatoryWord(stok, String.valueOf(basicFeedbackTag) + "Keyword 'length'", "length");
        int arrayLength = ParseSupport.parseInt(stok, String.valueOf(basicFeedbackTag) + "length(>=1)", 1);
        String[] elements = new String[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            elements[i] = AnimalParseSupport.parseText(stok, String.valueOf(basicFeedbackTag) + "element #" + i, null, false, chosenLanguage);
            ++i;
        }
        ArraySupportBuiltIn.getObjectProperties().put(String.valueOf(arrayName) + ".length", arrayLength);
        int basicDepth = 0x7FFFFFFB;
        if (ParseSupport.parseOptionalWord(stok, "'depth' tag for Array " + arrayName, "depth")) {
            basicDepth = ParseSupport.parseInt(stok, "Array '" + arrayName + "'  depth(>=0))", 0);
        }
        String unit = "ticks";
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "keyword 'after'", "after")) {
            displayDelay = ParseSupport.parseInt(stok, String.valueOf(basicFeedbackTag) + "delay", 0);
            unit = ParseSupport.parseWord(stok, String.valueOf(basicFeedbackTag) + "delay unit");
        }
        if ((cascadedDisplay = ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "keyword 'cascaded'", "cascaded")) && ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "keyword 'within'", "within")) {
            ParseSupport.parseInt(stok, String.valueOf(basicFeedbackTag) + "duration", 0);
            if (displayDelay == 0) {
                unit = ParseSupport.parseWord(stok, String.valueOf(basicFeedbackTag) + "duration unit");
            } else if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "duration unit", "ticks")) {
                unit = "ticks";
            } else if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicFeedbackTag) + "duration unit", "ms")) {
                unit = "ms";
            }
        }
        Font f = AnimalParseSupport.parseFontInfo(stok, "array");
        PTStringArray stringArray = new PTStringArray(elements);
        stringArray.setLocation(basePoint);
        stringArray.setColor(arrayColor);
        stringArray.setBGColor(fillColor);
        stringArray.setFontColor(elementColor);
        stringArray.setDepth(basicDepth);
        stringArray.setFont(f);
        stringArray.setHighlightColor(cellHighlightColor);
        stringArray.setElemHighlightColor(elemHighlightColor);
        BasicParser.addGraphicObject(stringArray, anim);
        ArraySupportBuiltIn.getObjectIDs().put(arrayName, stringArray.getNum(false));
        TimedShow ts = new TimedShow(currentStep, stringArray.getNum(true), 0, "show", true);
        BasicParser.addAnimatorToAnimation(ts, anim);
    }

    public void parseArrayMarkerInput() throws IOException {
        String ids;
        int maxLength;
        String markerLabel = null;
        PTText labelText = null;
        String localType = ParseSupport.parseWord(stok, "Array marker type").toLowerCase();
        String markerName = AnimalParseSupport.parseText(stok, "Array marker name");
        String basicTag = String.valueOf(localType) + " '" + markerName + "' ";
        ParseSupport.parseMandatoryWord(stok, String.valueOf(basicTag) + "keyword 'on'", "on");
        String targetObjectName = AnimalParseSupport.parseText(stok, String.valueOf(basicTag) + "base array name");
        int[] targetOIDs = ArraySupportBuiltIn.getObjectIDs().getIntArrayProperty(targetObjectName);
        if (targetOIDs == null || !ArraySupportBuiltIn.getObjectTypes().getProperty(targetObjectName).equals(ArraySupportBuiltIn.getTypeIdentifier("array"))) {
            ParseSupport.formatException("Target object '" + targetObjectName + "' unknown or not an array.", stok);
        }
        if ((maxLength = ArraySupportBuiltIn.getObjectProperties().getIntProperty(String.valueOf(targetObjectName) + ".length", -1)) < 1) {
            ParseSupport.formatException("Invalid number of elements in array '" + targetObjectName + "'.", stok);
        }
        ParseSupport.parseMandatoryWord(stok, String.valueOf(basicTag) + "keyword 'atIndex'", "atIndex");
        int targetIndex = ParseSupport.parseInt(stok, String.valueOf(basicTag) + "target index([0, " + (maxLength - 1) + "])", 0, maxLength - 1);
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicTag) + "optional keyword 'label'", "label")) {
            markerLabel = AnimalParseSupport.parseText(stok, String.valueOf(basicTag) + "label", null, false, chosenLanguage);
        }
        int length = 40;
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicTag) + "optional keyword 'short'", "short")) {
            length = 20;
        } else if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicTag) + "optional keyword 'long'", "long")) {
            length = 60;
        } else if (ParseSupport.parseOptionalWord(stok, String.valueOf(basicTag) + "optional keyword 'normal'", "normal")) {
            length = 40;
        }
        int indexOID = targetOIDs[maxLength + targetIndex];
        Point[] coords = new Point[2];
        PTGraphicObject ptgo = animState.getCloneByNum(indexOID);
        Rectangle boundingBox = ptgo.getBoundingBox();
        if (ArraySupportBuiltIn.getObjectProperties().getProperty(String.valueOf(targetObjectName) + ".orientation").equals("horizontal")) {
            coords[1] = new Point(boundingBox.x + (boundingBox.width >>> 1), boundingBox.y);
            coords[0] = new Point(coords[1].x, boundingBox.y - length);
        } else {
            coords[1] = new Point(boundingBox.x, boundingBox.y + (boundingBox.height >>> 1));
            coords[0] = new Point(boundingBox.x - length, coords[1].y);
        }
        PTPolyline indexMarker = new PTPolyline(coords);
        indexMarker.setObjectName(String.valueOf(markerLabel) + ".ptr");
        indexMarker.setFWArrow(true);
        indexMarker.setColor(AnimalParseSupport.parseAndSetColor(stok, localType, "color"));
        AnimalParseSupport.parseAndSetDepth(stok, indexMarker, localType);
        if (markerLabel != null) {
            Font f = AnimalParseSupport.parseFontInfo(stok, "arrayIndex");
            labelText = new PTText(markerLabel, f);
            labelText.setObjectName(markerLabel);
            labelText.setColor(indexMarker.getColor());
            FontMetrics fm = Animal.getConcreteFontMetrics(f);
            int textWidth = fm.stringWidth(markerLabel);
            if (ArraySupportBuiltIn.getObjectProperties().getProperty(String.valueOf(targetObjectName) + ".orientation").equals("horizontal")) {
                labelText.setLocation(new Point(coords[0].x - (textWidth >>> 1), coords[0].y - 5));
            } else {
                labelText.setLocation(new Point(coords[0].x - textWidth - 5, coords[0].y + 8));
            }
            BasicParser.addGraphicObject(labelText, anim);
            ArraySupportBuiltIn.getObjectIDs().put(String.valueOf(markerName) + ".label", labelText.getNum(false));
        }
        BasicParser.addGraphicObject(indexMarker, anim);
        String markerID = String.valueOf(indexMarker.getNum(false));
        String string = ids = labelText == null ? markerID : String.valueOf(markerID) + " " + String.valueOf(labelText.getNum(false));
        if (ArraySupportBuiltIn.getObjectProperties().getProperty(String.valueOf(targetObjectName) + ".ptrs") != null) {
            ArraySupportBuiltIn.getObjectProperties().put(String.valueOf(targetObjectName) + ".ptrs", String.valueOf(ArraySupportBuiltIn.getObjectProperties().getProperty(String.valueOf(targetObjectName) + ".ptrs")) + " " + markerName);
        } else {
            ArraySupportBuiltIn.getObjectProperties().put(String.valueOf(targetObjectName) + ".ptrs", markerName);
        }
        ArraySupportBuiltIn.getObjectIDs().put(markerName, ids);
        ArraySupportBuiltIn.getObjectIDs().put(targetObjectName, String.valueOf(ArraySupportBuiltIn.getObjectIDs().getProperty(targetObjectName)) + ' ' + ids);
        ArraySupportBuiltIn.getObjectProperties().put(String.valueOf(markerName) + ".target", targetObjectName);
        ArraySupportBuiltIn.getObjectProperties().put(String.valueOf(markerName) + ".pos", targetIndex);
        ArraySupportBuiltIn.getObjectTypes().put(markerName, ArraySupportBuiltIn.getTypeIdentifier("arraymarker"));
        AnimalParseSupport.showComponents(stok, ids, localType, true);
    }

    public void parseArrayPut() throws IOException {
        ParseSupport.parseWord(stok, "data structure-specific operator");
        String arrayName = null;
        String objectValue = AnimalParseSupport.parseText(stok, "arrayPut value", null, false, chosenLanguage);
        ParseSupport.parseMandatoryWord(stok, "arrayPut keyword 'on'", "on");
        arrayName = AnimalParseSupport.parseText(stok, "arrayPut base array");
        int arrayID = ArraySupportBuiltIn.getObjectIDs().getIntProperty(arrayName, -1);
        PTGraphicObject ptgo = animState.getCloneByNum(arrayID);
        if (arrayID <= 0 || !(ptgo instanceof PTArray)) {
            ParseSupport.formatException("Target object '" + arrayName + "' unknown or not an array.", stok);
        }
        PTArray theArray = (PTArray)ptgo;
        ParseSupport.parseMandatoryWord(stok, "arrayPut keyword 'position'", "position");
        int maxLength = theArray.getSize();
        if (maxLength < 1) {
            ParseSupport.formatException("Invalid number of elements in array '" + arrayName + "'.", stok);
        }
        int targetPos = ParseSupport.parseInt(stok, "arrayPut target pos [0, " + (maxLength - 1) + "]", 0, maxLength - 1);
        Put putAnimator = null;
        putAnimator = ptgo instanceof PTIntArray ? new Put(currentStep, arrayID, 0, 0, Integer.parseInt(objectValue), targetPos) : new Put(currentStep, arrayID, 0, 0, objectValue, targetPos);
        AnimalParseSupport.parseTiming(stok, putAnimator, "arrayPut");
        BasicParser.addAnimatorToAnimation(putAnimator, anim);
        String unparsed = ParseSupport.consumeIncludingEOL(stok, "ds specific stuff");
        if (unparsed.length() > 1) {
            System.err.println("#Left unparsed...: '" + unparsed + "'");
        }
        stok.pushBack();
    }

    public void parseArraySwap() throws IOException {
        String localType = ParseSupport.parseWord(stok, "data structure-specific operator");
        ParseSupport.parseMandatoryWord(stok, String.valueOf(localType) + " keyword 'on'", "on");
        String arrayName = AnimalParseSupport.parseText(stok, String.valueOf(localType) + " base array name");
        int arrayID = ArraySupportBuiltIn.getObjectIDs().getIntProperty(arrayName);
        ParseSupport.parseMandatoryWord(stok, String.valueOf(localType) + " keyword 'position'", "position");
        int maxLength = ArraySupportBuiltIn.getObjectProperties().getIntProperty(String.valueOf(arrayName) + ".length");
        int firstSwapPos = ParseSupport.parseInt(stok, String.valueOf(localType) + " first position", 0, maxLength - 1);
        ParseSupport.parseMandatoryWord(stok, String.valueOf(localType) + " keyword 'with'", "with");
        int secondSwapPos = ParseSupport.parseInt(stok, String.valueOf(localType) + " second position", 0, maxLength - 1);
        Swap swapAnimator = new Swap(currentStep, arrayID, 0, firstSwapPos, secondSwapPos);
        BasicParser.addAnimatorToAnimation(swapAnimator, anim);
        String unparsed = ParseSupport.consumeIncludingEOL(stok, "ds specific stuff");
        if (unparsed.length() > 1) {
            System.err.println("#Left unparsed...: '" + unparsed + "'");
        }
        stok.pushBack();
    }

    public void parseColorChange() throws IOException {
        String colorType = ParseSupport.parseWord(stok, "color change operation");
        ColorChanger colChanger = null;
        Color c = null;
        int[] targetOIDs = null;
        boolean elemMode = colorType.toLowerCase().endsWith("elem");
        boolean highlightMode = colorType.startsWith("high");
        ParseSupport.parseMandatoryWord(stok, String.valueOf(colorType) + " keyword 'on'", "on");
        String targetArray = AnimalParseSupport.parseText(stok, String.valueOf(colorType) + " array name");
        if (ParseSupport.parseOptionalWord(stok, String.valueOf(colorType) + " keyword 'position'", "position")) {
            if (ArraySupportBuiltIn.getObjectProperties().getIntProperty(String.valueOf(targetArray) + ".length", -2) == -2) {
                XProperties helper = ArraySupportBuiltIn.getObjectProperties().getElementsForPrefix(targetArray);
                helper.list(System.out);
            }
            int targetLine = ParseSupport.parseInt(stok, String.valueOf(colorType) + " array index", 0, ArraySupportBuiltIn.getObjectProperties().getIntProperty(String.valueOf(targetArray) + ".length", 0));
            targetOIDs = new int[]{ArraySupportBuiltIn.getObjectIDs().getIntProperty(String.valueOf(targetArray) + "[" + targetLine + (elemMode ? "]" : "].box"))};
        } else {
            int fromRange = 0;
            int toRange = ArraySupportBuiltIn.getObjectProperties().getIntProperty(String.valueOf(targetArray) + ".length") - 1;
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(colorType) + " cell/element range keyword 'from'", "from")) {
                fromRange = ParseSupport.parseInt(stok, String.valueOf(colorType) + " array index", 0, ArraySupportBuiltIn.getObjectProperties().getIntProperty(String.valueOf(targetArray) + ".length"));
            }
            if (ParseSupport.parseOptionalWord(stok, String.valueOf(colorType) + " cell/element range keyword 'to'", "to")) {
                toRange = ParseSupport.parseInt(stok, String.valueOf(colorType) + " array index", fromRange, ArraySupportBuiltIn.getObjectProperties().getIntProperty(String.valueOf(targetArray) + ".length"));
            }
            targetOIDs = new int[toRange - fromRange + 1];
            int i = 0;
            while (fromRange <= toRange) {
                targetOIDs[i] = ArraySupportBuiltIn.getObjectIDs().getIntProperty(String.valueOf(targetArray) + "[" + fromRange + (elemMode ? "]" : "].box"));
                ++fromRange;
                ++i;
            }
        }
        c = elemMode ? (highlightMode ? ArraySupportBuiltIn.getObjectProperties().getColorProperty(String.valueOf(targetArray) + ".elemHighlight", Color.blue) : ArraySupportBuiltIn.getObjectProperties().getColorProperty(String.valueOf(targetArray) + ".elementColor", Color.black)) : (highlightMode ? ArraySupportBuiltIn.getObjectProperties().getColorProperty(String.valueOf(targetArray) + ".cellHighlight", Color.yellow) : ArraySupportBuiltIn.getObjectProperties().getColorProperty(String.valueOf(targetArray) + ".fillColor", Color.white));
        colChanger = new ColorChanger(currentStep, targetOIDs, 0, elemMode ? "color" : "fillColor", c);
        AnimalParseSupport.parseTiming(stok, colChanger, "Color");
        BasicParser.addAnimatorToAnimation(colChanger, anim);
    }

    public void parseMovePointer() throws IOException {
        int targetElementOID;
        String localType = ParseSupport.parseWord(stok, "move pointer keyword");
        String targetIDName = AnimalParseSupport.parseText(stok, "index marker name");
        int[] targetOIDs = ArraySupportBuiltIn.getObjectIDs().getIntArrayProperty(targetIDName);
        PTGraphicObject moveLine = null;
        PTGraphicObject ptgo = animState.getCloneByNum(targetOIDs[0]);
        String baseElementName = ArraySupportBuiltIn.getObjectProperties().getProperty(String.valueOf(targetIDName) + ".target");
        Rectangle boundingBox = ptgo.getBoundingBox();
        Point[] points = new Point[2];
        points[0] = new Point(boundingBox.x + boundingBox.width, boundingBox.y + boundingBox.height);
        if (targetOIDs == null || !ArraySupportBuiltIn.getObjectTypes().getProperty(targetIDName).equals(ArraySupportBuiltIn.getTypeIdentifier("arraymarker")) || !ArraySupportBuiltIn.getObjectTypes().getProperty(baseElementName).equals(ArraySupportBuiltIn.getTypeIdentifier("array"))) {
            ParseSupport.formatException("invalid or unknown array ID: " + targetIDName, stok);
        }
        ParseSupport.parseMandatoryWord(stok, "index marker keyword 'to'", "to");
        int maxIndex = ArraySupportBuiltIn.getObjectProperties().getIntProperty(String.valueOf(baseElementName) + ".length", -1);
        if (ParseSupport.parseOptionalWord(stok, "index marker keyword 'position'", "position")) {
            int targetPos = ParseSupport.parseInt(stok, "index marker position value [0, " + maxIndex + "]", 0, maxIndex);
            int targetElementOID2 = ArraySupportBuiltIn.getObjectIDs().getIntProperty(String.valueOf(baseElementName) + "[" + targetPos + "].box", -1);
            ptgo = animState.getCloneByNum(targetElementOID2);
            boundingBox = ptgo.getBoundingBox();
            points[1] = ArraySupportBuiltIn.getObjectProperties().getProperty(String.valueOf(baseElementName) + ".orientation").equals("horizontal") ? new Point(boundingBox.x + (boundingBox.width >>> 1), boundingBox.y) : new Point(boundingBox.x, boundingBox.y + (boundingBox.height >>> 1));
            moveLine = new PTPolyline(points);
            ArraySupportBuiltIn.getObjectProperties().put(String.valueOf(targetIDName) + ".pos", targetPos);
        } else if (ParseSupport.parseOptionalWord(stok, "index marker keyword 'arrayEnd'", "arrayEnd")) {
            targetElementOID = ArraySupportBuiltIn.getObjectIDs().getIntProperty(String.valueOf(baseElementName) + "[" + maxIndex + "].box", -1);
            ptgo = animState.getCloneByNum(targetElementOID);
            boundingBox = ptgo.getBoundingBox();
            points[1] = ArraySupportBuiltIn.getObjectProperties().getProperty(String.valueOf(baseElementName) + ".orientation").equals("horizontal") ? new Point(boundingBox.x + (boundingBox.width >>> 1), boundingBox.y) : new Point(boundingBox.x, boundingBox.y + (boundingBox.height >>> 1));
            moveLine = new PTPolyline(points);
        } else if (ParseSupport.parseOptionalWord(stok, "index marker keyword 'outside'", "outside")) {
            targetElementOID = ArraySupportBuiltIn.getObjectIDs().getIntProperty(String.valueOf(baseElementName) + "[" + (maxIndex - 1) + "].box", -1);
            ptgo = animState.getCloneByNum(targetElementOID);
            boundingBox = ptgo.getBoundingBox();
            points[1] = ArraySupportBuiltIn.getObjectProperties().getProperty(String.valueOf(baseElementName) + ".orientation").equals("horizontal") ? new Point(boundingBox.x + boundingBox.width + 20, boundingBox.y) : new Point(boundingBox.x, boundingBox.y + boundingBox.height + 20);
            moveLine = new PTPolyline(points);
        } else {
            ParseSupport.formatException("invalid keyword for array marker move", stok);
        }
        int[] oid = targetOIDs;
        moveLine.setObjectName("moveLine3");
        BasicParser.addGraphicObject(moveLine, anim);
        int moveBaseNum = moveLine.getNum(false);
        Move move = new Move(currentStep, oid, 0, "translate", moveBaseNum);
        AnimalParseSupport.parseTiming(stok, move, "Array Marker Move");
        if (localType.equalsIgnoreCase("jump") && move.getDuration() != 0) {
            MessageDisplay.message("'jump' can not have a duration - use 'move' instead in line " + stok.lineno());
            move.setDuration(0);
        }
        BasicParser.addAnimatorToAnimation(move, anim);
    }
}

