/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import animal.gui.AnimalMainWindow;
import animal.main.Animal;
import animal.main.Animation;
import animal.misc.AnimalColorChooserPanel;
import animal.misc.ColorChoice;
import animal.misc.ColoredSquare;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractAction;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import translator.AnimalTranslator;

public class ColorChooserAction
extends AbstractAction {
    private static final long serialVersionUID = -3178456060655099841L;
    private Component parent;
    private Color chosenColor = Color.black;
    private String tag;
    private JColorChooser chooser;
    private JDialog colorDialog;
    private PropertyChangeSupport changeSupport;

    public ColorChooserAction(Component parentComponent, String label, String paramTag, String toolTipText, Color startColor) {
        super(label, new ColoredSquare(startColor));
        this.parent = parentComponent;
        this.chosenColor = startColor;
        this.chooser = new JColorChooser(this.chosenColor);
        this.chooser.addChooserPanel(new AnimalColorChooserPanel());
        this.colorDialog = JColorChooser.createDialog(this.parent, AnimalTranslator.translateMessage("selectColor"), false, this.chooser, this, this);
        this.tag = paramTag;
        this.putValue("ShortDescription", toolTipText);
        if (this.parent instanceof PropertyChangeListener) {
            this.changeSupport = new PropertyChangeSupport(this.parent);
            this.changeSupport.addPropertyChangeListener((PropertyChangeListener)((Object)this.parent));
        }
    }

    public Color getColor() {
        return this.chosenColor;
    }

    public void setColor(Color c) {
        this.putValue("SmallIcon", new ColoredSquare(c));
        this.putValue("Name", ColorChoice.getColorName(c));
        if (this.parent instanceof PropertyChangeListener) {
            this.changeSupport.firePropertyChange(this.tag, this.chosenColor, c);
            this.chosenColor = c;
            AnimalMainWindow.getWindowCoordinator().getDrawWindow(false).setChanged();
        } else {
            Animation anim = Animal.get().getAnimation();
            if (anim != null) {
                anim.doChange();
            }
        }
        if (this.parent != null) {
            this.parent.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (actionCommand.equalsIgnoreCase("OK")) {
            Color c = this.chooser.getColor();
            this.setColor(c);
        } else if (!actionCommand.equalsIgnoreCase("Cancel")) {
            this.colorDialog.setVisible(true);
        }
    }
}

