/*
 * Decompiled with CFR 0.152.
 */
package animal.misc;

import java.io.File;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.filechooser.FileView;

public class AnimalFileView
extends FileView {
    private Hashtable<String, Icon> icons = new Hashtable(5);
    private Hashtable<String, String> fileDescriptions = new Hashtable(5);
    private Hashtable<String, String> typeDescriptions = new Hashtable(5);

    @Override
    public String getName(File f) {
        return null;
    }

    public void putDescription(File f, String fileDescription) {
        this.fileDescriptions.put(fileDescription, f.getName());
    }

    @Override
    public String getDescription(File f) {
        return this.fileDescriptions.get(f);
    }

    public void putTypeDescription(String extension, String typeDescription) {
        this.typeDescriptions.put(typeDescription, extension);
    }

    public void putTypeDescription(File f, String typeDescription) {
        this.putTypeDescription(this.getExtension(f), typeDescription);
    }

    @Override
    public String getTypeDescription(File f) {
        return this.typeDescriptions.get(this.getExtension(f));
    }

    public String getExtension(File f) {
        String name = f.getName();
        if (name != null) {
            int extensionIndex = name.lastIndexOf(46);
            if (extensionIndex < 0) {
                return null;
            }
            return name.substring(extensionIndex + 1).toLowerCase();
        }
        return null;
    }

    public void putIcon(String extension, Icon icon) {
        this.icons.put(extension, icon);
    }

    @Override
    public Icon getIcon(File f) {
        Icon icon = null;
        String extension = this.getExtension(f);
        if (extension != null) {
            icon = this.icons.get(extension);
        }
        return icon;
    }

    public Boolean isHidden(File f) {
        String name = f.getName();
        if (name != null && !name.equals("") && name.charAt(0) == '.') {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean isTraversable(File f) {
        if (f.isDirectory()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

