/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.animator.Animator;
import animal.animator.TimedAnimator;
import animal.main.Animation;
import animal.misc.EditableObject;
import animal.misc.XProperties;
import java.util.Vector;
import translator.AnimalTranslator;

public class Link
extends EditableObject {
    public static final String CLICK_PROMPT = "Link.clickPrompt";
    public static final String LINK_DURATION = "Link.duration";
    public static final String LINK_MODE = "Link.mode";
    public static final String LINK_NAME = "Link.label";
    public static final String NEXT_STEP_LABEL = "Link.nextStep";
    public static final String REPEAT_COUNT = "Link.repeat";
    public static final String STEP_LABEL = "Link.step";
    public static final String TIME_LABEL = "Link.time";
    public static final String TARGET_OBJECT_ID = "Link.clickTargetID";
    public static final int START = 0;
    public static final int END = Integer.MAX_VALUE;
    public static final int ERROR = Integer.MIN_VALUE;
    public static final int WAIT_KEY = 1;
    public static final int WAIT_TIME = 2;
    public static final int WAIT_CLICK = 4;
    public static final int REPEAT = 8;
    private int nrOfIterationsLeft = 0;
    private static final long serialVersionUID = 6008761181264438642L;
    private static final int fileVersion = 2;

    public static int getFileVersion() {
        return 2;
    }

    public Link() {
    }

    public Link(int step, int nextStep) {
        this.setStep(step);
        this.setNextStep(nextStep);
        this.setMode(1);
    }

    public Link(XProperties props) {
        this.setProperties(props);
        int mode = props.getIntProperty(LINK_MODE, 1);
        if (mode != 1 && mode != 2 && mode != 4) {
            this.setMode(1);
        }
    }

    public Link(int step, int nextStep, int time) {
        this(step, nextStep);
        this.setTime(time);
        this.setMode(2);
    }

    public String getClickPrompt() {
        return this.getProperties().getProperty(CLICK_PROMPT, AnimalTranslator.translateMessage("clickOnXToContinue", this.getTargetObjectID()));
    }

    public int getDurationInTicks() {
        int durationInMs = 0;
        Vector<Animator> animatorsAtStep = Animation.get().getAnimatorsAtStep(this.getStep());
        for (Animator animator : animatorsAtStep) {
            TimedAnimator helper;
            if (!(animator instanceof TimedAnimator) || (helper = (TimedAnimator)animator).isUnitIsTicks() || helper.getDuration() + helper.getOffset() <= durationInMs) continue;
            durationInMs = helper.getDuration() + helper.getOffset();
        }
        return this.getProperties().getIntProperty(LINK_DURATION, durationInMs / 50);
    }

    public String getLinkLabel() {
        return this.getProperties().getProperty(LINK_NAME);
    }

    public int getMode() {
        return this.getProperties().getIntProperty(LINK_MODE, 1);
    }

    public int getNextStep() {
        return this.getProperties().getIntProperty(NEXT_STEP_LABEL, Integer.MAX_VALUE);
    }

    public int getNrOfIterationsLeft() {
        return this.nrOfIterationsLeft;
    }

    public int getRepeatCount() {
        return this.getProperties().getIntProperty(REPEAT_COUNT, 0);
    }

    public int getStep() {
        return this.getProperties().getIntProperty(STEP_LABEL, 0);
    }

    public int getTargetObjectID() {
        return this.getProperties().getIntProperty(TARGET_OBJECT_ID, 1);
    }

    public int getTime() {
        return this.getProperties().getIntProperty(TIME_LABEL, 0);
    }

    public void setClickPrompt(String message) {
        this.getProperties().put(CLICK_PROMPT, message);
    }

    public void setDurationInTicks(int duration) {
        if (duration > 0) {
            this.getProperties().put(LINK_DURATION, duration);
        }
    }

    public void setLinkLabel(String label) {
        this.getProperties().put(LINK_NAME, label);
    }

    public void setMode(int mode) {
        if (mode == 2 || mode == 1 || mode == 4) {
            this.getProperties().put(LINK_MODE, mode);
        } else {
            this.getProperties().put(LINK_MODE, 1);
        }
    }

    public void setNextStep(int nextStep) {
        this.getProperties().put(NEXT_STEP_LABEL, nextStep);
    }

    public void setNrOfIterationsLeft(int nr) {
        this.nrOfIterationsLeft = nr;
    }

    public void setRepeatCount(int nrOfRepeats) {
        this.getProperties().put(REPEAT_COUNT, nrOfRepeats);
    }

    public void setStep(int step) {
        this.getProperties().put(STEP_LABEL, step);
    }

    public void setTargetObjectID(int targetID) {
        this.getProperties().put(TARGET_OBJECT_ID, targetID);
    }

    public void setTime(int time) {
        this.getProperties().put(TIME_LABEL, time);
    }

    public String getLinkDescription() {
        StringBuilder sb = new StringBuilder(40);
        if (this.getStep() == Integer.MAX_VALUE) {
            sb.append("----- end -----");
        } else {
            sb.append("Step ").append(this.getStep());
            String linkLabel = this.getLinkLabel();
            if (linkLabel != null && linkLabel.length() != 0) {
                sb.append(" label '").append(linkLabel).append("'");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        if (this.getStep() == Integer.MAX_VALUE) {
            sb.append("----- end -----");
        } else {
            sb.append("----- Step ").append(this.getStep());
            int duration = this.getDurationInTicks();
            if (duration > 0) {
                sb.append(" d=").append(duration).append(' ');
            }
            if (this.getMode() == 2) {
                sb.append(" (wait ").append(this.getTime()).append(" ms afterwards)");
            } else if (this.getMode() == 4) {
                sb.append(" (wait for click on ID ").append(this.getTargetObjectID()).append(')');
            }
            sb.append(" -----");
            String linkLabel = this.getLinkLabel();
            if (linkLabel != null && linkLabel.length() != 0) {
                sb.append(" label '").append(linkLabel).append("'");
            }
        }
        return sb.toString();
    }

    public void discard() {
        this.setLinkLabel(null);
    }
}

