/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.editor.graphics.GraphicEditor;
import animal.graphics.PTGraphicObject;
import animal.gui.AnimalMainWindow;
import animal.gui.GraphicVector;
import animal.gui.GraphicVectorEntry;
import animal.main.Animation;
import animal.main.AnimationCanvas;
import animal.main.AnimationState;
import animal.main.AnimationWindow;
import animal.main.Link;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class AnimationCanvasMouseListener
extends MouseAdapter {
    AnimationCanvas canvas = null;

    public AnimationCanvasMouseListener(AnimationCanvas theCanvas) {
        this.canvas = theCanvas;
    }

    PTGraphicObject select(GraphicVector objects, Point p, int tolerance) {
        int min = Integer.MAX_VALUE;
        GraphicVectorEntry next = null;
        int a = objects.getSize() - 1;
        while (a >= 0) {
            int dist;
            GraphicEditor e;
            GraphicVectorEntry gve = objects.elementAt(a);
            if (gve != null && (e = (GraphicEditor)gve.go.getEditor()) != null && (dist = e.getMinDist(gve.go, p)) < min) {
                min = dist;
                next = gve;
            }
            --a;
        }
        if (min > tolerance || next == null) {
            return null;
        }
        return next.go;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        double magFactor = this.canvas.getMagnification();
        Point clickedPoint = new Point((int)Math.round((double)evt.getX() / magFactor), (int)Math.round((double)evt.getY() / magFactor));
        AnimationWindow animWindow = AnimalMainWindow.getWindowCoordinator().getAnimationWindow(false);
        AnimationState currentState = animWindow.getAnimationState();
        if (currentState == null) {
            return;
        }
        Animation anim = currentState.getAnimation();
        Link currentLink = anim.getLink(currentState.getStep());
        PTGraphicObject ptgo = this.select(this.canvas.getObjects(), clickedPoint, 20);
        if (ptgo != null) {
            int targetLinkGONum;
            int ptgoNum = ptgo.getNum(false);
            if (currentLink.getMode() == 4 && (targetLinkGONum = currentLink.getTargetObjectID()) == ptgoNum) {
                animWindow.enableControls(true);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }
}

