/*
 * Decompiled with CFR 0.152.
 */
package animal.main;

import animal.main.Animal;
import animal.misc.MessageDisplay;
import animal.misc.XProperties;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class AnimalFrame
extends JFrame {
    private static final long serialVersionUID = 6104840387066847165L;
    public static final String CLOSE_ICON_FILENAME = "closeWindow.gif";
    protected Animal animal;
    protected XProperties props;
    private static final String GRAPHICS_PATH = "/graphics/";
    private static Image animalImage;
    boolean initialized = false;
    public static boolean runsInApplet;
    public static URL baseURL;
    public Class<?> animalImageDummy = null;
    boolean fComponentsAdjusted = false;

    static {
        runsInApplet = false;
        baseURL = null;
    }

    public AnimalFrame(Animal animalInstance, XProperties properties, boolean appletMode) {
        this.animal = animalInstance;
        runsInApplet = appletMode;
        this.props = properties;
        this.setIconImage(this.getAnimalImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new AnimalFrameListener());
    }

    public AnimalFrame(Animal animalInstance, XProperties properties) {
        this.animal = animalInstance;
        this.props = properties;
        this.setIconImage(this.getAnimalImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new AnimalFrameListener());
    }

    private Image getAnimalImage() {
        ImageIcon ii;
        if (runsInApplet) {
            return null;
        }
        if (animalImage == null && (ii = this.getImageIcon("Animal.png")) != null) {
            animalImage = ii.getImage();
        }
        return animalImage;
    }

    public void init() {
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean closeWindow() {
        this.setVisible(false);
        return true;
    }

    public Container workContainer() {
        return this.getContentPane();
    }

    public ImageIcon getImageIcon(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        ImageIcon icon = null;
        URL url = null;
        if (this.animalImageDummy == null) {
            try {
                this.animalImageDummy = Class.forName("graphics.AnimalImageDummy");
            }
            catch (ClassNotFoundException cfe) {
                System.err.println("AnimalImageDummy could not be found!");
            }
        }
        if (this.animalImageDummy != null) {
            ClassLoader cl = this.animalImageDummy.getClassLoader();
            if (cl != null) {
                url = cl.getResource("graphics/" + name);
                if (url != null && (icon = new ImageIcon(url)) != null) {
                    return icon;
                }
                System.err.println("trying again, this failed... for graphics/" + name);
            } else {
                System.err.println("ClassLoader failed, null!");
            }
        }
        if (this.animalImageDummy != null) {
            url = this.animalImageDummy.getResource(GRAPHICS_PATH + name);
            if (url != null) {
                System.err.println("URL for image is " + url.toString());
            } else {
                System.err.println("Oops, url is now null for image " + name);
            }
        } else {
            System.err.println("Argh for " + name + "!");
            url = this.getClass().getResource(GRAPHICS_PATH + name);
        }
        if (url == null) {
            MessageDisplay.errorMsg("iconNotFound", String.valueOf(name) + " - 1", 8);
        } else {
            icon = new ImageIcon(url);
            if (icon == null) {
                MessageDisplay.errorMsg("iconNotFound", String.valueOf(name) + " - 2", 8);
            } else if (icon.getImageLoadStatus() == 4) {
                MessageDisplay.errorMsg("iconNotFound", String.valueOf(name) + " - 3", 8);
            }
        }
        return icon;
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        int i = 0;
        while (i < components.length) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
            ++i;
        }
        this.fComponentsAdjusted = true;
    }

    class AnimalFrameListener
    extends WindowAdapter {
        AnimalFrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (e.getSource() == AnimalFrame.this) {
                AnimalFrame.this.closeWindow();
            }
        }
    }
}

