/*
 * Decompiled with CFR 0.152.
 */
package animal.handler;

import animal.animator.IndexedContentProperty;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTMatrix;
import animal.handler.GraphicObjectHandler;
import animal.misc.MSMath;
import java.awt.Color;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.util.Vector;

public abstract class MatrixHandler
extends GraphicObjectHandler {
    public static final String MATRIX_METHOD_SET_TEXT = "Method.setText";
    public static final String MATRIX_METHOD_SET_HIGHLIGHTED = "Method.setHighlighted";
    public static final String MATRIX_METHOD_SET_UNHIGHLIGHTED = "Method.setUnhighlighted";
    public static final String MATRIX_METHOD_SET_ELEMENT_HIGHLIGHTED = "Method.setElemHighlighted";
    public static final String MATRIX_METHOD_SET_ELEMENT_UNHIGHLIGHTED = "Method.setElemUnhighlighted";
    public static final String MATRIX_METHOD_SET_VISIBLE = "Method.setVisible";
    public static final String MATRIX_METHOD_SET_INVISIBLE = "Method.setInvisible";
    public static final String MATRIX_METHOD_SET_OUTLINED = "Method.setOutlined";
    public static final String MATRIX_METHOD_SET_NOTOUTLINED = "Method.setNotOutlined";
    public static final String MATRIX_METHOD_SET_DIAGONAL_DOWN = "Matrix.methodSetDiagonalDown";
    public static final String MATRIX_METHOD_SET_DIAGONAL_UP = "Matrix.methodSetDiagonalUp";

    @Override
    public Vector<String> getMethods(PTGraphicObject ptgo, Object obj) {
        Vector<String> result = new Vector<String>();
        PTMatrix matrix = null;
        if (!(ptgo instanceof PTMatrix)) {
            return result;
        }
        matrix = (PTMatrix)ptgo;
        if (obj instanceof Color) {
            result.addElement("color");
            result.addElement("fillColor");
            result.addElement("highlightColor");
            result.addElement("elementHighlightColor");
        } else if (obj instanceof Point) {
            result.addElement("translate");
        } else if (obj instanceof Boolean) {
            result.addElement("show");
            result.addElement("hide");
            int r = 0;
            while (r < matrix.getRowCount()) {
                int c = 0;
                while (c < matrix.getColumnCount(r)) {
                    result.addElement("showCell row: " + r + " column: " + c);
                    result.addElement("hideCell row: " + r + " column: " + c);
                    ++c;
                }
                ++r;
            }
        } else if (obj instanceof double[]) {
            result.addElement("highlight cell elements");
            result.addElement("highlight cells");
            result.addElement("unhighlight cell elements");
            result.addElement("unhighlight cells");
            result.addElement("set cell elements visible");
            result.addElement("set cells visible");
            result.addElement("set cell elements invisible");
            result.addElement("set cells invisible");
        } else if (obj instanceof IndexedContentProperty) {
            Object property = ((IndexedContentProperty)obj).getProperty();
            if (property instanceof String) {
                result.addElement("Matrix.cellIdentifier Method.setText");
                result.add("Matrix.cellIdentifier Matrix.methodSetDiagonalDown");
                result.add("Matrix.cellIdentifier Matrix.methodSetDiagonalUp");
            } else if (property instanceof Double) {
                result.addElement("Matrix.cellIdentifier Method.setHighlighted");
                result.addElement("Matrix.cellIdentifier Method.setUnhighlighted");
                result.addElement("Matrix.cellIdentifier Method.setElemHighlighted");
                result.addElement("Matrix.cellIdentifier Method.setElemUnhighlighted");
                result.addElement("Matrix.cellIdentifier Method.setVisible");
                result.addElement("Matrix.cellIdentifier Method.setInvisible");
                result.addElement("Matrix.cellIdentifier Method.setOutlined");
                result.addElement("Matrix.cellIdentifier Method.setNotOutlined");
            }
        }
        this.addExtensionMethodsFor(ptgo, obj, result);
        return result;
    }

    @Override
    public void propertyChange(PTGraphicObject ptgo, PropertyChangeEvent e) {
        PTMatrix matrix = null;
        if (ptgo instanceof PTMatrix) {
            matrix = (PTMatrix)ptgo;
            String what = e.getPropertyName();
            if (what.equalsIgnoreCase("color")) {
                matrix.setColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("fillColor")) {
                matrix.setFillColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("textColor")) {
                matrix.setTextColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("highlightColor")) {
                matrix.setHighlightColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("textColor")) {
                matrix.setElemHighlightColor((Color)e.getNewValue());
            } else if (what.equalsIgnoreCase("translate")) {
                Point old = (Point)e.getOldValue();
                Point now = (Point)e.getNewValue();
                Point diff = MSMath.diff(now, old);
                matrix.translate(diff.x, diff.y);
            } else if (e.getNewValue() instanceof IndexedContentProperty && ((IndexedContentProperty)e.getNewValue()).getProperty() instanceof String) {
                String[] tokens = what.split("\\s");
                if (tokens.length >= 3 && tokens[2].length() > 4) {
                    String[] indexTuples = tokens[2].contains("][") ? tokens[2].substring(2, tokens[2].length() - 2).split("\\]\\[") : new String[]{tokens[2].substring(2, tokens[2].length() - 2)};
                    int i = 0;
                    while (i < indexTuples.length) {
                        String[] indices = indexTuples[i].split(",");
                        if (indices.length > 1) {
                            try {
                                String value = (String)((IndexedContentProperty)e.getNewValue()).getProperty();
                                int r = Integer.parseInt(indices[0]);
                                int c = Integer.parseInt(indices[1]);
                                if (r == -1) {
                                    int row = 0;
                                    while (row < matrix.getRowCount()) {
                                        if (c == -1) {
                                            int column = 0;
                                            while (column < matrix.getColumnCount(row)) {
                                                this.handleTextDataMethod(row, column, value, matrix, tokens[1]);
                                                ++column;
                                            }
                                        } else {
                                            this.handleTextDataMethod(row, c, value, matrix, tokens[1]);
                                        }
                                        ++row;
                                    }
                                } else if (c == -1) {
                                    int column = 0;
                                    while (column < matrix.getColumnCount(r)) {
                                        this.handleTextDataMethod(r, column, value, matrix, tokens[1]);
                                        ++column;
                                    }
                                } else {
                                    this.handleTextDataMethod(r, c, value, matrix, tokens[1]);
                                }
                            }
                            catch (NumberFormatException column) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                }
            } else if (e.getNewValue() instanceof IndexedContentProperty && ((IndexedContentProperty)e.getNewValue()).getProperty() instanceof Double) {
                String[] tokens = what.split("\\s");
                if (tokens.length >= 3 && tokens[2].length() > 4) {
                    String[] indexTuples = tokens[2].contains("][") ? tokens[2].substring(2, tokens[2].length() - 2).split("\\]\\[") : new String[]{tokens[2].substring(2, tokens[2].length() - 2)};
                    int i = 0;
                    while (i < indexTuples.length) {
                        String[] indices = indexTuples[i].split(",");
                        if (indices.length > 1) {
                            try {
                                double value = (Double)((IndexedContentProperty)e.getNewValue()).getProperty();
                                int r = Integer.parseInt(indices[0]);
                                int c = Integer.parseInt(indices[1]);
                                if (r == -1) {
                                    int row = 0;
                                    while (row < matrix.getRowCount()) {
                                        if (c == -1) {
                                            int column = 0;
                                            while (column < matrix.getColumnCount(row)) {
                                                this.handleDoublePropertyChange(row, column, value, tokens[1], matrix);
                                                ++column;
                                            }
                                        } else {
                                            this.handleDoublePropertyChange(row, c, value, tokens[1], matrix);
                                        }
                                        ++row;
                                    }
                                } else if (c == -1) {
                                    int column = 0;
                                    while (column < matrix.getColumnCount(r)) {
                                        this.handleDoublePropertyChange(r, column, value, tokens[1], matrix);
                                        ++column;
                                    }
                                } else {
                                    this.handleDoublePropertyChange(r, c, value, tokens[1], matrix);
                                }
                            }
                            catch (NumberFormatException exc) {
                                double d = 0.0;
                            }
                        }
                        ++i;
                    }
                }
            } else {
                super.propertyChange(ptgo, e);
            }
        }
    }

    private void handleTextDataMethod(int row, int column, String value, PTMatrix matrix, String selectedMethod) {
        if (selectedMethod.equals(MATRIX_METHOD_SET_TEXT)) {
            this.setDataAt(row, column, value, matrix);
        } else if (selectedMethod.equals(MATRIX_METHOD_SET_DIAGONAL_DOWN)) {
            matrix.setDiagonalElements(row, column, value, true);
        } else if (selectedMethod.equals(MATRIX_METHOD_SET_DIAGONAL_UP)) {
            matrix.setDiagonalElements(row, column, value, false);
        }
    }

    protected abstract void setDataAt(int var1, int var2, String var3, PTMatrix var4);

    private void handleDoublePropertyChange(int r, int c, double value, String selectedMethod, PTMatrix matrix) {
        if (selectedMethod.equals(MATRIX_METHOD_SET_HIGHLIGHTED)) {
            if (value > 0.95) {
                matrix.setHighlighted(r, c, true);
            } else {
                this.setFadeColorBackground(r, c, value, matrix.getHighlightColor(), matrix);
            }
        } else if (selectedMethod.equals(MATRIX_METHOD_SET_UNHIGHLIGHTED)) {
            if (value > 0.95) {
                matrix.setHighlighted(r, c, false);
            } else {
                this.setFadeColorBackground(r, c, value, matrix.getFillColor(), matrix);
            }
        } else if (selectedMethod.equals(MATRIX_METHOD_SET_ELEMENT_HIGHLIGHTED)) {
            if (value > 0.95) {
                matrix.setElementHighlighted(r, c, true);
            } else {
                this.setFadeColorText(r, c, value, matrix.getElemHighlightColor(), matrix);
            }
        } else if (selectedMethod.equals(MATRIX_METHOD_SET_ELEMENT_UNHIGHLIGHTED)) {
            if (value > 0.95) {
                matrix.setElementHighlighted(r, c, false);
            } else {
                this.setFadeColorText(r, c, value, matrix.getTextColor(), matrix);
            }
        } else if (selectedMethod.equals(MATRIX_METHOD_SET_VISIBLE)) {
            if (value > 0.95) {
                matrix.setVisible(r, c, true);
            } else {
                this.setFadeColorText(r, c, value, matrix.getTextColor(), matrix);
            }
        } else if (selectedMethod.equals(MATRIX_METHOD_SET_INVISIBLE)) {
            if (value > 0.95) {
                matrix.setVisible(r, c, false);
            } else {
                this.setFadeColorText(r, c, value, matrix.getFillColor(), matrix);
            }
        } else if (selectedMethod.equals(MATRIX_METHOD_SET_OUTLINED)) {
            if (value > 0.95) {
                matrix.setOutlined(r, c, true);
            } else {
                this.setFadeColorOutline(r, c, value, matrix.getColor(), matrix);
            }
        } else if (selectedMethod.equals(MATRIX_METHOD_SET_NOTOUTLINED)) {
            if (value > 0.95) {
                matrix.setOutlined(r, c, false);
            } else {
                this.setFadeColorOutline(r, c, value, matrix.getFillColor(), matrix);
            }
        }
    }

    private void setFadeColorText(int r, int c, double value, Color endColor, PTMatrix matrix) {
        matrix.setCellTextColor(r, c, this.calcFadeColor(matrix.getTextColor(r, c), endColor, value));
    }

    private void setFadeColorBackground(int r, int c, double value, Color endColor, PTMatrix matrix) {
        matrix.setCellFillColor(r, c, this.calcFadeColor(matrix.getFillColor(r, c), endColor, value));
    }

    private void setFadeColorOutline(int r, int c, double value, Color endColor, PTMatrix matrix) {
        matrix.setCellColor(r, c, this.calcFadeColor(matrix.getColor(r, c), endColor, value));
    }

    private Color calcFadeColor(Color startColor, Color endColor, double value) {
        int r = (int)((double)startColor.getRed() * (1.0 - value) + (double)endColor.getRed() * value);
        int g = (int)((double)startColor.getRed() * (1.0 - value) + (double)endColor.getRed() * value);
        int b = (int)((double)startColor.getRed() * (1.0 - value) + (double)endColor.getRed() * value);
        return new Color(r, g, b);
    }
}

