/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics.meta;

import animal.graphics.PTPoint;
import animal.graphics.meta.FillablePrimitive;
import animal.graphics.meta.LineBasedShape;
import animal.main.AnimalConfiguration;
import animal.misc.MSMath;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Vector;

public abstract class PolygonalShape
extends LineBasedShape
implements FillablePrimitive {
    protected Color fillColor;
    protected boolean isFilled = false;

    @Override
    public Color getFillColor() {
        if (this.fillColor == null) {
            this.fillColor = AnimalConfiguration.getDefaultConfiguration().getDefaultColor(this.getType(), "fillColor", Color.BLACK);
        }
        return this.fillColor;
    }

    @Override
    public int getLength() {
        int result = super.getLength();
        return result += MSMath.dist(this.getNodeAt(this.getNodeCount() - 1), this.getNodeAt(0));
    }

    @Override
    public Point getPointAtLength(int length) {
        int lineLength;
        Point a;
        int currentLength = length;
        if (this.nodes == null || this.nodes.size() < 2) {
            return new Point(0, 0);
        }
        Point b = null;
        int i = 0;
        while (i < this.getNodeCount() - 1) {
            a = this.getNodeAt(i).toPoint();
            lineLength = MSMath.dist(a, b = this.getNodeAt(i + 1).toPoint());
            if (lineLength >= currentLength) {
                float percent = 1.0f * (float)currentLength / (float)lineLength;
                return new Point((int)((float)a.x + (float)(b.x - a.x) * percent), (int)((float)a.y + (float)(b.y - a.y) * percent));
            }
            currentLength -= lineLength;
            ++i;
        }
        a = this.getNodeAsPoint(0);
        if (b != null && (lineLength = MSMath.dist(b, a)) >= currentLength) {
            float percent = 1.0f * (float)currentLength / (float)lineLength;
            return new Point((int)((float)b.x + (float)(a.x - b.x) * percent), (int)((float)b.y + (float)(a.y - b.y) * percent));
        }
        return this.getNodeAt(0).toPoint();
    }

    @Override
    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.isFilled = config.getDefaultBooleanValue(primitiveName, "filled", false);
        this.fillColor = config.getDefaultColor(primitiveName, "fillColor", Color.BLACK);
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    @Override
    public void setFillColor(Color c) {
        this.fillColor = c != null ? c : Color.BLACK;
    }

    @Override
    public void setFilled(boolean filled) {
        this.isFilled = filled;
    }

    protected String toString(String objectName) {
        StringBuilder result = new StringBuilder(120);
        result.append(objectName).append(' ');
        if (this.getObjectName() != null) {
            result.append("\"").append(this.getObjectName()).append("\" ");
        }
        for (PTPoint node : this.nodes) {
            if (node == null) continue;
            result.append(this.nodeToString(node.toPoint()));
        }
        return result.toString();
    }

    @Override
    public void useAsMoveBase() {
        this.setFilled(false);
    }

    @Override
    public void paint(Graphics g) {
        Polygon poly = this.toPolygon();
        if (this.isFilled()) {
            g.setColor(this.getFillColor());
            g.fillPolygon(poly);
        }
        g.setColor(this.getColor());
        g.drawPolygon(poly);
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".fillColor", this.getFillColor());
        defaultProperties.put(String.valueOf(this.getType()) + ".filled", this.isFilled());
    }

    protected void cloneCommonFeaturesInto(PolygonalShape targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setFilled(this.isFilled());
        targetShape.setFillColor(this.createColor(this.getFillColor()));
        if (this.nodes != null) {
            targetShape.nodes = new Vector(this.nodes.size());
            for (PTPoint node : this.nodes) {
                targetShape.nodes.add((PTPoint)node.clone());
            }
        }
    }

    @Override
    public void discard() {
        super.discard();
        this.fillColor = null;
    }
}

