/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.graphics.PTGraphicObject;
import animal.misc.XProperties;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTPoint
extends PTGraphicObject
implements Cloneable {
    public static final PTPoint POINT_OF_ORIGIN = new PTPoint(0, 0);
    public static final String POINT_TYPE = "Point";
    private static final long serialVersionUID = 5578116484265222226L;
    private double[] coord = new double[3];

    public PTPoint() {
        this(0, 0, 0);
    }

    public PTPoint(int theX, int theY, int theW) {
        this.initializeWithDefaults(this.getType());
        this.set(theX, theY, theW);
    }

    public PTPoint(int x, int y) {
        this(x, y, 0);
    }

    public PTPoint(PTPoint p) {
        this(p.getX(), p.getY(), p.getW());
    }

    public PTPoint(Point aPoint) {
        this(aPoint.x, aPoint.y, 0);
    }

    @Override
    public int getFileVersion() {
        return 2;
    }

    @Override
    public String getType() {
        return POINT_TYPE;
    }

    public int getX() {
        return (int)Math.round(this.coord[0]);
    }

    public int getY() {
        return (int)Math.round(this.coord[1]);
    }

    public int getW() {
        return (int)Math.round(this.coord[2]);
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{POINT_TYPE};
    }

    public void set(double x, double y, double w) {
        this.coord[0] = x;
        this.coord[1] = y;
        this.coord[2] = w;
    }

    public void set(Point p) {
        this.set(p.x, p.y, 1.0);
    }

    public void setW(int value) {
        this.coord[2] = value;
    }

    public void setX(int value) {
        this.coord[0] = value;
    }

    public void setY(int value) {
        this.coord[1] = value;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getColor());
        g.drawLine(this.getX(), this.getY(), this.getX(), this.getY());
    }

    public void rotate(double angle) {
        double cosi = Math.cos(angle);
        double sini = Math.sin(angle);
        double[] tmp = new double[]{0.0, 0.0, 0.0};
        double[][] rotationMatrix = new double[][]{{cosi, -sini, 0.0}, {sini, cosi, 0.0}, {0.0, 0.0, 1.0}};
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int n = i;
                tmp[n] = tmp[n] + rotationMatrix[i][j] * this.coord[j];
                ++j;
            }
            ++i;
        }
        this.set(tmp[0], tmp[1], tmp[2]);
    }

    public void rotate(double angle, PTPoint center) {
        this.translate(-center.getX(), -center.getY());
        this.rotate(angle);
        this.translate(center.getX(), center.getY());
    }

    public void scale(double xScaleFactor, double yScaleFactor) {
        this.set(this.coord[0] * xScaleFactor, this.coord[1] * yScaleFactor, this.coord[2]);
    }

    public void shear(double xShearFactor, double yShearFactor) {
        this.set(this.coord[0] + xShearFactor * this.coord[1], this.coord[1] + yShearFactor * this.coord[0], this.coord[2]);
    }

    @Override
    public void translate(int deltaX, int deltaY) {
        this.set(this.coord[0] + (double)deltaX, this.coord[1] + (double)deltaY, this.coord[2]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        sb.append("Point ");
        if (this.getObjectName() != null) {
            sb.append("\"").append(this.getObjectName()).append("\" ");
        }
        sb.append("(").append(this.getX()).append(", ").append(this.getY()).append(")");
        return sb.toString();
    }

    public Point toPoint() {
        return new Point(this.getX(), this.getY());
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".location", new Point(this.getX(), this.getY()));
    }

    @Override
    public Object clone() {
        PTPoint p = new PTPoint();
        this.cloneCommonFeaturesInto(p);
        return p;
    }

    protected void cloneCommonFeaturesInto(PTPoint targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.coord = (double[])this.coord.clone();
    }

    @Override
    public Rectangle getBoundingBox() {
        return new Rectangle(this.toPoint());
    }

    @Override
    public void discard() {
        this.coord = null;
        super.discard();
    }
}

