/*
 * Decompiled with CFR 0.152.
 */
package animal.graphics;

import animal.animator.MoveBase;
import animal.graphics.PTText;
import animal.graphics.meta.ArrowablePrimitive;
import animal.graphics.meta.FillablePrimitive;
import animal.graphics.meta.ImmediateTextContainer;
import animal.graphics.meta.OpenArcBasedShape;
import animal.main.Animal;
import animal.main.AnimalConfiguration;
import animal.misc.XProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class PTArc
extends OpenArcBasedShape
implements ArrowablePrimitive,
FillablePrimitive,
ImmediateTextContainer,
MoveBase {
    public static final String TYPE_LABEL = "Arc";
    private static final long serialVersionUID = 4711724437159551059L;
    private Color fillColor;
    private boolean hasTextComponent = false;
    private boolean isCircular;
    private boolean isClosed;
    private boolean isFilled;
    private Point radius = new Point(10, 10);
    private PTText textComponent;

    public PTArc() {
        this.initializeWithDefaults(this.getType());
    }

    @Override
    public Object clone() {
        PTArc targetShape = new PTArc();
        this.cloneCommonFeaturesInto(targetShape);
        return targetShape;
    }

    protected void cloneCommonFeaturesInto(PTArc targetShape) {
        super.cloneCommonFeaturesInto(targetShape);
        targetShape.setCircle(this.isCircular);
        targetShape.setClosed(this.isClosed);
        targetShape.setFilled(this.isFilled());
        targetShape.setFillColor(this.createColor(this.getFillColor()));
        targetShape.setRadius(new Point(this.getXRadius(), this.getYRadius()));
        targetShape.setText(new String(this.getTextComponent().getText()));
        targetShape.setTextColor(this.createColor(this.getTextComponent().getColor()));
    }

    @Override
    public void paint(Graphics g) {
        if (this.center == null || this.radius == null) {
            return;
        }
        int xRadius = this.getXRadius();
        int yRadius = this.getYRadius();
        if (this.isFilled()) {
            g.setColor(this.fillColor);
            g.fillArc(this.center.x - xRadius, this.center.y - yRadius, xRadius * 2, yRadius * 2, this.startAngle, this.totalAngle);
        }
        g.setColor(this.color);
        if ((this.isClosed || this.isFilled) && this.totalAngle % 360 != 0) {
            Point a = this.getPointAtAngle(this.startAngle);
            g.drawLine(this.center.x, this.center.y, a.x, a.y);
            a = this.getPointAtAngle(this.startAngle + this.totalAngle);
            g.drawLine(this.center.x, this.center.y, a.x, a.y);
        }
        super.paint(g, this.radius.x, this.radius.y);
        if (this.hasTextComponent) {
            this.getTextComponent().paint(g);
        }
    }

    @Override
    public void useAsMoveBase() {
        this.setFilled(false);
        this.setClosed(false);
        this.setFWArrow(true);
        this.setBWArrow(false);
    }

    public int getAngle(Point p) {
        return this.getAngle(p, this.radius.x, this.radius.y);
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.getBoundingBox(this.radius.x, this.radius.y);
    }

    @Override
    public int getFileVersion() {
        return 5;
    }

    @Override
    public Color getFillColor() {
        if (this.fillColor == null) {
            this.fillColor = Color.BLACK;
        }
        return this.fillColor;
    }

    @Override
    public Font getFont() {
        return this.getTextComponent().getFont();
    }

    @Override
    public int getLength() {
        return Math.abs(this.getTotalAngle());
    }

    public Point getPointAtAngle(int alpha) {
        return this.getPointAtLength(alpha, this.radius.x, this.radius.y);
    }

    @Override
    public Point getPointAtLength(int x) {
        return this.getPointAtAngle(this.getStartAngle() + (this.isClockwise() ? -1 : 1) * x);
    }

    public int getRadius() {
        return (this.getXRadius() + this.getYRadius()) / 2;
    }

    public Point getRadiusPoint() {
        if (this.radius == null) {
            this.radius = new Point(10, 10);
        }
        return this.radius;
    }

    @Override
    public String getText() {
        return this.getTextComponent().getText();
    }

    public PTText getTextComponent() {
        if (this.textComponent == null) {
            this.initTextComponent();
        }
        this.hasTextComponent = true;
        return this.textComponent;
    }

    @Override
    public String getType() {
        return TYPE_LABEL;
    }

    public int getXRadius() {
        return this.getRadiusPoint().x;
    }

    public int getYRadius() {
        return this.getRadiusPoint().y;
    }

    @Override
    public String[] handledKeywords() {
        return new String[]{TYPE_LABEL};
    }

    @Override
    public void initializeWithDefaults(String primitiveName) {
        super.initializeWithDefaults(primitiveName);
        this.center = new Point(0, 0);
        AnimalConfiguration config = AnimalConfiguration.getDefaultConfiguration();
        this.isFilled = config.getDefaultBooleanValue(primitiveName, "filled", false);
        this.fillColor = config.getDefaultColor(primitiveName, "fillColor", Color.BLACK);
    }

    public void initTextComponent() {
        this.textComponent = new PTText();
        this.textComponent.setText("");
        this.textComponent.setPosition(this.center);
    }

    public boolean isAngleInside(int angle) {
        if (this.isClockwise()) {
            if (-this.totalAngle < this.startAngle) {
                return angle < this.startAngle && angle > this.startAngle + this.totalAngle;
            }
            return angle < this.startAngle || angle > this.startAngle + this.totalAngle + 360;
        }
        if (this.startAngle + this.totalAngle < 360) {
            return angle > this.startAngle && angle < this.startAngle + this.totalAngle;
        }
        return angle > this.startAngle || angle < this.startAngle + this.totalAngle - 360;
    }

    public boolean isCircular() {
        return this.isCircular;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isFilled() {
        return this.isFilled;
    }

    public void setCircle(boolean b) {
        this.isCircular = b;
        if (this.isCircular) {
            this.setRadius(this.getRadius());
        }
    }

    public void setClosed(boolean closed) {
        this.isClosed = closed;
    }

    @Override
    public void setFillColor(Color targetFillColor) {
        this.fillColor = targetFillColor;
    }

    @Override
    public void setFilled(boolean filled) {
        this.isFilled = filled;
    }

    @Override
    public void setFont(Font targetFont) {
        this.getTextComponent().setFont(targetFont);
    }

    public void setRadius(int r) {
        this.setRadius(new Point(r, r));
    }

    public void setRadius(Point newRadius) {
        if (newRadius != null) {
            if (this.radius == null) {
                this.radius = new Point(newRadius.x, newRadius.y);
            } else {
                this.radius.setLocation(newRadius.x, newRadius.y);
            }
        }
    }

    @Override
    public void setText(String newText) {
        if (newText != null) {
            this.getTextComponent().setText(newText);
            Font currentFont = this.textComponent.getFont();
            int width = Animal.getStringWidth(newText, currentFont);
            this.textComponent.setPosition(this.center.x - width / 2, this.center.y + currentFont.getSize() / 2);
        }
    }

    public void setTextColor(Color aTextColor) {
        this.getTextComponent().setColor(aTextColor);
    }

    public void setXRadius(int r) {
        if (this.radius == null) {
            this.radius = new Point(r, r);
        } else {
            this.radius.x = r;
        }
    }

    public void setYRadius(int r) {
        if (this.radius == null) {
            this.radius = new Point(r, r);
        } else {
            this.radius.x = r;
        }
    }

    public String toString() {
        return this.toString(this.getType(), this.isCircular, this.radius.x, this.radius.y);
    }

    @Override
    public void updateDefaults(XProperties defaultProperties) {
        super.updateDefaults(defaultProperties);
        defaultProperties.put(String.valueOf(this.getType()) + ".circle", this.isCircular());
        defaultProperties.put(String.valueOf(this.getType()) + ".closed", this.isClosed());
        defaultProperties.put(String.valueOf(this.getType()) + ".fillColor", this.fillColor);
        defaultProperties.put(String.valueOf(this.getType()) + ".filled", this.isFilled());
        if (this.isCircular()) {
            defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadius());
        } else {
            defaultProperties.put(String.valueOf(this.getType()) + ".radius", this.getRadiusPoint());
        }
        if (this.textComponent != null) {
            defaultProperties.put(String.valueOf(this.getType()) + ".text", this.textComponent.getText());
            defaultProperties.put(String.valueOf(this.getType()) + ".textColor", this.textComponent.getColor());
            Font f = this.textComponent.getFont();
            defaultProperties.put(String.valueOf(this.getType()) + ".bold", f.isBold());
            defaultProperties.put(String.valueOf(this.getType()) + ".fontName", f.getFamily());
            defaultProperties.put(String.valueOf(this.getType()) + ".fontSize", f.getSize());
            defaultProperties.put(String.valueOf(this.getType()) + ".italic", f.isItalic());
        }
    }

    @Override
    public void discard() {
        super.discard();
        this.fillColor = null;
        this.radius = null;
        this.textComponent = null;
    }
}

