/*
 * Decompiled with CFR 0.152.
 */
package animal.exchange.animalscript2;

import algoanim.primitives.IntArray;
import algoanim.primitives.generators.Language;
import algoanim.properties.ArrayProperties;
import algoanim.util.ArrayDisplayOptions;
import algoanim.util.Coordinates;
import algoanim.util.Node;
import algoanim.util.Timing;
import animal.exchange.animalscript2.PTGraphicObjectExporter;
import animal.graphics.PTGraphicObject;
import animal.graphics.PTIntArray;

public class PTIntArrayExporter
extends PTGraphicObjectExporter {
    @Override
    public void export(Language lang, PTGraphicObject ptgo, boolean isVisible, int offset, int duration, boolean timeUnitIsTicks) {
        PTIntArray shape = (PTIntArray)ptgo;
        if (PTIntArrayExporter.getExportStatus(shape)) {
            lang.addLine("# previously exported: '" + shape.getNum(false) + "/" + shape.getObjectName());
        }
        ArrayProperties ap = new ArrayProperties();
        this.installStandardProperties(ap, shape, isVisible);
        ap.set("fillColor", shape.getBGColor());
        ap.set("filled", true);
        ap.set("elementColor", shape.getFontColor());
        ap.set("elemHighlight", shape.getElemHighlightColor());
        ap.set("cellHighlight", shape.getHighlightColor());
        ap.set("vertical", false);
        ap.set("cascaded", false);
        Coordinates upperLeft = Node.convertToNode(shape.getBoundingBox().getLocation());
        Timing t = this.createTiming(lang, offset, timeUnitIsTicks);
        ArrayDisplayOptions ado = new ArrayDisplayOptions(t, null, false);
        IntArray result = lang.newIntArray(upperLeft, shape.getValues(), shape.getNumericIDs(), ado, ap);
        hasBeenExported.put(shape.getNum(false), result);
    }
}

